/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gears.modules.r.profile;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Documentation;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Out;
import oms3.annotations.Status;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.hortonmachine.gears.libs.exceptions.ModelsIllegalargumentException;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.gears.utils.coverage.CoverageUtilities;
import org.hortonmachine.gears.utils.coverage.ProfilePoint;
import org.hortonmachine.gears.utils.features.FeatureMate;
import org.hortonmachine.gears.utils.features.FeatureUtilities;
import org.hortonmachine.gears.utils.files.FileUtilities;
import org.hortonmachine.gears.utils.geometry.EGeometryType;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;

@Description(value="Module creating profiles over rasters.")
@Documentation(value="")
@Author(name="Andrea Antonello", contact="http://www.hydrologis.com")
@Keywords(value="OmsProfile, Raster")
@Label(value="Raster Processing")
@Name(value="profile")
@Status(value=5)
@License(value="General Public License Version 3 (GPLv3)")
public class OmsProfile
extends HMModel {
    @Description(value="The raster map to use for the profile")
    @In
    public GridCoverage2D inRaster;
    @Description(value="Comma separated list of easting,northing coordinates to trace the profile on (optional).")
    @In
    public String inCoordinates;
    @Description(value="Line vector map to use to trace the profile on (optional).")
    @In
    public SimpleFeatureCollection inVector;
    @Description(value="The id of the line to use for the name of the profile output file name (used in case of inVector use).")
    @In
    public String fLineid;
    @Description(value="The folder in which to place the output profiles if multiple (used in case of inVector use).")
    @In
    public String outFolder;
    @Description(value="The output profile for the last line read (contains progressive, elevation, x, y).")
    @Out
    public double[][] outProfile;
    public static final String OMSPROFILE_DESCRIPTION = "Module creating profiles over rasters.";
    public static final String OMSPROFILE_DOCUMENTATION = "";
    public static final String OMSPROFILE_KEYWORDS = "OmsProfile, Raster";
    public static final String OMSPROFILE_LABEL = "Raster Processing";
    public static final String OMSPROFILE_NAME = "profile";
    public static final int OMSPROFILE_STATUS = 5;
    public static final String OMSPROFILE_LICENSE = "General Public License Version 3 (GPLv3)";
    public static final String OMSPROFILE_AUTHORNAMES = "Andrea Antonello";
    public static final String OMSPROFILE_AUTHORCONTACTS = "http://www.hydrologis.com";
    public static final String OMSPROFILE_IN_RASTER_DESCRIPTION = "The raster map to use for the profile";
    public static final String OMSPROFILE_IN_COORDINATES_DESCRIPTION = "Comma separated list of easting,northing coordinates to trace the profile on (optional).";
    public static final String OMSPROFILE_IN_VECTOR_DESCRIPTION = "Line vector map to use to trace the profile on (optional).";
    public static final String OMSPROFILE_F_LINE_ID_DESCRIPTION = "The id of the line to use for the name of the profile output file name (used in case of inVector use).";
    public static final String OMSPROFILE_OUT_FOLDER_DESCRIPTION = "The folder in which to place the output profiles if multiple (used in case of inVector use).";
    public static final String OMSPROFILE_OUT_PROFILE_DESCRIPTION = "The output profile for the last line read (contains progressive, elevation, x, y).";

    @Execute
    public void process() throws Exception {
        this.checkNull(this.inRaster);
        if (this.inCoordinates == null && this.inVector == null) {
            throw new ModelsIllegalargumentException("Either the coordinates or a vector map to trace the profile on have to be supplied.", this, this.pm);
        }
        if (this.inCoordinates != null && this.inCoordinates.length() > 0) {
            this.profileFromManualCoordinates();
        } else if (this.inVector != null) {
            if (this.inVector != null && this.inVector.size() != 1) {
                this.checkNull(this.outFolder, this.fLineid);
            }
            this.profileFromFeatureCollection();
        }
    }

    private void profileFromFeatureCollection() throws Exception {
        this.pm.message("Using supplied vector map to trace the profile...");
        List<FeatureMate> linesList = FeatureUtilities.featureCollectionToMatesList(this.inVector);
        for (FeatureMate lineFeature : linesList) {
            Geometry geom = lineFeature.getGeometry();
            ArrayList<Coordinate> profileNodesList = new ArrayList<Coordinate>();
            if (EGeometryType.isLine(geom)) {
                Coordinate[] coordinates;
                for (Coordinate coordinate : coordinates = geom.getCoordinates()) {
                    profileNodesList.add(coordinate);
                }
            } else {
                throw new ModelsIllegalargumentException("The module works only for lines.", this, this.pm);
            }
            List<ProfilePoint> profilePoints = CoverageUtilities.doProfile(this.inRaster, profileNodesList.toArray(new Coordinate[0]));
            this.outProfile = new double[profilePoints.size()][4];
            for (int i = 0; i < profilePoints.size(); ++i) {
                ProfilePoint profilePoint = profilePoints.get(i);
                double progressive = profilePoint.getProgressive();
                double elev = profilePoint.getElevation();
                Coordinate coord = profilePoint.getPosition();
                this.outProfile[i][0] = progressive;
                this.outProfile[i][1] = elev;
                this.outProfile[i][2] = coord.x;
                this.outProfile[i][3] = coord.y;
            }
            if (this.outFolder != null && this.fLineid != null) {
                String id = lineFeature.getAttribute(this.fLineid, String.class);
                File outFolderFile = new File(this.outFolder);
                File profileFile = new File(outFolderFile, id + ".csv");
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < profilePoints.size(); ++i) {
                    ProfilePoint profilePoint = profilePoints.get(i);
                    double progressive = profilePoint.getProgressive();
                    double elev = profilePoint.getElevation();
                    Coordinate coord = profilePoint.getPosition();
                    sb.append(progressive).append(", ").append(elev).append(", ").append(coord.x).append(", ").append(coord.y).append("\n");
                }
                FileUtilities.writeFile(sb.toString(), profileFile);
                double meanSlope = ProfilePoint.getMeanSlope(profilePoints);
                StringBuilder sbSlope = new StringBuilder();
                sbSlope.append("Mean slope for id = ");
                sbSlope.append(id);
                sbSlope.append(" is ");
                sbSlope.append(meanSlope);
                this.pm.message(sbSlope.toString());
                continue;
            }
            this.pm.errorMessage("Evaluating only first feature when writing to console. If you need the profile of all features, define an output folder.");
            break;
        }
    }

    private void profileFromManualCoordinates() throws Exception {
        ArrayList<Coordinate> profileNodesList = new ArrayList<Coordinate>();
        this.pm.message("Using supplied coordinates to trace the profile...");
        String[] split = this.inCoordinates.split(",");
        for (int i = 0; i < split.length; ++i) {
            double east = Double.parseDouble(split[i].trim());
            double north = Double.parseDouble(split[++i].trim());
            Coordinate tmp = new Coordinate(east, north);
            profileNodesList.add(tmp);
        }
        if (profileNodesList.size() < 2) {
            throw new ModelsIllegalargumentException("We need at least two coordinates to create a profile. Check your syntax.", this, this.pm);
        }
        List<ProfilePoint> profilePoints = CoverageUtilities.doProfile(this.inRaster, profileNodesList.toArray(new Coordinate[0]));
        this.outProfile = new double[profilePoints.size()][4];
        for (int i = 0; i < profilePoints.size(); ++i) {
            ProfilePoint profilePoint = profilePoints.get(i);
            double progressive = profilePoint.getProgressive();
            double elev = profilePoint.getElevation();
            Coordinate coord = profilePoint.getPosition();
            this.outProfile[i][0] = progressive;
            this.outProfile[i][1] = elev;
            this.outProfile[i][2] = coord.x;
            this.outProfile[i][3] = coord.y;
        }
        double meanSlope = ProfilePoint.getMeanSlope(profilePoints);
        StringBuilder sbSlope = new StringBuilder();
        sbSlope.append("Mean slope profile is ");
        sbSlope.append(meanSlope);
        this.pm.message(sbSlope.toString());
    }
}

