/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gears.modules.r.rasterconverter;

import java.awt.image.WritableRaster;
import java.util.HashMap;
import javax.media.jai.iterator.RandomIter;
import javax.media.jai.iterator.WritableRandomIter;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Documentation;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Out;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.geotools.coverage.grid.GridCoverage2D;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.gears.utils.RegionMap;
import org.hortonmachine.gears.utils.coverage.CoverageUtilities;

@Description(value="Raster conversion module.")
@Documentation(value="OmsRasterConverter.html")
@Author(name="Andrea Antonello", contact="http://www.hydrologis.com")
@Keywords(value="IO, Coverage, Raster, Convert, OmsRasterReader")
@Label(value="Raster Processing")
@Name(value="oms_rconvert")
@Status(value=40)
@License(value="General Public License Version 3 (GPLv3)")
public class OmsRasterConverter
extends HMModel {
    @Description(value="The input raster.")
    @In
    public GridCoverage2D inRaster;
    @Description(value="An optional type for the conversion.")
    @UI(value="combo:INTEGER,FLOAT,DOUBLE")
    @In
    public String pOutType = "";
    @Description(value="The output raster.")
    @Out
    public GridCoverage2D outRaster;
    public static final String OMSRASTERCONVERTER_DESCRIPTION = "Raster conversion module.";
    public static final String OMSRASTERCONVERTER_DOCUMENTATION = "OmsRasterConverter.html";
    public static final String OMSRASTERCONVERTER_KEYWORDS = "IO, Coverage, Raster, Convert, OmsRasterReader";
    public static final String OMSRASTERCONVERTER_LABEL = "Raster Processing";
    public static final String OMSRASTERCONVERTER_NAME = "oms_rconvert";
    public static final int OMSRASTERCONVERTER_STATUS = 40;
    public static final String OMSRASTERCONVERTER_LICENSE = "General Public License Version 3 (GPLv3)";
    public static final String OMSRASTERCONVERTER_AUTHORNAMES = "Andrea Antonello";
    public static final String OMSRASTERCONVERTER_AUTHORCONTACTS = "http://www.hydrologis.com";
    public static final String OMSRASTERCONVERTER_IN_RASTER_DESCRIPTION = "The input raster.";
    public static final String OMSRASTERCONVERTER_OUT_RASTER_DESCRIPTION = "The output raster.";
    public static final String OMSRASTERCONVERTER_OUT_RASTER_TYPE = "An optional type for the conversion.";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Execute
    public void process() throws Exception {
        this.checkNull(this.inRaster);
        if (this.pOutType == null || this.pOutType.length() == 0) {
            this.outRaster = this.inRaster;
        } else {
            RegionMap regionMap = CoverageUtilities.getRegionParamsFromGridCoverage(this.inRaster);
            int nCols = regionMap.getCols();
            int nRows = regionMap.getRows();
            RandomIter inIter = CoverageUtilities.getRandomIterator(this.inRaster);
            WritableRaster outWritableRaster = null;
            WritableRandomIter outIter = null;
            try {
                switch (this.pOutType) {
                    case "INTEGER": {
                        outWritableRaster = CoverageUtilities.createWritableRaster(nCols, nRows, Integer.class, null, null);
                        outIter = CoverageUtilities.getWritableRandomIterator(outWritableRaster);
                        this.pm.beginTask("Converting...", nRows);
                        for (int r = 0; r < nRows; ++r) {
                            if (this.pm.isCanceled()) {
                                return;
                            }
                            for (int c = 0; c < nCols; ++c) {
                                int value = inIter.getSample(c, r, 0);
                                outIter.setSample(c, r, 0, value);
                            }
                            this.pm.worked(1);
                        }
                        this.pm.done();
                        break;
                    }
                    case "FLOAT": {
                        outWritableRaster = CoverageUtilities.createWritableRaster(nCols, nRows, Float.class, null, null);
                        outIter = CoverageUtilities.getWritableRandomIterator(outWritableRaster);
                        try {
                            this.pm.beginTask("Converting...", nRows);
                            for (int r = 0; r < nRows; ++r) {
                                if (this.pm.isCanceled()) {
                                    return;
                                }
                                for (int c = 0; c < nCols; ++c) {
                                    float value = inIter.getSampleFloat(c, r, 0);
                                    outIter.setSample(c, r, 0, value);
                                }
                                this.pm.worked(1);
                            }
                            this.pm.done();
                            break;
                        }
                        finally {
                            outIter.done();
                        }
                    }
                    default: {
                        outWritableRaster = CoverageUtilities.createWritableRaster(nCols, nRows, Double.class, null, null);
                        outIter = CoverageUtilities.getWritableRandomIterator(outWritableRaster);
                        try {
                            this.pm.beginTask("Converting...", nRows);
                            for (int r = 0; r < nRows; ++r) {
                                if (this.pm.isCanceled()) {
                                    return;
                                }
                                for (int c = 0; c < nCols; ++c) {
                                    double value = inIter.getSampleDouble(c, r, 0);
                                    outIter.setSample(c, r, 0, value);
                                }
                                this.pm.worked(1);
                            }
                            this.pm.done();
                            break;
                        }
                        finally {
                            outIter.done();
                        }
                    }
                }
                this.outRaster = CoverageUtilities.buildCoverage("converted", outWritableRaster, (HashMap<String, Double>)regionMap, this.inRaster.getCoordinateReferenceSystem());
            }
            finally {
                outIter.done();
                inIter.done();
            }
        }
    }
}

