/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gears.modules.r.rastercorrector;

import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.HashMap;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Documentation;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Out;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.geotools.coverage.grid.GridCoverage2D;
import org.hortonmachine.gears.libs.exceptions.ModelsIllegalargumentException;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.gears.utils.RegionMap;
import org.hortonmachine.gears.utils.coverage.CoverageUtilities;

@Description(value="Raster corrector module.")
@Documentation(value="")
@Author(name="Andrea Antonello", contact="http://www.hydrologis.com")
@Keywords(value="IO, Coverage, Raster, Correct, OmsRasterReader")
@Label(value="Raster Processing")
@Name(value="rcorrect")
@Status(value=5)
@License(value="General Public License Version 3 (GPLv3)")
public class OmsRasterCorrector
extends HMModel {
    @Description(value="The input raster.")
    @In
    public GridCoverage2D inRaster;
    @Description(value="The values to correct as a CSV list of triplets (format is col1,row1,value1,col2,row2,value2...).")
    @UI(value="eastnorth")
    @In
    public String pCorrections;
    @Description(value="The output raster.")
    @Out
    public GridCoverage2D outRaster;

    @Execute
    public void process() throws Exception {
        this.checkNull(this.inRaster, this.pCorrections);
        String[] correctionSplit = this.pCorrections.split(",");
        if (correctionSplit.length % 3 != 0) {
            throw new ModelsIllegalargumentException("the format of the correction values is: col1,row1,value1,col2,row2,value2...", this, this.pm);
        }
        RenderedImage inRI = this.inRaster.getRenderedImage();
        WritableRaster outWR = CoverageUtilities.renderedImage2WritableRaster(inRI, false);
        for (int i = 0; i < correctionSplit.length; i += 3) {
            int col = Integer.parseInt(correctionSplit[i].trim());
            int row = Integer.parseInt(correctionSplit[i + 1].trim());
            double value = Double.parseDouble(correctionSplit[i + 2].trim());
            outWR.setSample(col, row, 0, value);
        }
        RegionMap regionMap = CoverageUtilities.getRegionParamsFromGridCoverage(this.inRaster);
        this.outRaster = CoverageUtilities.buildCoverage("corrected", outWR, (HashMap<String, Double>)regionMap, this.inRaster.getCoordinateReferenceSystem());
    }
}

