/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gears.modules.r.rasterdiff;

import java.awt.image.WritableRaster;
import java.util.HashMap;
import javax.media.jai.iterator.RandomIter;
import javax.media.jai.iterator.RandomIterFactory;
import javax.media.jai.iterator.WritableRandomIter;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Documentation;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Out;
import oms3.annotations.Status;
import org.geotools.coverage.grid.GridCoverage2D;
import org.hortonmachine.gears.libs.modules.HMConstants;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.gears.utils.RegionMap;
import org.hortonmachine.gears.utils.coverage.CoverageUtilities;

@Description(value="Raster diff module.")
@Documentation(value="")
@Author(name="Andrea Antonello", contact="http://www.hydrologis.com")
@Keywords(value="IO, Coverage, Raster, Correct, OmsRasterReader")
@Label(value="Raster Processing")
@Name(value="rdiff")
@Status(value=5)
@License(value="General Public License Version 3 (GPLv3)")
public class OmsRasterDiff
extends HMModel {
    @Description(value="The input raster.")
    @In
    public GridCoverage2D inRaster1;
    @Description(value="The raster to subtract.")
    @In
    public GridCoverage2D inRaster2;
    @Description(value="The threshold, under which to set novalue.")
    @In
    public Double pThreshold;
    @Description(value="Allow negative values.")
    @In
    public boolean doNegatives = true;
    @Description(value="The output raster.")
    @Out
    public GridCoverage2D outRaster;

    @Execute
    public void process() throws Exception {
        this.checkNull(this.inRaster1, this.inRaster2);
        double thres = 0.0;
        if (this.pThreshold != null) {
            thres = this.pThreshold;
        }
        RegionMap regionMap = CoverageUtilities.getRegionParamsFromGridCoverage(this.inRaster1);
        int cols = regionMap.getCols();
        int rows = regionMap.getRows();
        RandomIter r1Iter = CoverageUtilities.getRandomIterator(this.inRaster1);
        RandomIter r2Iter = CoverageUtilities.getRandomIterator(this.inRaster2);
        double r1Nv = HMConstants.getNovalue(this.inRaster1);
        double r2Nv = HMConstants.getNovalue(this.inRaster2);
        WritableRaster outWR = CoverageUtilities.createWritableRaster(cols, rows, null, null, r1Nv);
        WritableRandomIter outIter = RandomIterFactory.createWritable((WritableRaster)outWR, null);
        this.pm.beginTask("Subtracting raster...", cols);
        for (int r = 0; r < rows; ++r) {
            for (int c = 0; c < cols; ++c) {
                double r1 = r1Iter.getSampleDouble(c, r, 0);
                double r2 = r2Iter.getSampleDouble(c, r, 0);
                if (HMConstants.isNovalue(r1, r1Nv) && HMConstants.isNovalue(r2, r2Nv)) continue;
                double diff = HMConstants.isNovalue(r1, r1Nv) ? r2 : (HMConstants.isNovalue(r2, r2Nv) ? r1 : r1 - r2);
                if (!this.doNegatives && diff < 0.0) {
                    diff = 0.0;
                }
                if (this.pThreshold != null && diff < thres) {
                    diff = r1Nv;
                }
                outIter.setSample(c, r, 0, diff);
            }
            this.pm.worked(1);
        }
        this.pm.done();
        r1Iter.done();
        r2Iter.done();
        outIter.done();
        this.outRaster = CoverageUtilities.buildCoverageWithNovalue("corrected", outWR, (HashMap<String, Double>)regionMap, this.inRaster1.getCoordinateReferenceSystem(), r1Nv);
    }
}

