/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gears.modules.r.rastergenerator;

import java.awt.image.WritableRaster;
import java.util.HashMap;
import java.util.Random;
import javax.media.jai.iterator.WritableRandomIter;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Out;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.hortonmachine.gears.libs.exceptions.ModelsIllegalargumentException;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.gears.utils.CrsUtilities;
import org.hortonmachine.gears.utils.RegionMap;
import org.hortonmachine.gears.utils.coverage.CoverageUtilities;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

@Description(value="Generates a raster.")
@Author(name="Andrea Antonello, Silvia Franceschi", contact="www.hydrologis.com")
@Keywords(value="generator, raster")
@Label(value="Raster Processing")
@Name(value="_rastergenerator")
@Status(value=10)
@License(value="http://www.gnu.org/licenses/gpl-3.0.html")
public class OmsRasterGenerator
extends HMModel {
    @Description(value="The boundary north coordinate.")
    @UI(value="process_north")
    @In
    public Double pNorth = null;
    @Description(value="The boundary south coordinate.")
    @UI(value="process_south")
    @In
    public Double pSouth = null;
    @Description(value="The boundary west coordinate.")
    @UI(value="process_west")
    @In
    public Double pWest = null;
    @Description(value="The boundary east coordinate.")
    @UI(value="process_east")
    @In
    public Double pEast = null;
    @Description(value="The resolution in x.")
    @UI(value="process_xres")
    @In
    public Double pXres = null;
    @Description(value="The resolution in y.")
    @UI(value="process_yres")
    @In
    public Double pYres = null;
    @Description(value="The code defining the coordinate reference system, composed by authority and code number (ex. EPSG:4328).")
    @UI(value="crs")
    @In
    public String pCode;
    @Description(value="The coordinate reference system (in case pCode is not supplied).")
    @UI(value="crs")
    @In
    public CoordinateReferenceSystem inCrs;
    @Description(value="The value to set the raster to.")
    @In
    public double pValue = 0.0;
    @Description(value="If true, uses a random generator.")
    @In
    public boolean doRandom = false;
    @Description(value="Optional random offset.")
    @In
    public double pOffset = 0.0;
    @Description(value="Optional random scale.")
    @In
    public double pScale = 1.0;
    @Description(value="The generated raster.")
    @Out
    public GridCoverage2D outRaster;
    public static final String DESCRIPTION = "Generates a raster.";
    public static final String NAME = "rastergenerator";
    public static final String KEYWORDS = "generator, raster";
    public static final String pNorth_DESCRIPTION = "The boundary north coordinate.";
    public static final String pSouth_DESCRIPTION = "The boundary south coordinate.";
    public static final String pWest_DESCRIPTION = "The boundary west coordinate.";
    public static final String pEast_DESCRIPTION = "The boundary east coordinate.";
    public static final String pXres_DESCRIPTION = "The resolution in x.";
    public static final String pYres_DESCRIPTION = "The resolution in y.";
    public static final String pCode_DESCRIPTION = "The code defining the coordinate reference system, composed by authority and code number (ex. EPSG:4328).";
    public static final String pCrs_DESCRIPTION = "The coordinate reference system (in case pCode is not supplied).";
    public static final String outRaster_DESCRIPTION = "The generated raster.";
    public static final String pScale_DESCRIPTION = "Optional random scale.";
    public static final String pOffset_DESCRIPTION = "Optional random offset.";
    public static final String doRandom_DESCRIPTION = "If true, uses a random generator.";
    public static final String pValue_DESCRIPTION = "The value to set the raster to.";

    @Execute
    public void process() throws Exception {
        this.checkNull(this.pNorth, this.pSouth, this.pEast, this.pWest, this.pXres, this.pYres);
        if (this.pCode == null && this.inCrs == null) {
            throw new ModelsIllegalargumentException("At lest one of the CRS definitions are necessary.", this);
        }
        CoordinateReferenceSystem crs = this.inCrs;
        if (crs == null) {
            crs = CrsUtilities.getCrsFromEpsg(this.pCode, null);
        }
        int rows = (int)Math.round((this.pNorth - this.pSouth) / this.pYres);
        int cols = (int)Math.round((this.pEast - this.pWest) / this.pXres);
        GridGeometry2D gridGeometryFromRegionValues = CoverageUtilities.gridGeometryFromRegionValues(this.pNorth, this.pSouth, this.pEast, this.pWest, cols, rows, crs);
        RegionMap regionMap = CoverageUtilities.gridGeometry2RegionParamsMap(gridGeometryFromRegionValues);
        WritableRaster outWR = CoverageUtilities.createWritableRaster(cols, rows, null, null, null);
        WritableRandomIter outIter = CoverageUtilities.getWritableRandomIterator(outWR);
        Random random = new Random();
        this.pm.beginTask("Generating raster...", rows);
        for (int r = 0; r < rows; ++r) {
            if (this.isCanceled(this.pm)) {
                return;
            }
            for (int c = 0; c < cols; ++c) {
                double value = this.pValue;
                if (this.doRandom) {
                    value = this.pOffset + this.pScale * random.nextDouble();
                }
                outIter.setSample(c, r, 0, value);
            }
            this.pm.worked(1);
        }
        this.pm.done();
        outIter.done();
        this.outRaster = CoverageUtilities.buildCoverage("generated", outWR, (HashMap<String, Double>)regionMap, crs);
    }
}

