/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gears.modules.r.rasternull;

import java.awt.image.WritableRaster;
import java.util.HashMap;
import javax.media.jai.iterator.WritableRandomIter;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Documentation;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Out;
import oms3.annotations.Status;
import org.geotools.coverage.grid.GridCoverage2D;
import org.hortonmachine.gears.libs.modules.HMConstants;
import org.hortonmachine.gears.libs.modules.multiprocessing.GridMultiProcessing;
import org.hortonmachine.gears.utils.RegionMap;
import org.hortonmachine.gears.utils.coverage.CoverageUtilities;
import org.hortonmachine.gears.utils.math.NumericsUtilities;

@Description(value="Module that puts a certain value of the raster to null.")
@Documentation(value="")
@Author(name="Andrea Antonello", contact="http://www.hydrologis.com")
@Keywords(value="Null, Raster")
@Label(value="Raster Processing")
@Name(value="rnull")
@Status(value=40)
@License(value="General Public License Version 3 (GPLv3)")
public class OmsRasterNull
extends GridMultiProcessing {
    @Description(value="The raster to modify.")
    @In
    public GridCoverage2D inRaster;
    @Description(value="The value to set to null.")
    @In
    public Double pValue = null;
    @Description(value="If true, sets everything else to null.")
    @In
    public boolean doInverse = false;
    @Description(value="The the null value to set (else it is guessed).")
    @In
    public Double pNull = null;
    @Description(value="The new raster.")
    @Out
    public GridCoverage2D outRaster;
    public static final String OMSRASTERNULL_DESCRIPTION = "Module that puts a certain value of the raster to null.";
    public static final String OMSRASTERNULL_DOCUMENTATION = "";
    public static final String OMSRASTERNULL_KEYWORDS = "Null, Raster";
    public static final String OMSRASTERNULL_LABEL = "Raster Processing";
    public static final String OMSRASTERNULL_NAME = "rnull";
    public static final int OMSRASTERNULL_STATUS = 40;
    public static final String OMSRASTERNULL_LICENSE = "General Public License Version 3 (GPLv3)";
    public static final String OMSRASTERNULL_AUTHORNAMES = "Andrea Antonello";
    public static final String OMSRASTERNULL_AUTHORCONTACTS = "http://www.hydrologis.com";
    public static final String OMSRASTERNULL_IN_RASTER_DESCRIPTION = "The raster to modify.";
    public static final String OMSRASTERNULL_P_VALUE_DESCRIPTION = "The value to set to null.";
    public static final String OMSRASTERNULL_doInverse_DESCRIPTION = "If true, sets everything else to null.";
    public static final String OMSRASTERNULL_P_NULL_DESCRIPTION = "The the null value to set (else it is guessed).";
    public static final String OMSRASTERNULL_OUT_RASTER_DESCRIPTION = "The new raster.";
    private double nullValue;

    @Execute
    public void process() throws Exception {
        this.checkNull(this.inRaster, this.pValue);
        double replaceValue = this.pValue;
        this.nullValue = -9999.0;
        if (this.pNull != null) {
            this.nullValue = this.pNull;
        }
        RegionMap regionMap = CoverageUtilities.getRegionParamsFromGridCoverage(this.inRaster);
        int rows = regionMap.getRows();
        int cols = regionMap.getCols();
        WritableRaster outWR = CoverageUtilities.renderedImage2DoubleWritableRaster(this.inRaster.getRenderedImage(), false);
        WritableRandomIter outIter = CoverageUtilities.getWritableRandomIterator(outWR);
        this.pm.beginTask("Nulling data...", cols * rows);
        this.processGrid(cols, rows, (c, r) -> {
            if (this.pm.isCanceled()) {
                return;
            }
            double value = outIter.getSampleDouble(c, r, 0);
            if (!HMConstants.isNovalue(value)) {
                if (this.doInverse) {
                    if (!NumericsUtilities.dEq(value, replaceValue)) {
                        value = -9999.0;
                    }
                } else if (NumericsUtilities.dEq(value, replaceValue)) {
                    value = this.nullValue;
                }
                outIter.setSample(c, r, 0, value);
            } else {
                outIter.setSample(c, r, 0, -9999.0);
            }
            this.pm.worked(1);
        });
        this.pm.done();
        outIter.done();
        this.outRaster = CoverageUtilities.buildCoverage("nulled", outWR, (HashMap<String, Double>)regionMap, this.inRaster.getCoordinateReferenceSystem());
    }
}

