/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gears.modules.r.rasteronvectorresizer;

import java.awt.image.WritableRaster;
import java.util.HashMap;
import javax.media.jai.iterator.RandomIter;
import javax.media.jai.iterator.WritableRandomIter;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Documentation;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Out;
import oms3.annotations.Status;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.hortonmachine.gears.libs.exceptions.ModelsIllegalargumentException;
import org.hortonmachine.gears.libs.modules.HMConstants;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.gears.utils.RegionMap;
import org.hortonmachine.gears.utils.coverage.CoverageUtilities;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;

@Description(value="Module to resize a raster on a raster or vector using the resolution of the original raster. Snapping is applied to the first contained cell, if necessary.")
@Documentation(value="")
@Author(name="Andrea Antonello", contact="http://www.hydrologis.com")
@Keywords(value="Raster, Vector, Resize")
@Label(value="Raster Processing")
@Name(value="rresizer")
@Status(value=5)
@License(value="General Public License Version 3 (GPLv3)")
public class OmsRasterResizer
extends HMModel {
    @Description(value="The raster to resize.")
    @In
    public GridCoverage2D inRaster;
    @Description(value="The optional polygon vector to use for the bounds.")
    @In
    public SimpleFeatureCollection inVector = null;
    @Description(value="The optional raster to use as mask.")
    @In
    public GridCoverage2D inMaskRaster;
    @Description(value="The resized raster.")
    @Out
    public GridCoverage2D outRaster;
    public static final String OmsRasterResizer_DESCRIPTION = "Module to resize a raster on a raster or vector using the resolution of the original raster. Snapping is applied to the first contained cell, if necessary.";
    public static final String OmsRasterResizer_DOCUMENTATION = "";
    public static final String OmsRasterResizer_KEYWORDS = "Raster, Vector, Resize";
    public static final String OmsRasterResizer_LABEL = "Raster Processing";
    public static final String OmsRasterResizer_NAME = "rresizer";
    public static final int OmsRasterResizer_STATUS = 5;
    public static final String OmsRasterResizer_LICENSE = "General Public License Version 3 (GPLv3)";
    public static final String OmsRasterResizer_AUTHORNAMES = "Andrea Antonello";
    public static final String OmsRasterResizer_AUTHORCONTACTS = "http://www.hydrologis.com";
    public static final String OmsRasterResizer_IN_VECTOR_DESCRIPTION = "The optional polygon vector to use for the bounds.";
    public static final String OmsRasterResizer_IN_MASKRASTER_DESCRIPTION = "The optional raster to use as mask.";
    public static final String OmsRasterResizer_IN_RASTER_DESCRIPTION = "The raster to resize.";
    public static final String OmsRasterResizer_OUT_RASTER_DESCRIPTION = "The resized raster.";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Execute
    public void process() throws Exception {
        this.checkNull(this.inRaster);
        if (this.inVector != null) {
            double newN;
            double newS;
            double newE;
            RegionMap regionMap = CoverageUtilities.getRegionParamsFromGridCoverage(this.inRaster);
            ReferencedEnvelope bounds = this.inVector.getBounds();
            double xres = regionMap.getXres();
            double yres = regionMap.getYres();
            bounds.expandBy(2.0 * xres, 2.0 * yres);
            double n = regionMap.getNorth();
            double s = regionMap.getSouth();
            double w = regionMap.getWest();
            double e = regionMap.getEast();
            double newW = bounds.getMinX();
            if (newW < w) {
                newW = w;
            }
            if ((newE = bounds.getMaxX()) > e) {
                newE = e;
            }
            if ((newS = bounds.getMinY()) < s) {
                newS = s;
            }
            if ((newN = bounds.getMaxY()) > n) {
                newN = n;
            }
            Envelope env = new Envelope(newW, newE, newS, newN);
            RegionMap subRegion = regionMap.toSubRegion(env);
            WritableRaster outWR = CoverageUtilities.createWritableRaster(subRegion.getCols(), subRegion.getRows(), null, null, null);
            WritableRandomIter outIter = CoverageUtilities.getWritableRandomIterator(outWR);
            RandomIter iter = CoverageUtilities.getRandomIterator(this.inRaster);
            try {
                GridGeometry2D startGG = this.inRaster.getGridGeometry();
                GridGeometry2D destGG = CoverageUtilities.gridGeometryFromRegionParams(subRegion, this.inRaster.getCoordinateReferenceSystem());
                int rows = subRegion.getRows();
                int cols = subRegion.getCols();
                for (int r = 0; r < rows; ++r) {
                    for (int c = 0; c < cols; ++c) {
                        Coordinate coord = CoverageUtilities.coordinateFromColRow(c, r, destGG);
                        int[] cr = CoverageUtilities.colRowFromCoordinate(coord, startGG, null);
                        double value = iter.getSampleDouble(cr[0], cr[1], 0);
                        outIter.setSample(c, r, 0, value);
                    }
                }
                this.outRaster = CoverageUtilities.buildCoverage("resized", outWR, (HashMap<String, Double>)subRegion, this.inRaster.getCoordinateReferenceSystem());
            }
            finally {
                outIter.done();
                iter.done();
            }
        } else if (this.inMaskRaster != null) {
            RegionMap maskRegionMap = CoverageUtilities.getRegionParamsFromGridCoverage(this.inMaskRaster);
            int rows = maskRegionMap.getRows();
            int cols = maskRegionMap.getCols();
            WritableRaster outWR = CoverageUtilities.createWritableRaster(cols, rows, null, null, null);
            WritableRandomIter maskOutIter = CoverageUtilities.getWritableRandomIterator(outWR);
            RandomIter outIter = CoverageUtilities.getRandomIterator(this.inMaskRaster);
            RandomIter inIter = CoverageUtilities.getRandomIterator(this.inRaster);
            RegionMap inRegionMap = CoverageUtilities.getRegionParamsFromGridCoverage(this.inRaster);
            Envelope inEnvelope = inRegionMap.toEnvelope();
            GridGeometry2D inGridGeometry = this.inRaster.getGridGeometry();
            GridGeometry2D maskGridGeometry = this.inMaskRaster.getGridGeometry();
            double inRasterNv = HMConstants.getNovalue(this.inRaster);
            double maskRasterNv = HMConstants.getNovalue(this.inMaskRaster);
            try {
                this.pm.beginTask("Resizing raster...", rows);
                for (int r = 0; r < rows; ++r) {
                    if (this.pm.isCanceled()) {
                        return;
                    }
                    for (int c = 0; c < cols; ++c) {
                        double maskValue = outIter.getSampleDouble(c, r, 0);
                        if (!HMConstants.isNovalue(maskValue, maskRasterNv)) {
                            Coordinate coordinate = CoverageUtilities.coordinateFromColRow(c, r, maskGridGeometry);
                            if (inEnvelope.contains(coordinate)) {
                                int[] colRow = CoverageUtilities.colRowFromCoordinate(coordinate, inGridGeometry, null);
                                double value = inIter.getSampleDouble(colRow[0], colRow[1], 0);
                                maskOutIter.setSample(c, r, 0, value);
                                continue;
                            }
                            maskOutIter.setSample(c, r, 0, inRasterNv);
                            continue;
                        }
                        maskOutIter.setSample(c, r, 0, inRasterNv);
                    }
                    this.pm.worked(1);
                }
                this.pm.done();
                this.outRaster = CoverageUtilities.buildCoverageWithNovalue("resized", outWR, (HashMap<String, Double>)maskRegionMap, this.inRaster.getCoordinateReferenceSystem(), inRasterNv);
            }
            finally {
                inIter.done();
                maskOutIter.done();
            }
        } else {
            throw new ModelsIllegalargumentException("Either an input vector or raster need to be defined.", this);
        }
    }
}

