/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gears.modules.r.rasterreprojector;

import javax.media.jai.Interpolation;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Documentation;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Out;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.coverage.processing.Operations;
import org.geotools.geometry.jts.JTS;
import org.geotools.referencing.CRS;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.gears.utils.CrsUtilities;
import org.hortonmachine.gears.utils.RegionMap;
import org.hortonmachine.gears.utils.coverage.CoverageUtilities;
import org.hortonmachine.gears.utils.geometry.GeometryUtilities;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Polygon;
import org.opengis.coverage.Coverage;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;

@Description(value="Module for raster reprojection.")
@Documentation(value="")
@Author(name="Andrea Antonello", contact="http://www.hydrologis.com")
@Keywords(value="Crs, Reprojection, Raster, OmsRasterConverter, OmsRasterReader")
@Label(value="Raster Processing")
@Name(value="rreproject")
@Status(value=40)
@License(value="General Public License Version 3 (GPLv3)")
public class OmsRasterReprojector
extends HMModel {
    @Description(value="The raster that has to be reprojected.")
    @In
    public GridCoverage2D inRaster;
    @Description(value="The optional X resolution to set for the output.")
    @UI(value="process_cols")
    @In
    public Double pXres = null;
    @Description(value="The optional Y resolution to set for the output.")
    @UI(value="process_rows")
    @In
    public Double pYres = null;
    @Description(value="The projection code for the target coordinate reference system (ex. EPSG:32632).")
    @UI(value="crs")
    @In
    public String pCode;
    @Description(value="The interpolation type to use")
    @UI(value="combo:nearest neightbour,bilinear,bicubic")
    @In
    public String pInterpolation = "nearest neightbour";
    @Description(value="The reprojected output raster.")
    @Out
    public GridCoverage2D outRaster = null;
    public static final String OMSRASTERREPROJECTOR_DESCRIPTION = "Module for raster reprojection.";
    public static final String OMSRASTERREPROJECTOR_DOCUMENTATION = "";
    public static final String OMSRASTERREPROJECTOR_KEYWORDS = "Crs, Reprojection, Raster, OmsRasterConverter, OmsRasterReader";
    public static final String OMSRASTERREPROJECTOR_LABEL = "Raster Processing";
    public static final String OMSRASTERREPROJECTOR_NAME = "rreproject";
    public static final int OMSRASTERREPROJECTOR_STATUS = 40;
    public static final String OMSRASTERREPROJECTOR_LICENSE = "General Public License Version 3 (GPLv3)";
    public static final String OMSRASTERREPROJECTOR_AUTHORNAMES = "Andrea Antonello";
    public static final String OMSRASTERREPROJECTOR_AUTHORCONTACTS = "http://www.hydrologis.com";
    public static final String OMSRASTERREPROJECTOR_IN_RASTER_DESCRIPTION = "The raster that has to be reprojected.";
    public static final String OMSRASTERREPROJECTOR_P_XRES_DESCRIPTION = "The optional X resolution to set for the output.";
    public static final String OMSRASTERREPROJECTOR_P_YRES_DESCRIPTION = "The optional Y resolution to set for the output.";
    public static final String OMSRASTERREPROJECTOR_P_OUTCODE_DESCRIPTION = "The projection code for the target coordinate reference system (ex. EPSG:32632).";
    public static final String OMSRASTERREPROJECTOR_P_INTERPOLATION_DESCRIPTION = "The interpolation type to use";
    public static final String OMSRASTERREPROJECTOR_OUT_RASTER_DESCRIPTION = "The reprojected output raster.";

    @Execute
    public void process() throws Exception {
        if (!this.concatOr(this.outRaster == null, this.doReset)) {
            return;
        }
        CoordinateReferenceSystem targetCrs = CrsUtilities.getCrsFromEpsg(this.pCode, null);
        Interpolation interpolation = null;
        if (this.pInterpolation.equals("bilinear")) {
            interpolation = Interpolation.getInstance((int)1);
        } else if (this.pInterpolation.equals("bicubic")) {
            interpolation = Interpolation.getInstance((int)2);
        }
        CoordinateReferenceSystem sourceCrs = this.inRaster.getCoordinateReferenceSystem();
        if (!CrsUtilities.isCrsValid(sourceCrs)) {
            return;
        }
        GridGeometry2D gridGeometry = null;
        if (this.pXres != null && this.pYres != null) {
            RegionMap regionMap = CoverageUtilities.getRegionParamsFromGridCoverage(this.inRaster);
            double n = regionMap.getNorth();
            double s = regionMap.getSouth();
            double e = regionMap.getEast();
            double w = regionMap.getWest();
            Polygon polygon = GeometryUtilities.createPolygonFromEnvelope(new Envelope(w, e, s, n));
            MathTransform transform = CRS.findMathTransform((CoordinateReferenceSystem)sourceCrs, (CoordinateReferenceSystem)targetCrs);
            Geometry targetGeometry = JTS.transform((Geometry)polygon, (MathTransform)transform);
            Envelope env = targetGeometry.getEnvelopeInternal();
            n = env.getMaxY();
            s = env.getMinY();
            w = env.getMinX();
            e = env.getMaxX();
            int newCols = (int)Math.round((e - w) / this.pXres);
            int newRows = (int)Math.round((n - s) / this.pYres);
            gridGeometry = CoverageUtilities.gridGeometryFromRegionValues(n, s, e, w, newCols, newRows, targetCrs);
            this.pm.message("Using supplied gridgeometry: " + gridGeometry);
        }
        this.pm.beginTask("Reprojecting...", -1);
        this.outRaster = gridGeometry == null ? (interpolation == null ? (GridCoverage2D)Operations.DEFAULT.resample((Coverage)this.inRaster, targetCrs) : (GridCoverage2D)Operations.DEFAULT.resample((GridCoverage)this.inRaster, targetCrs, null, interpolation)) : (GridCoverage2D)Operations.DEFAULT.resample((GridCoverage)this.inRaster, targetCrs, gridGeometry, interpolation);
        this.pm.done();
    }
}

