/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gears.modules.r.rastervaluerounder;

import java.awt.image.WritableRaster;
import java.text.DecimalFormat;
import java.util.HashMap;
import javax.media.jai.iterator.RandomIter;
import javax.media.jai.iterator.WritableRandomIter;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Documentation;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Out;
import oms3.annotations.Status;
import org.geotools.coverage.grid.GridCoverage2D;
import org.hortonmachine.gears.libs.modules.HMConstants;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.gears.utils.RegionMap;
import org.hortonmachine.gears.utils.coverage.CoverageUtilities;

@Description(value="Module that rounds the values of a raster map.")
@Documentation(value="")
@Author(name="Andrea Antonello", contact="http://www.hydrologis.com")
@Keywords(value="Round, Raster")
@Label(value="Raster Processing")
@Name(value="rround")
@Status(value=40)
@License(value="General Public License Version 3 (GPLv3)")
public class OmsRasterValueRounder
extends HMModel {
    @Description(value="The raster of which to round the values.")
    @In
    public GridCoverage2D inRaster;
    @Description(value="The rounding pattern.")
    @In
    public String pPattern = null;
    @Description(value="The rounded raster.")
    @Out
    public GridCoverage2D outRaster;
    private DecimalFormat formatter = null;

    @Execute
    public void process() throws Exception {
        if (!this.concatOr(this.outRaster == null, this.doReset)) {
            return;
        }
        this.checkNull(this.inRaster, this.pPattern);
        this.formatter = new DecimalFormat(this.pPattern);
        RegionMap regionMap = CoverageUtilities.getRegionParamsFromGridCoverage(this.inRaster);
        int rows = regionMap.getRows();
        int cols = regionMap.getCols();
        WritableRaster outWR = CoverageUtilities.createWritableRaster(cols, rows, null, null, null);
        RandomIter inRasterIter = CoverageUtilities.getRandomIterator(this.inRaster);
        WritableRandomIter outIter = CoverageUtilities.getWritableRandomIterator(outWR);
        this.pm.beginTask("Rounding data...", rows);
        for (int r = 0; r < rows; ++r) {
            if (this.isCanceled(this.pm)) {
                return;
            }
            for (int c = 0; c < cols; ++c) {
                double value = inRasterIter.getSampleDouble(c, r, 0);
                if (!HMConstants.isNovalue(value)) {
                    String formatted = this.formatter.format(value);
                    value = Double.parseDouble(formatted);
                    outIter.setSample(c, r, 0, value);
                    continue;
                }
                outIter.setSample(c, r, 0, -9999.0);
            }
            this.pm.worked(1);
        }
        this.pm.done();
        outIter.done();
        this.outRaster = CoverageUtilities.buildCoverage("rounded", outWR, (HashMap<String, Double>)regionMap, this.inRaster.getCoordinateReferenceSystem());
    }
}

