/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gears.modules.r.rastervectorintersection;

import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Documentation;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Out;
import oms3.annotations.Status;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.hortonmachine.gears.libs.exceptions.ModelsRuntimeException;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.gears.modules.r.cutout.OmsCutOut;
import org.hortonmachine.gears.modules.r.scanline.OmsScanLineRasterizer;
import org.hortonmachine.gears.utils.RegionMap;
import org.hortonmachine.gears.utils.coverage.CoverageUtilities;
import org.hortonmachine.gears.utils.geometry.EGeometryType;
import org.opengis.feature.simple.SimpleFeatureType;

@Description(value="Module for raster with polygon vector intersection.")
@Documentation(value="")
@Author(name="Andrea Antonello", contact="http://www.hydrologis.com")
@Keywords(value="Raster, Vector, Intersect")
@Label(value="Raster Processing")
@Name(value="rvintersector")
@Status(value=5)
@License(value="General Public License Version 3 (GPLv3)")
public class OmsRasterVectorIntersector
extends HMModel {
    @Description(value="The polygon vector to use for the intersection.")
    @In
    public SimpleFeatureCollection inVector = null;
    @Description(value="The raster to use for the intersection.")
    @In
    public GridCoverage2D inRaster;
    @Description(value="Flag to use to invert the result (default is false = keep data inside vector)")
    @In
    public boolean doInverse = false;
    @Description(value="The output raster.")
    @Out
    public GridCoverage2D outRaster;
    public static final String OMSRASTERVECTORINTERSECTOR_DESCRIPTION = "Module for raster with polygon vector intersection.";
    public static final String OMSRASTERVECTORINTERSECTOR_DOCUMENTATION = "";
    public static final String OMSRASTERVECTORINTERSECTOR_KEYWORDS = "Raster, Vector, Intersect";
    public static final String OMSRASTERVECTORINTERSECTOR_LABEL = "Raster Processing";
    public static final String OMSRASTERVECTORINTERSECTOR_NAME = "rvintersector";
    public static final int OMSRASTERVECTORINTERSECTOR_STATUS = 5;
    public static final String OMSRASTERVECTORINTERSECTOR_LICENSE = "General Public License Version 3 (GPLv3)";
    public static final String OMSRASTERVECTORINTERSECTOR_AUTHORNAMES = "Andrea Antonello";
    public static final String OMSRASTERVECTORINTERSECTOR_AUTHORCONTACTS = "http://www.hydrologis.com";
    public static final String OMSRASTERVECTORINTERSECTOR_IN_VECTOR_DESCRIPTION = "The polygon vector to use for the intersection.";
    public static final String OMSRASTERVECTORINTERSECTOR_IN_RASTER_DESCRIPTION = "The raster to use for the intersection.";
    public static final String OMSRASTERVECTORINTERSECTOR_DO_INVERSE_DESCRIPTION = "Flag to use to invert the result (default is false = keep data inside vector)";
    public static final String OMSRASTERVECTORINTERSECTOR_OUT_RASTER_DESCRIPTION = "The output raster.";

    @Execute
    public void process() throws Exception {
        this.checkNull(this.inRaster, this.inVector);
        SimpleFeatureType schema = (SimpleFeatureType)this.inVector.getSchema();
        if (!EGeometryType.isPolygon(schema.getGeometryDescriptor())) {
            throw new ModelsRuntimeException("The module works only with polygon vectors.", this);
        }
        RegionMap regionMap = CoverageUtilities.getRegionParamsFromGridCoverage(this.inRaster);
        OmsScanLineRasterizer raster = new OmsScanLineRasterizer();
        raster.inVector = this.inVector;
        raster.pCols = regionMap.getCols();
        raster.pRows = regionMap.getRows();
        raster.pNorth = regionMap.getNorth();
        raster.pSouth = regionMap.getSouth();
        raster.pEast = regionMap.getEast();
        raster.pWest = regionMap.getWest();
        raster.pValue = 1.0;
        raster.process();
        GridCoverage2D rasterizedVector = raster.outRaster;
        OmsCutOut cutout = new OmsCutOut();
        cutout.pm = this.pm;
        cutout.inRaster = this.inRaster;
        cutout.inMask = rasterizedVector;
        cutout.doInverse = this.doInverse;
        cutout.process();
        this.outRaster = cutout.outRaster;
    }
}

