/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gears.modules.r.scanline;

import java.awt.image.WritableRaster;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.media.jai.iterator.RandomIter;
import javax.media.jai.iterator.WritableRandomIter;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Documentation;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Out;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.geotools.coverage.grid.GridCoordinates2D;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.coverage.grid.InvalidGridGeometryException;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.geometry.DirectPosition2D;
import org.hortonmachine.gears.libs.exceptions.ModelsIOException;
import org.hortonmachine.gears.libs.exceptions.ModelsIllegalargumentException;
import org.hortonmachine.gears.libs.exceptions.ModelsRuntimeException;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.gears.utils.RegionMap;
import org.hortonmachine.gears.utils.coverage.CoverageUtilities;
import org.hortonmachine.gears.utils.features.FeatureUtilities;
import org.hortonmachine.gears.utils.geometry.EGeometryType;
import org.hortonmachine.gears.utils.geometry.GeometryUtilities;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.prep.PreparedGeometry;
import org.locationtech.jts.geom.prep.PreparedGeometryFactory;
import org.locationtech.jts.operation.union.CascadedPolygonUnion;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.geometry.DirectPosition;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.TransformException;

@Description(value="Module for polygon vector to raster conversion.")
@Documentation(value="OmsScanLineRasterizer.html")
@Author(name="Andrea Antonello", contact="http://www.hydrologis.com")
@Keywords(value="Raster, Vector, Rasterize")
@Label(value="Raster Processing")
@Name(value="rscanline")
@Status(value=40)
@License(value="General Public License Version 3 (GPLv3)")
public class OmsScanLineRasterizer
extends HMModel {
    @Description(value="The vector to rasterize.")
    @In
    public SimpleFeatureCollection inVector = null;
    @Description(value="The value to use as raster value if no field is given.")
    @In
    public Double pValue = null;
    @Description(value="The field to use to retrieve the category value for the raster.")
    @In
    public String fCat = null;
    @Description(value="The north bound of the region to consider")
    @UI(value="process_north")
    @In
    public Double pNorth = null;
    @Description(value="The south bound of the region to consider")
    @UI(value="process_south")
    @In
    public Double pSouth = null;
    @Description(value="The west bound of the region to consider")
    @UI(value="process_west")
    @In
    public Double pWest = null;
    @Description(value="The east bound of the region to consider")
    @UI(value="process_east")
    @In
    public Double pEast = null;
    @Description(value="The rows of the region to consider")
    @UI(value="process_rows")
    @In
    public Integer pRows = null;
    @Description(value="The cols of the region to consider")
    @UI(value="process_cols")
    @In
    public Integer pCols = null;
    @Description(value="Use point in polygon (needs an input raster). In case scanline doesn't work.")
    @In
    public Boolean pUsePointInPolygon = false;
    @Description(value="An optional raster to take the values and region from.")
    @In
    public GridCoverage2D inRaster;
    @Description(value="The output raster.")
    @Out
    public GridCoverage2D outRaster;
    public static final String OMSSCANLINERASTERIZER_DESCRIPTION = "Module for polygon vector to raster conversion.";
    public static final String OMSSCANLINERASTERIZER_DOCUMENTATION = "OmsScanLineRasterizer.html";
    public static final String OMSSCANLINERASTERIZER_KEYWORDS = "Raster, Vector, Rasterize";
    public static final String OMSSCANLINERASTERIZER_LABEL = "Raster Processing";
    public static final String OMSSCANLINERASTERIZER_NAME = "rscanline";
    public static final int OMSSCANLINERASTERIZER_STATUS = 40;
    public static final String OMSSCANLINERASTERIZER_LICENSE = "General Public License Version 3 (GPLv3)";
    public static final String OMSSCANLINERASTERIZER_AUTHORNAMES = "Andrea Antonello";
    public static final String OMSSCANLINERASTERIZER_AUTHORCONTACTS = "http://www.hydrologis.com";
    public static final String OMSSCANLINERASTERIZER_IN_VECTOR_DESCRIPTION = "The vector to rasterize.";
    public static final String OMSSCANLINERASTERIZER_P_VALUE_DESCRIPTION = "The value to use as raster value if no field is given.";
    public static final String OMSSCANLINERASTERIZER_F_CAT_DESCRIPTION = "The field to use to retrieve the category value for the raster.";
    public static final String OMSSCANLINERASTERIZER_P_NORTH_DESCRIPTION = "The north bound of the region to consider";
    public static final String OMSSCANLINERASTERIZER_P_SOUTH_DESCRIPTION = "The south bound of the region to consider";
    public static final String OMSSCANLINERASTERIZER_P_WEST_DESCRIPTION = "The west bound of the region to consider";
    public static final String OMSSCANLINERASTERIZER_P_EAST_DESCRIPTION = "The east bound of the region to consider";
    public static final String OMSSCANLINERASTERIZER_P_ROWS_DESCRIPTION = "The rows of the region to consider";
    public static final String OMSSCANLINERASTERIZER_P_COLS_DESCRIPTION = "The cols of the region to consider";
    public static final String OMSSCANLINERASTERIZER_P_MAX_THREADS_DESCRIPTION = "Max threads to use (default 4)";
    public static final String OMSSCANLINERASTERIZER_P_USEPIP_DESCRIPTION = "Use point in polygon (needs an input raster). In case scanline doesn't work.";
    public static final String OMSSCANLINERASTERIZER_IN_RASTER_DESCRIPTION = "An optional raster to take the values and region from.";
    public static final String OMSSCANLINERASTERIZER_OUT_RASTER_DESCRIPTION = "The output raster.";
    private WritableRaster outWR;
    private int height;
    private int width;
    private GeometryFactory gf = GeometryUtilities.gf();
    private RegionMap paramsMap;
    private double xRes;
    private RandomIter inIter;

    @Execute
    public void process() throws Exception {
        GeometryDescriptor geometryDescriptor;
        this.checkNull(this.inVector);
        if (this.pValue == null && this.fCat == null) {
            throw new ModelsIllegalargumentException("One of pValue or the fCat have to be defined.", this, this.pm);
        }
        if ((this.pNorth == null || this.pSouth == null || this.pWest == null || this.pEast == null || this.pRows == null || this.pCols == null) && this.inRaster == null) {
            throw new ModelsIllegalargumentException("It is necessary to supply all the information about the processing region. Did you set the boundaries and rows/cols?", this, this.pm);
        }
        if (this.inRaster != null) {
            RegionMap regionMap = CoverageUtilities.getRegionParamsFromGridCoverage(this.inRaster);
            this.pNorth = regionMap.getNorth();
            this.pSouth = regionMap.getSouth();
            this.pWest = regionMap.getWest();
            this.pEast = regionMap.getEast();
            this.pRows = regionMap.getRows();
            this.pCols = regionMap.getCols();
            this.inIter = CoverageUtilities.getRandomIterator(this.inRaster);
        }
        SimpleFeatureType schema = (SimpleFeatureType)this.inVector.getSchema();
        CoordinateReferenceSystem crs = schema.getCoordinateReferenceSystem();
        GridGeometry2D pGrid = this.inRaster != null ? this.inRaster.getGridGeometry() : CoverageUtilities.gridGeometryFromRegionValues(this.pNorth, this.pSouth, this.pEast, this.pWest, this.pCols, this.pRows, crs);
        if (this.outWR == null) {
            this.paramsMap = CoverageUtilities.gridGeometry2RegionParamsMap(pGrid);
            this.height = this.paramsMap.getRows();
            this.width = this.paramsMap.getCols();
            this.xRes = this.paramsMap.getXres();
            this.outWR = CoverageUtilities.createWritableRaster(this.width, this.height, null, null, -9999.0);
        }
        if (EGeometryType.isPoint(geometryDescriptor = schema.getGeometryDescriptor())) {
            throw new ModelsRuntimeException("Not implemented yet for points", this.getClass().getSimpleName());
        }
        if (EGeometryType.isLine(geometryDescriptor)) {
            throw new ModelsRuntimeException("Not implemented yet for lines", this.getClass().getSimpleName());
        }
        if (EGeometryType.isPolygon(geometryDescriptor)) {
            if (this.pUsePointInPolygon.booleanValue()) {
                if (this.inRaster == null) {
                    throw new ModelsIllegalargumentException("The point in polygon mode needs an input raster to work on.", this);
                }
                this.pm.beginTask("Prepare input data...", -1);
                List<Geometry> allGeoms = FeatureUtilities.featureCollectionToGeometriesList(this.inVector, false, null);
                Geometry allGeomsUnion = CascadedPolygonUnion.union(allGeoms);
                PreparedGeometry preparedGeometry = PreparedGeometryFactory.prepare((Geometry)allGeomsUnion);
                this.pm.done();
                double value = this.pValue;
                this.pm.beginTask("Rasterizing...", this.height);
                WritableRandomIter wIter = CoverageUtilities.getWritableRandomIterator(this.outWR);
                for (int row = 0; row < this.height; ++row) {
                    for (int col = 0; col < this.width; ++col) {
                        Coordinate coord = CoverageUtilities.coordinateFromColRow(col, row, pGrid);
                        if (!preparedGeometry.intersects((Geometry)this.gf.createPoint(coord))) continue;
                        wIter.setSample(col, col, 0, value);
                    }
                    this.pm.worked(1);
                }
                this.pm.done();
                wIter.done();
            } else {
                this.rasterizepolygon(pGrid);
            }
        } else {
            throw new ModelsIllegalargumentException("Couldn't recognize the geometry type of the file.", this.getClass().getSimpleName(), this.pm);
        }
        this.outRaster = CoverageUtilities.buildCoverage("rasterized", this.outWR, (HashMap<String, Double>)this.paramsMap, ((SimpleFeatureType)this.inVector.getSchema()).getCoordinateReferenceSystem());
    }

    private void rasterizepolygon(final GridGeometry2D gridGeometry) throws InvalidGridGeometryException, TransformException {
        int size = this.inVector.size();
        this.pm.beginTask("Rasterizing features...", size);
        SimpleFeatureIterator featureIterator = this.inVector.features();
        ExecutorService fixedThreadPool = Executors.newFixedThreadPool(OmsScanLineRasterizer.getDefaultThreadsNum());
        while (featureIterator.hasNext()) {
            final SimpleFeature feature = (SimpleFeature)featureIterator.next();
            double tmpValue = -1.0;
            tmpValue = this.pValue == null ? ((Number)feature.getAttribute(this.fCat)).doubleValue() : this.pValue.doubleValue();
            final double value = tmpValue;
            final double delta = this.xRes / 4.0;
            Runnable runner = new Runnable(){

                @Override
                public void run() {
                    try {
                        Geometry geometry = (Geometry)feature.getDefaultGeometry();
                        int numGeometries = geometry.getNumGeometries();
                        for (int i = 0; i < numGeometries; ++i) {
                            Geometry geometryN = geometry.getGeometryN(i);
                            for (int r = 0; r < OmsScanLineRasterizer.this.height; ++r) {
                                double[] eastPos;
                                Coordinate east;
                                double[] westPos = gridGeometry.gridToWorld(new GridCoordinates2D(0, r)).getCoordinate();
                                Coordinate west = new Coordinate(westPos[0], westPos[1]);
                                LineString line = OmsScanLineRasterizer.this.gf.createLineString(new Coordinate[]{west, east = new Coordinate((eastPos = gridGeometry.gridToWorld(new GridCoordinates2D(OmsScanLineRasterizer.this.width - 1, r)).getCoordinate())[0], eastPos[1])});
                                if (!geometryN.intersects((Geometry)line)) continue;
                                Geometry internalLines = geometryN.intersection((Geometry)line);
                                int lineNums = internalLines.getNumGeometries();
                                for (int l = 0; l < lineNums; ++l) {
                                    Coordinate[] coords = internalLines.getGeometryN(l).getCoordinates();
                                    if (coords.length == 2) {
                                        for (int j = 0; j < coords.length; j += 2) {
                                            DirectPosition2D endDP;
                                            DirectPosition2D startDP;
                                            Coordinate startC = new Coordinate(coords[j].x + delta, coords[j].y);
                                            Coordinate endC = new Coordinate(coords[j + 1].x - delta, coords[j + 1].y);
                                            if (startC.x < endC.x) {
                                                startDP = new DirectPosition2D(startC.x, startC.x);
                                                endDP = new DirectPosition2D(endC.x, endC.x);
                                            } else {
                                                startDP = new DirectPosition2D(endC.x, endC.x);
                                                endDP = new DirectPosition2D(startC.x, startC.x);
                                            }
                                            GridCoordinates2D startGridCoord = gridGeometry.worldToGrid((DirectPosition)startDP);
                                            GridCoordinates2D endGridCoord = gridGeometry.worldToGrid((DirectPosition)endDP);
                                            for (int k = startGridCoord.x; k <= endGridCoord.x; ++k) {
                                                if (OmsScanLineRasterizer.this.inIter != null && OmsScanLineRasterizer.this.fCat == null) {
                                                    double v = OmsScanLineRasterizer.this.inIter.getSampleDouble(k, r, 0);
                                                    OmsScanLineRasterizer.this.outWR.setSample(k, r, 0, v);
                                                    continue;
                                                }
                                                OmsScanLineRasterizer.this.outWR.setSample(k, r, 0, value);
                                            }
                                        }
                                        continue;
                                    }
                                    if (coords.length == 1) {
                                        OmsScanLineRasterizer.this.pm.errorMessage(MessageFormat.format("Found a cusp in: {0}/{1}", coords[0].x, coords[0].y));
                                        continue;
                                    }
                                    throw new ModelsIOException(MessageFormat.format("Found intersection with more than 2 points in: {0}/{1}", coords[0].x, coords[0].y), this);
                                }
                            }
                        }
                        OmsScanLineRasterizer.this.pm.worked(1);
                    }
                    catch (Exception e) {
                        OmsScanLineRasterizer.this.pm.errorMessage(e.getLocalizedMessage());
                        e.printStackTrace();
                    }
                }
            };
            fixedThreadPool.execute(runner);
        }
        try {
            fixedThreadPool.shutdown();
            fixedThreadPool.awaitTermination(30L, TimeUnit.DAYS);
            fixedThreadPool.shutdownNow();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.pm.done();
        featureIterator.close();
    }
}

