/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gears.modules.r.summary;

import java.awt.image.RenderedImage;
import java.util.List;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Documentation;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Out;
import oms3.annotations.Status;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.gears.libs.monitor.DummyProgressMonitor;
import org.hortonmachine.gears.modules.r.summary.OmsZonalStats;
import org.hortonmachine.gears.utils.RegionMap;
import org.hortonmachine.gears.utils.coverage.CoverageUtilities;
import org.hortonmachine.gears.utils.features.FeatureUtilities;
import org.hortonmachine.gears.utils.math.CoupledFieldsMoments;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Polygon;
import org.opengis.feature.simple.SimpleFeature;

@Description(value="Calculate a summary of the map with base statistics.")
@Documentation(value="OmsRasterSummary.html")
@Author(name="Andrea Antonello", contact="http://www.hydrologis.com")
@Keywords(value="Statistics, Raster, OmsMapcalc")
@Label(value="Raster Processing")
@Name(value="rsummary")
@Status(value=40)
@License(value="General Public License Version 3 (GPLv3)")
public class OmsRasterSummary
extends HMModel {
    @Description(value="The map to analize.")
    @In
    public GridCoverage2D inRaster;
    @Description(value="The number of bins for the histogram (default = 100).")
    @In
    public int pBins = 100;
    @Description(value="Flag that defines if the histogram should be done also (default = false).")
    @In
    public boolean doHistogram = false;
    @Description(value="The min value.")
    @Out
    public Double outMin = null;
    @Description(value="The max value.")
    @Out
    public Double outMax = null;
    @Description(value="The mean value.")
    @Out
    public Double outMean = null;
    @Description(value="The standard deviation value.")
    @Out
    public Double outSdev = null;
    @Description(value="The range value.")
    @Out
    public Double outRange = null;
    @Description(value="The sum value.")
    @Out
    public Double outSum = null;
    @Description(value="The histogram.")
    @Out
    public double[][] outCb = null;
    public boolean printToConsole = true;
    public static final String OMSRASTERSUMMARY_DESCRIPTION = "Calculate a summary of the map with base statistics.";
    public static final String OMSRASTERSUMMARY_DOCUMENTATION = "OmsRasterSummary.html";
    public static final String OMSRASTERSUMMARY_KEYWORDS = "Statistics, Raster, OmsMapcalc";
    public static final String OMSRASTERSUMMARY_LABEL = "Raster Processing";
    public static final String OMSRASTERSUMMARY_NAME = "rsummary";
    public static final int OMSRASTERSUMMARY_STATUS = 40;
    public static final String OMSRASTERSUMMARY_LICENSE = "General Public License Version 3 (GPLv3)";
    public static final String OMSRASTERSUMMARY_AUTHORNAMES = "Andrea Antonello";
    public static final String OMSRASTERSUMMARY_AUTHORCONTACTS = "http://www.hydrologis.com";
    public static final String OMSRASTERSUMMARY_IN_RASTER_DESCRIPTION = "The map to analize.";
    public static final String OMSRASTERSUMMARY_P_BINS_DESCRIPTION = "The number of bins for the histogram (default = 100).";
    public static final String OMSRASTERSUMMARY_DO_HISTOGRAM_DESCRIPTION = "Flag that defines if the histogram should be done also (default = false).";
    public static final String OMSRASTERSUMMARY_OUT_MIN_DESCRIPTION = "The min value.";
    public static final String OMSRASTERSUMMARY_OUT_MAX_DESCRIPTION = "The max value.";
    public static final String OMSRASTERSUMMARY_OUT_MEAN_DESCRIPTION = "The mean value.";
    public static final String OMSRASTERSUMMARY_OUT_S_DEV_DESCRIPTION = "The standard deviation value.";
    public static final String OMSRASTERSUMMARY_OUT_RANGE_DESCRIPTION = "The range value.";
    public static final String OMSRASTERSUMMARY_OUT_SUM_DESCRIPTION = "The sum value.";
    public static final String OMSRASTERSUMMARY_OUT_CB_DESCRIPTION = "The histogram.";
    private String[] stats;

    @Execute
    public void process() throws Exception {
        if (!this.concatOr(this.outMin == null, this.doReset)) {
            return;
        }
        RegionMap regionMap = CoverageUtilities.getRegionParamsFromGridCoverage(this.inRaster);
        if (this.printToConsole) {
            this.pm.message("Bounds and resolution");
            this.pm.message("---------------------");
            this.pm.message(regionMap.toStringJGT());
            this.pm.message("");
            this.pm.message("Coordinate Reference System");
            this.pm.message("---------------------------");
            this.pm.message(this.inRaster.getCoordinateReferenceSystem().toWKT());
            this.pm.message("");
        }
        RenderedImage inRI = this.inRaster.getRenderedImage();
        Polygon regionPolygon = CoverageUtilities.getRegionPolygon(this.inRaster);
        SimpleFeatureCollection regionFC = FeatureUtilities.featureCollectionFromGeometry(this.inRaster.getCoordinateReferenceSystem(), new Geometry[]{regionPolygon});
        OmsZonalStats zs = new OmsZonalStats();
        zs.pm = new DummyProgressMonitor();
        zs.inRaster = this.inRaster;
        zs.inVector = regionFC;
        zs.pPercentageThres = 0.0;
        zs.process();
        SimpleFeatureCollection outVector = zs.outVector;
        List<SimpleFeature> testList = FeatureUtilities.featureCollectionToList(outVector);
        SimpleFeature feature = testList.get(0);
        if (this.stats == null) {
            this.stats = new String[]{"min", "max", "avg", "sdev", "var", "sum"};
        }
        block14: for (String statName : this.stats) {
            Object attribute = feature.getAttribute(statName);
            if (attribute == null) continue;
            switch (statName) {
                case "min": {
                    this.outMin = (Double)attribute;
                    continue block14;
                }
                case "max": {
                    this.outMax = (Double)attribute;
                    continue block14;
                }
                case "avg": {
                    this.outMean = (Double)attribute;
                    continue block14;
                }
                case "sdev": {
                    this.outSdev = (Double)attribute;
                    continue block14;
                }
                case "sum": {
                    this.outSum = (Double)attribute;
                    continue block14;
                }
            }
        }
        if (this.outMin != null && this.outMax != null) {
            this.outRange = this.outMax - this.outMin;
        }
        if (!this.doHistogram) {
            return;
        }
        double[][] cb = new CoupledFieldsMoments().process(inRI, null, this.pBins, 1, 2, this.pm, 1);
        int width = inRI.getWidth();
        int height = inRI.getHeight();
        int pixelsNum = width * height;
        this.outCb = new double[cb.length + 1][3];
        double sum = 0.0;
        for (int i = 0; i < this.outCb.length; ++i) {
            double nans;
            if (i < this.outCb.length - 1) {
                this.outCb[i][0] = cb[i][0];
                this.outCb[i][1] = cb[i][1];
                sum += cb[i][1];
                this.outCb[i][2] = cb[i][1] * 100.0 / (double)pixelsNum;
                continue;
            }
            this.outCb[i][0] = -9999.0;
            this.outCb[i][1] = nans = (double)pixelsNum - sum;
            this.outCb[i][2] = nans * 100.0 / (double)pixelsNum;
        }
    }

    public static double[] getMinMax(GridCoverage2D raster) throws Exception {
        OmsRasterSummary summary = new OmsRasterSummary();
        summary.inRaster = raster;
        summary.doHistogram = false;
        summary.stats = new String[]{"min", "max"};
        summary.printToConsole = false;
        summary.process();
        double min = summary.outMin;
        double max = summary.outMax;
        return new double[]{min, max};
    }

    public static double[] getMinMaxAvgSum(GridCoverage2D raster) throws Exception {
        OmsRasterSummary summary = new OmsRasterSummary();
        summary.inRaster = raster;
        summary.doHistogram = false;
        summary.stats = new String[]{"min", "max", "avg", "sum"};
        summary.printToConsole = false;
        summary.process();
        double min = summary.outMin;
        double max = summary.outMax;
        double avg = summary.outMean;
        double sum = summary.outSum;
        return new double[]{min, max, avg, sum};
    }
}

