/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gears.modules.r.summary;

import java.awt.image.Raster;
import java.io.File;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.media.jai.iterator.RandomIter;
import javax.media.jai.iterator.RandomIterFactory;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Out;
import oms3.annotations.Status;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.hortonmachine.gears.libs.modules.HMConstants;
import org.hortonmachine.gears.libs.modules.HMModelIM;
import org.hortonmachine.gears.modules.r.summary.OmsZonalStats;
import org.hortonmachine.gears.utils.features.FeatureUtilities;
import org.hortonmachine.gears.utils.math.NumericsUtilities;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.opengis.feature.simple.SimpleFeature;

@Description(value="Calculate zonal stats on image mosaic datasets.")
@Author(name="Andrea Antonello, Silvia Franceschi", contact="www.hydrologis.com")
@Keywords(value="zonalstats, image mosaic")
@Label(value="Raster Processing")
@Name(value="zonalstats_im")
@Status(value=5)
@License(value="http://www.gnu.org/licenses/gpl-3.0.html")
public class OmsZonalStatsIM
extends HMModelIM {
    @Description(value="The image mosaic map to process..")
    @In
    public String inRaster = null;
    @Description(value="The polygons map on which to do the stats.")
    @In
    public SimpleFeatureCollection inVector = null;
    @Description(value="The size of the bins to use for pretiling the region.")
    @In
    public double pBinSize = 10000.0;
    @Description(value="Percentage of minimum active cells to have a valid stat.")
    @In
    public double pPercentageThres = 20.0;
    @Description(value="Total meanvalue (also produced by this module) for the calculation of the mean absolute deviation.")
    @In
    public Double pTotalMean = null;
    @Description(value="The input polygons with the added stats values.")
    @Out
    public SimpleFeatureCollection outVector;
    double[] tm_usertm_tactivecells = new double[3];

    @Execute
    public void process() throws Exception {
        this.checkNull(this.inVector);
        this.addSource(new File(this.inRaster));
        boolean hasUserTotalMean = false;
        if (this.pTotalMean != null) {
            hasUserTotalMean = true;
            this.tm_usertm_tactivecells[1] = this.pTotalMean;
        }
        ReferencedEnvelope bounds = this.inVector.getBounds();
        double[] xBins = NumericsUtilities.range2Bins(bounds.getMinX(), bounds.getMaxX(), this.pBinSize, false);
        double[] yBins = NumericsUtilities.range2Bins(bounds.getMinY(), bounds.getMaxY(), this.pBinSize, false);
        SimpleFeatureBuilder featureBuilder = OmsZonalStats.createFeatureBuilder(bounds.getCoordinateReferenceSystem(), hasUserTotalMean);
        this.outVector = new DefaultFeatureCollection();
        List<Geometry> geometriesList = FeatureUtilities.featureCollectionToGeometriesList(this.inVector, true, null);
        ConcurrentLinkedQueue<Geometry> allGeometriesQueue = new ConcurrentLinkedQueue<Geometry>();
        allGeometriesQueue.addAll(geometriesList);
        this.pm.beginTask("Processing polygons...", xBins.length - 1);
        for (int x = 0; x < xBins.length - 1; ++x) {
            for (int y = 0; y < yBins.length - 1; ++y) {
                Envelope envelope = new Envelope(xBins[x], xBins[x + 1], yBins[y], yBins[y + 1]);
                Envelope readEnvelope = null;
                ConcurrentLinkedQueue<Geometry> keepGeometriesQueue = new ConcurrentLinkedQueue<Geometry>();
                ConcurrentLinkedQueue<Geometry> removeGeometriesQueue = new ConcurrentLinkedQueue<Geometry>();
                for (Geometry geometry : allGeometriesQueue) {
                    Envelope geometryenvelope = geometry.getEnvelopeInternal();
                    if (geometryenvelope.intersects(envelope)) {
                        removeGeometriesQueue.add(geometry);
                        if (readEnvelope == null) {
                            readEnvelope = new Envelope(geometryenvelope);
                            continue;
                        }
                        readEnvelope.expandToInclude(geometryenvelope);
                        continue;
                    }
                    keepGeometriesQueue.add(geometry);
                }
                allGeometriesQueue = keepGeometriesQueue;
                if (removeGeometriesQueue.size() == 0) continue;
                GridCoverage2D readGC = this.getGridCoverage(0, readEnvelope);
                double novalue = HMConstants.getNovalue(readGC);
                GridGeometry2D gridGeometry = readGC.getGridGeometry();
                Raster readRaster = readGC.getRenderedImage().getData();
                RandomIter readIter = RandomIterFactory.create((Raster)readRaster, null);
                for (Geometry geometry : removeGeometriesQueue) {
                    double[] polygonStats = OmsZonalStats.polygonStats(geometry, gridGeometry, readIter, novalue, hasUserTotalMean, this.tm_usertm_tactivecells, this.pPercentageThres, this.pm);
                    if (polygonStats == null) continue;
                    Object[] values = this.pTotalMean == null ? new Object[]{geometry, polygonStats[0], polygonStats[1], polygonStats[2], polygonStats[3], polygonStats[4], (int)polygonStats[5], (int)polygonStats[6]} : new Object[]{geometry, polygonStats[0], polygonStats[1], polygonStats[2], polygonStats[3], polygonStats[4], polygonStats[5], (int)polygonStats[6], (int)polygonStats[7]};
                    featureBuilder.addAll(values);
                    SimpleFeature feature = featureBuilder.buildFeature(null);
                    ((DefaultFeatureCollection)this.outVector).add(feature);
                }
            }
            this.pm.worked(1);
        }
        this.pm.done();
        if (!hasUserTotalMean) {
            this.tm_usertm_tactivecells[0] = this.tm_usertm_tactivecells[0] / this.tm_usertm_tactivecells[2];
            this.pm.message("Total mean: " + this.tm_usertm_tactivecells[0]);
        }
        this.dispose();
    }

    @Override
    protected void processCell(int readCol, int readRow, int writeCol, int writeRow, int readCols, int readRows, int writeCols, int writeRows) {
    }
}

