/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gears.modules.r.tmsgenerator;

import java.util.Arrays;
import org.locationtech.jts.geom.Envelope;

public class GlobalMercator {
    public static final int TILE_SIZE = 256;
    private final int tileSize;
    private final double initialResolution;
    private final double originShift;

    public GlobalMercator() {
        this.tileSize = 256;
        this.initialResolution = 4.007501668557849E7 / (double)this.tileSize;
        this.originShift = 2.0037508342789244E7;
    }

    public double[] LatLonToMeters(double lat, double lon) {
        double mx = lon * this.originShift / 180.0;
        double my = Math.log(Math.tan((90.0 + lat) * Math.PI / 360.0)) / (Math.PI / 180);
        my = my * this.originShift / 180.0;
        return new double[]{mx, my};
    }

    public double[] MetersToLatLon(double mx, double my) {
        double lon = mx / this.originShift * 180.0;
        double lat = my / this.originShift * 180.0;
        lat = 57.29577951308232 * (2.0 * Math.atan(Math.exp(lat * Math.PI / 180.0)) - 1.5707963267948966);
        return new double[]{lat, lon};
    }

    public double[] PixelsToMeters(double px, double py, int zoom) {
        double res = this.Resolution(zoom);
        double mx = px * res - this.originShift;
        double my = py * res - this.originShift;
        return new double[]{mx, my};
    }

    public int[] MetersToPixels(double mx, double my, int zoom) {
        double res = this.Resolution(zoom);
        int px = (int)Math.round((mx + this.originShift) / res);
        int py = (int)Math.round((my + this.originShift) / res);
        return new int[]{px, py};
    }

    public int[] PixelsToTile(int px, int py) {
        int tx = (int)Math.ceil((double)px / (double)this.tileSize - 1.0);
        int ty = (int)Math.ceil((double)py / (double)this.tileSize - 1.0);
        return new int[]{tx, ty};
    }

    public int[] PixelsToRaster(int px, int py, int zoom) {
        int mapSize = this.tileSize << zoom;
        return new int[]{px, mapSize - py};
    }

    public int[] MetersToTile(double mx, double my, int zoom) {
        int[] p = this.MetersToPixels(mx, my, zoom);
        return this.PixelsToTile(p[0], p[1]);
    }

    public int[] metersToTileUp(double mx, double my, int zoom) {
        int[] p = this.metersToPixelsUp(mx, my, zoom);
        return this.pixelsToTileUp(p[0], p[1]);
    }

    public int[] metersToPixelsUp(double mx, double my, int zoom) {
        double res = this.Resolution(zoom);
        int px = (int)Math.ceil((mx + this.originShift) / res);
        int py = (int)Math.ceil((my + this.originShift) / res);
        return new int[]{px, py};
    }

    public int[] pixelsToTileUp(int px, int py) {
        int tx = (int)Math.ceil((double)px / (double)this.tileSize - 1.0);
        int ty = (int)Math.ceil((double)py / (double)this.tileSize - 1.0);
        return new int[]{tx, ty};
    }

    public int[] metersToTileDown(double mx, double my, int zoom) {
        int[] p = this.metersToPixelsDown(mx, my, zoom);
        return this.pixelsToTileDown(p[0], p[1]);
    }

    public int[] metersToPixelsDown(double mx, double my, int zoom) {
        double res = this.Resolution(zoom);
        int px = (int)Math.floor((mx + this.originShift) / res);
        int py = (int)Math.floor((my + this.originShift) / res);
        return new int[]{px, py};
    }

    public int[] pixelsToTileDown(int px, int py) {
        int tx = (int)Math.floor((double)px / (double)this.tileSize - 1.0);
        int ty = (int)Math.floor((double)py / (double)this.tileSize - 1.0);
        return new int[]{tx, ty};
    }

    public double[] TileBounds(int tx, int ty, int zoom) {
        double[] min = this.PixelsToMeters(tx * this.tileSize, ty * this.tileSize, zoom);
        double minx = min[0];
        double miny = min[1];
        double[] max = this.PixelsToMeters((tx + 1) * this.tileSize, (ty + 1) * this.tileSize, zoom);
        double maxx = max[0];
        double maxy = max[1];
        return new double[]{minx, miny, maxx, maxy};
    }

    public Envelope TileLatLonBounds(int tx, int ty, int zoom) {
        double[] wsenBounds = this.TileBounds(tx, ty, zoom);
        double[] sw = this.MetersToLatLon(wsenBounds[0], wsenBounds[1]);
        double[] ne = this.MetersToLatLon(wsenBounds[2], wsenBounds[3]);
        return new Envelope(sw[1], ne[1], sw[0], ne[0]);
    }

    public double Resolution(int zoom) {
        return this.initialResolution / Math.pow(2.0, zoom);
    }

    public int ZoomForPixelSize(int pixelSize) {
        for (int i = 0; i < 30; ++i) {
            if (!((double)pixelSize > this.Resolution(i))) continue;
            if (i != 0) {
                return i - 1;
            }
            return 0;
        }
        return 0;
    }

    public int[] GoogleTile(int tx, int ty, int zoom) {
        return new int[]{tx, (int)(Math.pow(2.0, zoom) - 1.0 - (double)ty)};
    }

    public int[] TMSTileFromGoogleTile(int tx, int ty, int zoom) {
        return new int[]{tx, (int)(Math.pow(2.0, zoom) - 1.0 - (double)ty)};
    }

    public int[] GoogleTile(double lat, double lon, int zoom) {
        double[] meters = this.LatLonToMeters(lat, lon);
        int[] tile = this.MetersToTile(meters[0], meters[1], zoom);
        return this.GoogleTile(tile[0], tile[1], zoom);
    }

    public String QuadTree(int tx, int ty, int zoom) {
        Object quadKey = "";
        ty = (int)(Math.pow(2.0, zoom) - 1.0 - (double)ty);
        for (int i = zoom; i < 0; --i) {
            int digit = 0;
            int mask = 1 << i - 1;
            if ((tx & mask) != 0) {
                ++digit;
            }
            if ((ty & mask) != 0) {
                digit += 2;
            }
            quadKey = (String)quadKey + digit;
        }
        return quadKey;
    }

    public static void main(String[] args) {
        int[][] TMS = new int[][]{{0, 1, 1}, {16, 20, 5}, {8930, 10684, 14}};
        int[][] GOOGLE = new int[][]{{0, 0, 1}, {16, 11, 5}, {8930, 5699, 14}};
        GlobalMercator gm = new GlobalMercator();
        for (int i = 0; i < GOOGLE.length; ++i) {
            int[] googleTile = gm.TMSTileFromGoogleTile(GOOGLE[i][0], GOOGLE[i][1], GOOGLE[i][2]);
            System.out.println(Arrays.toString(googleTile));
        }
    }
}

