/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gears.modules.r.tmsgenerator;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.imageio.ImageIO;
import org.geotools.coverage.grid.io.AbstractGridCoverage2DReader;
import org.geotools.geometry.jts.JTS;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.hortonmachine.gears.libs.exceptions.ModelsRuntimeException;
import org.hortonmachine.gears.utils.images.ImageUtilities;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;

public class MBTilesHelper
implements AutoCloseable {
    public static final int TILESIZE = 256;
    public static final String TABLE_TILES = "tiles";
    public static final String COL_TILES_ZOOM_LEVEL = "zoom_level";
    public static final String COL_TILES_TILE_COLUMN = "tile_column";
    public static final String COL_TILES_TILE_ROW = "tile_row";
    public static final String COL_TILES_TILE_DATA = "tile_data";
    public static final String SELECTQUERY = "SELECT tile_data from tiles where zoom_level=? AND tile_column=? AND tile_row=?";
    private static final String CREATE_TILES = "CREATE TABLE tiles( zoom_level INTEGER, tile_column INTEGER, tile_row INTEGER, tile_data BLOB)";
    public static final String TABLE_METADATA = "metadata";
    public static final String COL_METADATA_NAME = "name";
    public static final String COL_METADATA_VALUE = "value";
    private static final String CREATE_METADATA = "CREATE TABLE metadata( name TEXT, value TEXT )";
    private static final String SELECT_BOUNDS = "select value from metadata where name='bounds'";
    private static final String SELECT_IMAGEFORMAT = "select value from metadata where name='format'";
    private static final String INDEX_TILES = "CREATE UNIQUE INDEX tile_index ON tiles (zoom_level, tile_column, tile_row)";
    private static final String INDEX_METADATA = "CREATE UNIQUE INDEX name ON metadata( name)";
    private Connection connection;
    private volatile int addedTiles = 0;
    private String imageFormat;
    private PreparedStatement batchStatement;
    private String insertTileSql;

    public MBTilesHelper() {
        StringBuilder sb = new StringBuilder();
        sb.append("INSERT INTO tiles ");
        sb.append("(");
        sb.append(COL_TILES_ZOOM_LEVEL);
        sb.append(",");
        sb.append(COL_TILES_TILE_COLUMN);
        sb.append(",");
        sb.append(COL_TILES_TILE_ROW);
        sb.append(",");
        sb.append(COL_TILES_TILE_DATA);
        sb.append(") values (?,?,?,?)");
        this.insertTileSql = sb.toString();
    }

    public void open(File dbFile) throws SQLException {
        this.connection = DriverManager.getConnection("jdbc:sqlite:" + dbFile.getAbsolutePath());
    }

    @Override
    public void close() {
        try {
            if (this.connection != null) {
                this.connection.close();
            }
        }
        catch (SQLException e) {
            throw new ModelsRuntimeException("An error occurred while closing the database connection.", this);
        }
    }

    public void createTables(boolean makeIndexes) throws SQLException {
        try (Statement statement = this.connection.createStatement();){
            statement.addBatch("DROP TABLE IF EXISTS tiles");
            statement.addBatch("DROP TABLE IF EXISTS metadata");
            statement.addBatch(CREATE_TILES);
            statement.addBatch(CREATE_METADATA);
            if (makeIndexes) {
                statement.addBatch(INDEX_TILES);
                statement.addBatch(INDEX_METADATA);
            }
            statement.executeBatch();
        }
        this.connection.setAutoCommit(false);
    }

    public void createIndexes() throws SQLException {
        try (Statement statement = this.connection.createStatement();){
            statement.addBatch(INDEX_TILES);
            statement.addBatch(INDEX_METADATA);
            statement.executeBatch();
        }
        this.connection.commit();
    }

    public void fillMetadata(float n, float s, float w, float e, String name, String format, int minZoom, int maxZoom) throws SQLException {
        try (Statement statement = this.connection.createStatement();){
            String query = this.toMetadataQuery(COL_METADATA_NAME, name);
            statement.addBatch(query);
            query = this.toMetadataQuery("description", name);
            statement.addBatch(query);
            query = this.toMetadataQuery("format", format);
            statement.addBatch(query);
            query = this.toMetadataQuery("minZoom", "" + minZoom);
            statement.addBatch(query);
            query = this.toMetadataQuery("maxZoom", "" + maxZoom);
            statement.addBatch(query);
            query = this.toMetadataQuery("type", "baselayer");
            statement.addBatch(query);
            query = this.toMetadataQuery("version", "1.1");
            statement.addBatch(query);
            query = this.toMetadataQuery("bounds", w + "," + s + "," + e + "," + n);
            statement.addBatch(query);
            statement.executeBatch();
        }
        this.connection.commit();
    }

    private String toMetadataQuery(String key, String value) {
        StringBuilder sb = new StringBuilder();
        sb.append("INSERT INTO metadata ");
        sb.append("(");
        sb.append(COL_METADATA_NAME);
        sb.append(",");
        sb.append(COL_METADATA_VALUE);
        sb.append(") values ('");
        sb.append(key);
        sb.append("','");
        sb.append(value);
        sb.append("')");
        String query = sb.toString();
        return query;
    }

    public synchronized void addTile(int x, int y, int z, BufferedImage image, String format) throws Exception {
        ++this.addedTiles;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)image, format, baos);
        byte[] res = baos.toByteArray();
        StringBuilder sb = new StringBuilder();
        sb.append("INSERT INTO tiles ");
        sb.append("(");
        sb.append(COL_TILES_ZOOM_LEVEL);
        sb.append(",");
        sb.append(COL_TILES_TILE_COLUMN);
        sb.append(",");
        sb.append(COL_TILES_TILE_ROW);
        sb.append(",");
        sb.append(COL_TILES_TILE_DATA);
        sb.append(") values (");
        sb.append(z);
        sb.append(",");
        sb.append(x);
        sb.append(",");
        sb.append(y);
        sb.append(",");
        sb.append("?");
        sb.append(")");
        String query = sb.toString();
        try (PreparedStatement statement = this.connection.prepareStatement(query);){
            statement.setBytes(1, res);
            statement.execute();
        }
        if (this.addedTiles % 20 == 0) {
            this.connection.commit();
        }
    }

    public synchronized void addTileBatch(int x, int y, int z, BufferedImage image, String format, boolean sendBatch) throws Exception {
        ++this.addedTiles;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)image, format, baos);
        byte[] res = baos.toByteArray();
        if (this.batchStatement == null) {
            this.batchStatement = this.connection.prepareStatement(this.insertTileSql);
        }
        this.batchStatement.setInt(1, z);
        this.batchStatement.setInt(2, x);
        this.batchStatement.setInt(3, y);
        this.batchStatement.setBytes(4, res);
        this.batchStatement.addBatch();
        if (sendBatch) {
            this.batchStatement.executeBatch();
        }
    }

    public void triggerLastBatch() {
        try {
            if (this.batchStatement != null) {
                this.batchStatement.executeBatch();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public BufferedImage getTile(int x, int y, int z) throws Exception {
        try (PreparedStatement statement = this.connection.prepareStatement(SELECTQUERY);){
            statement.setInt(1, z);
            statement.setInt(2, x);
            statement.setInt(3, y);
            ResultSet resultSet = statement.executeQuery();
            if (resultSet.next()) {
                byte[] imageBytes = resultSet.getBytes(1);
                boolean orig = ImageIO.getUseCache();
                ImageIO.setUseCache(false);
                ByteArrayInputStream in = new ByteArrayInputStream(imageBytes);
                BufferedImage bufferedImage = ImageIO.read(in);
                ImageIO.setUseCache(orig);
                BufferedImage bufferedImage2 = bufferedImage;
                return bufferedImage2;
            }
        }
        return null;
    }

    public double[] getBounds() throws Exception {
        try (Statement statement = this.connection.createStatement();){
            ResultSet resultSet = statement.executeQuery(SELECT_BOUNDS);
            if (resultSet.next()) {
                double[] bounds;
                String boundsWSEN = resultSet.getString(1);
                String[] split = boundsWSEN.split(",");
                double[] dArray = bounds = new double[]{Double.parseDouble(split[0]), Double.parseDouble(split[1]), Double.parseDouble(split[2]), Double.parseDouble(split[3])};
                return dArray;
            }
        }
        return null;
    }

    public String getImageFormat() throws Exception {
        if (this.imageFormat == null) {
            try (Statement statement = this.connection.createStatement();){
                ResultSet resultSet = statement.executeQuery(SELECT_IMAGEFORMAT);
                if (resultSet.next()) {
                    this.imageFormat = resultSet.getString(1);
                }
            }
        }
        return this.imageFormat;
    }

    public static BufferedImage readGridcoverageImageForTile(AbstractGridCoverage2DReader reader, int x, int y, int zoom, CoordinateReferenceSystem resampleCrs) throws IOException {
        double north = MBTilesHelper.tile2lat(y, zoom);
        double south = MBTilesHelper.tile2lat(y + 1, zoom);
        double west = MBTilesHelper.tile2lon(x, zoom);
        double east = MBTilesHelper.tile2lon(x + 1, zoom);
        Coordinate ll = new Coordinate(west, south);
        Coordinate ur = new Coordinate(east, north);
        try {
            DefaultGeographicCRS sourceCRS = DefaultGeographicCRS.WGS84;
            MathTransform transform = CRS.findMathTransform((CoordinateReferenceSystem)sourceCRS, (CoordinateReferenceSystem)resampleCrs);
            ll = JTS.transform((Coordinate)ll, null, (MathTransform)transform);
            ur = JTS.transform((Coordinate)ur, null, (MathTransform)transform);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        BufferedImage image = ImageUtilities.imageFromReader(reader, 256, 256, ll.x, ur.x, ll.y, ur.y, resampleCrs);
        return image;
    }

    public static double tile2lon(int x, int z) {
        return (double)x / Math.pow(2.0, z) * 360.0 - 180.0;
    }

    public static double tile2lat(int y, int z) {
        double n = Math.PI - Math.PI * 2 * (double)y / Math.pow(2.0, z);
        return Math.toDegrees(Math.atan(Math.sinh(n)));
    }

    public static int[] getTileXY(double lat, double lon, int zoom) {
        int xtile = (int)Math.floor((lon + 180.0) / 360.0 * (double)(1 << zoom));
        int ytile = (int)Math.floor((1.0 - Math.log(Math.tan(Math.toRadians(lat)) + 1.0 / Math.cos(Math.toRadians(lat))) / Math.PI) / 2.0 * (double)(1 << zoom));
        if (xtile < 0) {
            xtile = 0;
        }
        if (xtile >= 1 << zoom) {
            xtile = (1 << zoom) - 1;
        }
        if (ytile < 0) {
            ytile = 0;
        }
        if (ytile >= 1 << zoom) {
            ytile = (1 << zoom) - 1;
        }
        ytile = (int)(Math.pow(2.0, zoom) - 1.0 - (double)ytile);
        return new int[]{xtile, ytile};
    }

    public static Envelope tile2boundingBox(int x, int y, int zoom) {
        double north = MBTilesHelper.tile2lat(y, zoom);
        double south = MBTilesHelper.tile2lat(y + 1, zoom);
        double west = MBTilesHelper.tile2lon(x, zoom);
        double east = MBTilesHelper.tile2lon(x + 1, zoom);
        Envelope bb = new Envelope(west, east, south, north);
        return bb;
    }

    static {
        try {
            Class.forName("org.sqlite.JDBC");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

