/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gears.modules.r.tmsgenerator;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import javax.imageio.ImageIO;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.hortonmachine.gears.libs.exceptions.ModelsIllegalargumentException;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.gears.modules.r.tmsgenerator.GlobalMercator;
import org.hortonmachine.gears.modules.r.tmsgenerator.MBTilesHelper;
import org.hortonmachine.gears.utils.files.FileUtilities;
import org.hortonmachine.gears.utils.time.EggClock;
import org.locationtech.jts.geom.Envelope;

@Description(value="Feeds a HortonMachine mapurl enabled TMS folder into a new mbtiles database.")
@Author(name="Andrea Antonello, Silvia Franceschi", contact="www.hydrologis.com")
@Keywords(value="tms, mbtiles")
@Label(value="Raster Processing")
@Name(value="mapurl2mbtiles")
@Status(value=10)
@License(value="http://www.gnu.org/licenses/gpl-3.0.html")
public class Mapurl2MbtilesConverter
extends HMModel {
    @Description(value="TMS folder mapurl file.")
    @UI(value="infile")
    @In
    public String inFile = null;
    private MBTilesHelper mbtilesHelper;
    private String format;
    private volatile int imageIndex = 0;
    private volatile double n = Double.NEGATIVE_INFINITY;
    private volatile double e = Double.NEGATIVE_INFINITY;
    private volatile double s = Double.POSITIVE_INFINITY;
    private volatile double w = Double.POSITIVE_INFINITY;

    @Execute
    public void process() throws Exception {
        this.checkNull(this.inFile);
        File mapurlFile = new File(this.inFile);
        LinkedHashMap<String, String> metadataMap = FileUtilities.readFileToHashMap(this.inFile, "=", false);
        String url = (String)((HashMap)metadataMap).get("url");
        if (url == null) {
            throw new ModelsIllegalargumentException("The supplied file doesn't seem to be a valid HortonMachine mapurl file.", this, this.pm);
        }
        this.format = url.endsWith("jpg") ? "jpg" : "png";
        File dbFile = FileUtilities.substituteExtention(mapurlFile, "mbtiles");
        String tilesetName = FileUtilities.getNameWithoutExtention(mapurlFile);
        File folderFile = new File(mapurlFile.getParentFile(), tilesetName);
        this.mbtilesHelper = new MBTilesHelper();
        this.mbtilesHelper.open(dbFile);
        this.mbtilesHelper.createTables(false);
        File[] zFolders = folderFile.listFiles();
        ArrayList<File> xFolder = new ArrayList<File>();
        for (File zFolder : zFolders) {
            File[] xFiles;
            for (File xFile : xFiles = zFolder.listFiles()) {
                if (!xFile.isDirectory()) continue;
                xFolder.add(xFile);
            }
        }
        GlobalMercator mercator = new GlobalMercator();
        int minZ = 1000;
        int maxZ = -1000;
        EggClock clock = new EggClock("Time check: ", " sec");
        clock.startAndPrint(System.out);
        for (File xFile : xFolder) {
            File[] yFiles;
            String zStr = xFile.getParentFile().getName();
            int z = Integer.parseInt(zStr);
            minZ = Math.min(minZ, z);
            maxZ = Math.max(maxZ, z);
            String xStr = xFile.getName();
            int x = Integer.parseInt(xStr);
            for (File yFile : yFiles = xFile.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File arg0, String name) {
                    boolean endsWithPng = name.endsWith("png");
                    boolean endsWithJpg = name.endsWith("jpg");
                    return endsWithPng || endsWithJpg;
                }
            })) {
                String yStr = FileUtilities.getNameWithoutExtention(yFile);
                int y = Integer.parseInt(yStr);
                Envelope wsen = mercator.TileLatLonBounds(x, y, z);
                this.n = Math.max(this.n, wsen.getMaxY());
                this.e = Math.max(this.e, wsen.getMaxX());
                this.s = Math.max(this.s, wsen.getMinY());
                this.w = Math.max(this.w, wsen.getMinX());
                try {
                    BufferedImage image = ImageIO.read(yFile);
                    this.mbtilesHelper.addTile(x, y, z, image, this.format);
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
                if (this.imageIndex % 1000 == 0) {
                    this.pm.message("Images inserted in db: " + this.imageIndex);
                    clock.printTimePassedInSeconds(System.out);
                }
                ++this.imageIndex;
            }
        }
        this.mbtilesHelper.fillMetadata((float)this.n, (float)this.s, (float)this.w, (float)this.e, "tilesetName", this.format, minZ, maxZ);
        this.mbtilesHelper.createIndexes();
        this.mbtilesHelper.close();
    }
}

