/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gears.modules.r.tmsgenerator;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Documentation;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.hortonmachine.gears.libs.exceptions.ModelsIOException;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.gears.modules.r.tmsgenerator.GlobalMercator;
import org.hortonmachine.gears.utils.CrsUtilities;
import org.hortonmachine.gears.utils.files.FileUtilities;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;

@Description(value="Module for the downloading of map tiles.")
@Documentation(value="")
@Author(name="Andrea Antonello", contact="http://www.hydrologis.com")
@Keywords(value="Raster, Vector, TMS, Tiles")
@Label(value="Raster Processing")
@Name(value="tmsdownloader")
@Status(value=10)
@License(value="General Public License Version 3 (GPLv3)")
@UI(value="hide")
public class OmsOnlineTilesDownloader
extends HMModel {
    @Description(value="An optional online tile service to include (XXX, YYY, ZZZ will be substituted by tile indexes and zoom level).")
    @In
    public String inServiceUrl = null;
    @Description(value="The type of tile source (0 = TMS, 1 = google).")
    @In
    public int pType = 0;
    @Description(value="A name of the tile source.")
    @In
    public String pName = "tmstiles";
    @Description(value="The min zoom for which to generate tiles.")
    @In
    public Integer pMinzoom = null;
    @Description(value="The max zoom for which to generate tiles.")
    @In
    public Integer pMaxzoom = null;
    @Description(value="The north bound of the region to consider.")
    @UI(value="process_north")
    @In
    public Double pNorth = null;
    @Description(value="The south bound of the region to consider.")
    @UI(value="process_south")
    @In
    public Double pSouth = null;
    @Description(value="The west bound of the region to consider.")
    @UI(value="process_west")
    @In
    public Double pWest = null;
    @Description(value="The east bound of the region to consider.")
    @UI(value="process_east")
    @In
    public Double pEast = null;
    @Description(value="The coordinate reference system of the bound coordinates (ex. EPSG:4328).")
    @UI(value="crs")
    @In
    public String pEpsg;
    @Description(value="Switch that set to true allows for some error due to different datums. If set to false, it won't reproject without Bursa Wolf parameters.")
    @In
    public boolean doLenient = true;
    @Description(value="The folder inside which to create the tiles.")
    @In
    public String inPath;
    public static final String OMSONLINETILESDOWNLOADER_DESCRIPTION = "Module for the downloading of map tiles.";
    public static final String OMSONLINETILESDOWNLOADER_DOCUMENTATION = "";
    public static final String OMSONLINETILESDOWNLOADER_KEYWORDS = "Raster, Vector, TMS, Tiles";
    public static final String OMSONLINETILESDOWNLOADER_LABEL = "Raster Processing";
    public static final String OMSONLINETILESDOWNLOADER_NAME = "tmsdownloader";
    public static final int OMSONLINETILESDOWNLOADER_STATUS = 10;
    public static final String OMSONLINETILESDOWNLOADER_LICENSE = "General Public License Version 3 (GPLv3)";
    public static final String OMSONLINETILESDOWNLOADER_AUTHORNAMES = "Andrea Antonello";
    public static final String OMSONLINETILESDOWNLOADER_AUTHORCONTACTS = "http://www.hydrologis.com";
    public static final String OMSONLINETILESDOWNLOADER_UI = "hide";
    public static final String OMSONLINETILESDOWNLOADER_inServiceUrl_DESCRIPTION = "An optional online tile service to include (XXX, YYY, ZZZ will be substituted by tile indexes and zoom level).";
    public static final String OMSONLINETILESDOWNLOADER_pType_DESCRIPTION = "The type of tile source (0 = TMS, 1 = google).";
    public static final String OMSONLINETILESDOWNLOADER_pName_DESCRIPTION = "A name of the tile source.";
    public static final String OMSONLINETILESDOWNLOADER_pMinzoom_DESCRIPTION = "The min zoom for which to generate tiles.";
    public static final String OMSONLINETILESDOWNLOADER_pMaxzoom_DESCRIPTION = "The max zoom for which to generate tiles.";
    public static final String OMSONLINETILESDOWNLOADER_pNorth_DESCRIPTION = "The north bound of the region to consider.";
    public static final String OMSONLINETILESDOWNLOADER_pSouth_DESCRIPTION = "The south bound of the region to consider.";
    public static final String OMSONLINETILESDOWNLOADER_pWest_DESCRIPTION = "The west bound of the region to consider.";
    public static final String OMSONLINETILESDOWNLOADER_pEast_DESCRIPTION = "The east bound of the region to consider.";
    public static final String OMSONLINETILESDOWNLOADER_pEpsg_DESCRIPTION = "The coordinate reference system of the bound coordinates (ex. EPSG:4328).";
    public static final String OMSONLINETILESDOWNLOADER_doLenient_DESCRIPTION = "Switch that set to true allows for some error due to different datums. If set to false, it won't reproject without Bursa Wolf parameters.";
    public static final String OMSONLINETILESDOWNLOADER_inPath_DESCRIPTION = "The folder inside which to create the tiles.";
    private boolean doDryrun = false;
    private static final String EPSG_MERCATOR = "EPSG:3857";
    private static final String EPSG_LATLONG = "EPSG:4326";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Execute
    public void process() throws Exception {
        this.checkNull(this.inPath, this.inServiceUrl, this.pEpsg, this.pMinzoom, this.pMaxzoom, this.pWest, this.pEast, this.pSouth, this.pNorth);
        CoordinateReferenceSystem boundsCrs = CrsUtilities.getCrsFromEpsg(this.pEpsg, null);
        CoordinateReferenceSystem mercatorCrs = CrsUtilities.getCrsFromEpsg(EPSG_MERCATOR, null);
        CoordinateReferenceSystem latLongCrs = CrsUtilities.getCrsFromEpsg(EPSG_LATLONG, null);
        ReferencedEnvelope inBounds = new ReferencedEnvelope(this.pWest.doubleValue(), this.pEast.doubleValue(), this.pSouth.doubleValue(), this.pNorth.doubleValue(), boundsCrs);
        MathTransform in2MercatorTransform = CRS.findMathTransform((CoordinateReferenceSystem)boundsCrs, (CoordinateReferenceSystem)mercatorCrs);
        Envelope mercatorEnvelope = JTS.transform((Envelope)inBounds, (MathTransform)in2MercatorTransform);
        ReferencedEnvelope mercatorBounds = new ReferencedEnvelope(mercatorEnvelope, mercatorCrs);
        MathTransform transform = CRS.findMathTransform((CoordinateReferenceSystem)boundsCrs, (CoordinateReferenceSystem)latLongCrs);
        Envelope latLongBounds = JTS.transform((Envelope)inBounds, (MathTransform)transform);
        Coordinate latLongCentre = latLongBounds.centre();
        File inFolder = new File(this.inPath);
        File baseFolder = new File(inFolder, this.pName);
        double w = latLongBounds.getMinX();
        double s = latLongBounds.getMinY();
        double e = latLongBounds.getMaxX();
        double n = latLongBounds.getMaxY();
        GlobalMercator mercator = new GlobalMercator();
        for (int z = this.pMinzoom.intValue(); z <= this.pMaxzoom; ++z) {
            int[] llTileXY = mercator.GoogleTile(s, w, z);
            int[] urTileXY = mercator.GoogleTile(n, e, z);
            int startXTile = Math.min(llTileXY[0], urTileXY[0]);
            int endXTile = Math.max(llTileXY[0], urTileXY[0]);
            int startYTile = Math.min(llTileXY[1], urTileXY[1]);
            int endYTile = Math.max(llTileXY[1], urTileXY[1]);
            int tileNum = 0;
            ReferencedEnvelope levelBounds = new ReferencedEnvelope();
            this.pm.beginTask("Generating tiles at zoom level: " + z, endXTile - startXTile + 1);
            for (int i = startXTile; i <= endXTile; ++i) {
                for (int j = startYTile; j <= endYTile; ++j) {
                    ++tileNum;
                    Envelope bounds = mercator.TileLatLonBounds(i, j, z);
                    ReferencedEnvelope tmpBounds = new ReferencedEnvelope(bounds, latLongCrs);
                    levelBounds.expandToInclude((Envelope)tmpBounds);
                    if (this.doDryrun) continue;
                    int[] onlineTileNumbers = new int[]{i, j};
                    int[] fileNameTileNumbers = new int[]{i, j};
                    int[] tmsNUms = mercator.TMSTileFromGoogleTile(i, j, z);
                    fileNameTileNumbers = tmsNUms;
                    File imageFolder = new File(baseFolder, z + "/" + fileNameTileNumbers[0]);
                    if (!imageFolder.exists() && !imageFolder.mkdirs()) {
                        throw new ModelsIOException("Unable to create folder:" + imageFolder, this);
                    }
                    File imageFile = new File(imageFolder, fileNameTileNumbers[1] + ".png");
                    if (imageFile.exists()) continue;
                    String tmp = this.inServiceUrl.replaceFirst("ZZZ", String.valueOf(z));
                    tmp = tmp.replaceFirst("XXX", String.valueOf(onlineTileNumbers[0]));
                    tmp = tmp.replaceFirst("YYY", String.valueOf(onlineTileNumbers[1]));
                    URL url = new URL(tmp);
                    InputStream imgStream = null;
                    FileOutputStream out = null;
                    try {
                        imgStream = url.openStream();
                        out = new FileOutputStream(imageFile);
                        int read = 0;
                        byte[] bytes = new byte[1024];
                        while ((read = imgStream.read(bytes)) != -1) {
                            ((OutputStream)out).write(bytes, 0, read);
                        }
                        continue;
                    }
                    catch (Exception ex) {
                        this.pm.errorMessage("Unable to get image: " + tmp);
                        continue;
                    }
                    finally {
                        if (imgStream != null) {
                            imgStream.close();
                        }
                        if (out != null) {
                            out.flush();
                            ((OutputStream)out).close();
                        }
                    }
                }
                this.pm.worked(1);
            }
            this.pm.done();
            this.pm.message("Zoom level: " + z + " has " + tileNum + " tiles.");
            this.pm.message("Boundary covered at Zoom level: " + z + ": " + levelBounds);
            this.pm.message("Total boundary wanted: " + mercatorBounds);
        }
        StringBuilder properties = new StringBuilder();
        properties.append("url=").append(this.pName).append("/ZZZ/XXX/YYY.png\n");
        properties.append("minzoom=").append(this.pMinzoom).append("\n");
        properties.append("maxzoom=").append(this.pMaxzoom).append("\n");
        properties.append("center=").append(latLongCentre.x).append(" ").append(latLongCentre.y).append("\n");
        properties.append("type=tms").append("\n");
        File propFile = new File(inFolder, this.pName + ".mapurl");
        FileUtilities.writeFile(properties.toString(), propFile);
    }
}

