/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gears.modules.r.tmsgenerator;

import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.net.URL;
import javax.imageio.ImageIO;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.hortonmachine.gears.io.vectorreader.OmsVectorReader;
import org.hortonmachine.gears.libs.monitor.IHMProgressMonitor;
import org.hortonmachine.gears.libs.monitor.LogProgressMonitor;
import org.hortonmachine.gears.utils.CrsUtilities;
import org.hortonmachine.gears.utils.files.FileUtilities;
import org.locationtech.jts.geom.Coordinate;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;

public class OpenstreetmapImageCreator {
    private static final String EPSG_MERCATOR = "EPSG:3857";
    private String inServiceUrl;
    private int zoomLevel;
    private ReferencedEnvelope mercatorBounds;
    private IHMProgressMonitor pm;
    private File outFile;

    public OpenstreetmapImageCreator(String inServiceUrl, int zoomLevel, ReferencedEnvelope mercatorBounds, File outFile, IHMProgressMonitor pm) {
        this.inServiceUrl = inServiceUrl;
        this.zoomLevel = zoomLevel;
        this.mercatorBounds = mercatorBounds;
        this.outFile = outFile;
        this.pm = pm;
    }

    public void generate() throws Exception {
        CoordinateReferenceSystem mercatorCrs = CrsUtilities.getCrsFromEpsg(EPSG_MERCATOR, null);
        DefaultGeographicCRS latLongCrs = DefaultGeographicCRS.WGS84;
        ReferencedEnvelope llBounds = this.mercatorBounds.transform((CoordinateReferenceSystem)latLongCrs, true);
        double w = llBounds.getMinX();
        double e = llBounds.getMaxX();
        double s = llBounds.getMinY();
        double n = llBounds.getMaxY();
        int[] ulTileNumber = OpenstreetmapImageCreator.getTileXY(n, w, this.zoomLevel);
        int[] lrTileNumber = OpenstreetmapImageCreator.getTileXY(s, e, this.zoomLevel);
        int startXTile = ulTileNumber[0];
        int startYTile = ulTileNumber[1];
        int endXTile = lrTileNumber[0];
        int endYTile = lrTileNumber[1];
        BoundingBox bbUL = this.tile2boundingBox(startXTile, startYTile, this.zoomLevel);
        double imageW = bbUL.west;
        double imageN = bbUL.north;
        BoundingBox bbLR = this.tile2boundingBox(endXTile, endYTile, this.zoomLevel);
        double imageS = bbLR.south;
        double imageE = bbLR.east;
        int tileCols = endXTile - startXTile + 1;
        int tileRows = endYTile - startYTile + 1;
        int tileSize = 256;
        int height = tileRows * tileSize;
        int width = tileCols * tileSize;
        BufferedImage outImage = new BufferedImage(width, height, 1);
        Graphics2D g2d = (Graphics2D)outImage.getGraphics();
        this.pm.beginTask("Generating tiles at zoom level: " + this.zoomLevel + " with tiles: " + tileCols + "x" + tileRows, endXTile - startXTile + 1);
        int runningX = 0;
        for (int x = startXTile; x <= endXTile; ++x) {
            int runningY = 0;
            for (int y = startYTile; y <= endYTile; ++y) {
                String tmp = this.inServiceUrl.replaceFirst("ZZZ", String.valueOf(this.zoomLevel));
                tmp = tmp.replaceFirst("XXX", String.valueOf(x));
                tmp = tmp.replaceFirst("YYY", String.valueOf(y));
                URL url = new URL(tmp);
                try {
                    BufferedImage tileImage = ImageIO.read(url);
                    g2d.drawImage(tileImage, null, runningX, runningY);
                }
                catch (Exception ex) {
                    this.pm.errorMessage("Unable to get image: " + tmp);
                }
                runningY += tileSize;
            }
            runningX += tileSize;
            this.pm.worked(1);
        }
        this.pm.done();
        g2d.dispose();
        String nameL = this.outFile.getName().toLowerCase();
        if (nameL.endsWith("png")) {
            ImageIO.write((RenderedImage)outImage, "png", this.outFile);
        } else if (nameL.endsWith("jpg")) {
            ImageIO.write((RenderedImage)outImage, "jpg", this.outFile);
        } else if (nameL.endsWith("tiff")) {
            ImageIO.write((RenderedImage)outImage, "tiff", this.outFile);
        }
        MathTransform transform = CRS.findMathTransform((CoordinateReferenceSystem)latLongCrs, (CoordinateReferenceSystem)mercatorCrs);
        Coordinate llES = new Coordinate(imageE, imageS);
        Coordinate llWN = new Coordinate(imageW, imageN);
        Coordinate osmES = JTS.transform((Coordinate)llES, null, (MathTransform)transform);
        Coordinate osmWN = JTS.transform((Coordinate)llWN, null, (MathTransform)transform);
        double dx = (osmES.x - osmWN.x) / (double)width;
        double dy = (osmWN.y - osmES.y) / (double)height;
        StringBuilder sb = new StringBuilder();
        sb.append(dx).append("\n");
        sb.append("0.00000000").append("\n");
        sb.append("0.00000000").append("\n");
        sb.append(-dy).append("\n");
        sb.append(osmWN.x).append("\n");
        sb.append(osmWN.y).append("\n");
        String fileName = FileUtilities.getNameWithoutExtention(this.outFile);
        File folder = this.outFile.getParentFile();
        File tfwFile = new File(folder, fileName + ".tfw");
        FileUtilities.writeFile(sb.toString(), tfwFile);
        File prjFile = new File(folder, fileName + ".prj");
        FileUtilities.writeFile(mercatorCrs.toWKT(), prjFile);
    }

    private static int[] getTileXY(double lat, double lon, int zoom) {
        int xtile = (int)Math.floor((lon + 180.0) / 360.0 * (double)(1 << zoom));
        int ytile = (int)Math.floor((1.0 - Math.log(Math.tan(Math.toRadians(lat)) + 1.0 / Math.cos(Math.toRadians(lat))) / Math.PI) / 2.0 * (double)(1 << zoom));
        if (xtile < 0) {
            xtile = 0;
        }
        if (xtile >= 1 << zoom) {
            xtile = (1 << zoom) - 1;
        }
        if (ytile < 0) {
            ytile = 0;
        }
        if (ytile >= 1 << zoom) {
            ytile = (1 << zoom) - 1;
        }
        return new int[]{xtile, ytile};
    }

    private BoundingBox tile2boundingBox(int x, int y, int zoom) {
        BoundingBox bb = new BoundingBox();
        bb.north = OpenstreetmapImageCreator.tile2lat(y, zoom);
        bb.south = OpenstreetmapImageCreator.tile2lat(y + 1, zoom);
        bb.west = OpenstreetmapImageCreator.tile2lon(x, zoom);
        bb.east = OpenstreetmapImageCreator.tile2lon(x + 1, zoom);
        return bb;
    }

    private static double tile2lon(int x, int z) {
        return (double)x / Math.pow(2.0, z) * 360.0 - 180.0;
    }

    private static double tile2lat(int y, int z) {
        double n = Math.PI - Math.PI * 2 * (double)y / Math.pow(2.0, z);
        return Math.toDegrees(Math.atan(Math.sinh(n)));
    }

    public static void main(String[] args) throws Exception {
        String outFile = "/home/hydrologis/Dropbox/hydrologis/lavori/2015_05_bim_sarcamincio/shape_3857/image_output/osm15.png";
        String bounds = "/home/hydrologis/Dropbox/hydrologis/lavori/2015_05_bim_sarcamincio/shape_3857/area.shp";
        String inServiceUrl = "http://a.tile.opencyclemap.org/cycle/ZZZ/XXX/YYY.png";
        ReferencedEnvelope env = OmsVectorReader.readVector(bounds).getBounds();
        OpenstreetmapImageCreator c = new OpenstreetmapImageCreator(inServiceUrl, 15, env, new File(outFile), new LogProgressMonitor());
        c.generate();
    }

    private class BoundingBox {
        double north;
        double south;
        double east;
        double west;

        private BoundingBox() {
        }
    }
}

