/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gears.modules.r.tmsgenerator;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import javax.imageio.ImageIO;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Documentation;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.hortonmachine.gears.io.rasterwriter.OmsRasterWriter;
import org.hortonmachine.gears.libs.exceptions.ModelsIllegalargumentException;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.gears.modules.r.tmsgenerator.GlobalMercator;
import org.hortonmachine.gears.utils.CrsUtilities;
import org.hortonmachine.gears.utils.RegionMap;
import org.hortonmachine.gears.utils.coverage.CoverageUtilities;
import org.locationtech.jts.geom.Envelope;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

@Description(value="Module for the downloading map tiles of a TMS service and convert them to geotiff.")
@Documentation(value="")
@Author(name="Andrea Antonello", contact="http://www.hydrologis.com")
@Keywords(value="Raster, Vector, TMS, Tiles")
@Label(value="Raster Processing")
@Name(value="tms2geotiff")
@Status(value=10)
@License(value="General Public License Version 3 (GPLv3)")
public class TmsWms2Geotiff
extends HMModel {
    @Description(value="An online tile service with XXX,YYY,ZZZ or SSS,WWW,NNN,EEE to be substituted by indexes or bounds.")
    @In
    public String inServiceUrl = null;
    @Description(value="Region of interest shapefile path")
    @UI(value="infile_vector")
    @In
    public String inRoiPath = null;
    @Description(value="The tile schema type.")
    @UI(value="combo:OGC TMS,Google")
    @In
    public String pSchemaType = "TMS";
    @Description(value="The source schema type.")
    @UI(value="combo:TMS,WMS")
    @In
    public String pSourceType = "TMS";
    @Description(value="The zoom level for which to generate the geotiff.")
    @In
    public Integer pZoomlevel = null;
    @Description(value="The output geotiff path.")
    @UI(value="outfile")
    @In
    public String outRaster = null;
    public static final String OmsOnlineTiles2Geotiff_REGION_OF_INTEREST_SHAPEFILE_PATH = "Region of interest shapefile path";
    public static final String OmsOnlineTiles2Geotiff_DESCRIPTION = "Module for the downloading map tiles of a TMS service and convert them to geotiff.";
    public static final String OmsOnlineTiles2Geotiff_DOCUMENTATION = "";
    public static final String OmsOnlineTiles2Geotiff_KEYWORDS = "Raster, Vector, TMS, Tiles";
    public static final String OmsOnlineTiles2Geotiff_LABEL = "Raster Processing";
    public static final String OmsOnlineTiles2Geotiff_NAME = "tms2geotiff";
    public static final int OmsOnlineTiles2Geotiff_STATUS = 10;
    public static final String OmsOnlineTiles2Geotiff_LICENSE = "General Public License Version 3 (GPLv3)";
    public static final String OmsOnlineTiles2Geotiff_AUTHORNAMES = "Andrea Antonello";
    public static final String OmsOnlineTiles2Geotiff_AUTHORCONTACTS = "http://www.hydrologis.com";
    public static final String OmsOnlineTiles2Geotiff_inServiceUrl_DESCRIPTION = "An online tile service with XXX,YYY,ZZZ or SSS,WWW,NNN,EEE to be substituted by indexes or bounds.";
    public static final String OmsOnlineTiles2Geotiff_pType_DESCRIPTION = "The tile schema type.";
    public static final String OmsOnlineTiles2Geotiff_pSourceType_DESCRIPTION = "The source schema type.";
    public static final String OmsOnlineTiles2Geotiff_outRaster_DESCRIPTION = "The output geotiff path.";
    public static final String OmsOnlineTiles2Geotiff_pMinzoom_DESCRIPTION = "The zoom level for which to generate the geotiff.";
    private static final String EPSG_MERCATOR = "EPSG:3857";
    private static final int tileSize = 256;
    private static final boolean doDebug = false;

    @Execute
    public void process() throws Exception {
        this.checkNull(this.inServiceUrl, this.outRaster, this.inRoiPath);
        CoordinateReferenceSystem mercatorCrs = CrsUtilities.getCrsFromEpsg(EPSG_MERCATOR, null);
        DefaultGeographicCRS latLongCrs = DefaultGeographicCRS.WGS84;
        SimpleFeatureCollection inRoi = this.getVector(this.inRoiPath);
        ReferencedEnvelope inBounds = inRoi.getBounds();
        ReferencedEnvelope latLongBounds = inBounds.transform((CoordinateReferenceSystem)latLongCrs, true);
        double w = latLongBounds.getMinX();
        double s = latLongBounds.getMinY();
        double e = latLongBounds.getMaxX();
        double n = latLongBounds.getMaxY();
        int z = 18;
        if (this.pZoomlevel != null) {
            z = this.pZoomlevel;
        }
        GlobalMercator gm = new GlobalMercator();
        int[] llTileXY = gm.GoogleTile(s, w, z);
        int[] urTileXY = gm.GoogleTile(n, e, z);
        int startXTile = Math.min(llTileXY[0], urTileXY[0]);
        int endXTile = Math.max(llTileXY[0], urTileXY[0]);
        int startYTile = Math.min(llTileXY[1], urTileXY[1]);
        int endYTile = Math.max(llTileXY[1], urTileXY[1]);
        if (this.pSchemaType.equals("OGC TMS")) {
            llTileXY = gm.TMSTileFromGoogleTile(llTileXY[0], llTileXY[1], z);
            urTileXY = gm.TMSTileFromGoogleTile(urTileXY[0], urTileXY[1], z);
        }
        startXTile = Math.min(llTileXY[0], urTileXY[0]);
        endXTile = Math.max(llTileXY[0], urTileXY[0]);
        startYTile = Math.min(llTileXY[1], urTileXY[1]);
        endYTile = Math.max(llTileXY[1], urTileXY[1]);
        int tilesCountX = endXTile - startXTile + 1;
        int tilesCountY = endYTile - startYTile + 1;
        int width = tilesCountX * 256;
        int height = tilesCountY * 256;
        BufferedImage img = new BufferedImage(width, height, 1);
        Graphics2D g2d = (Graphics2D)img.getGraphics();
        int tileNum = 0;
        ReferencedEnvelope finalMercatorBounds = new ReferencedEnvelope(mercatorCrs);
        this.pm.beginTask("Getting tiles at zoom level: " + z, endXTile - startXTile + 1);
        int runningXPix = 0;
        int runningYPix = 0;
        for (int x = startXTile; x <= endXTile; ++x) {
            for (int y = startYTile; y <= endYTile; ++y) {
                ++tileNum;
                int yy = y;
                if (this.pSchemaType.equalsIgnoreCase("Google")) {
                    yy = (int)(Math.pow(2.0, z) - 1.0 - (double)y);
                }
                double[] bounds = gm.TileBounds(x, yy, z);
                double west = bounds[0];
                double south = bounds[1];
                double east = bounds[2];
                double north = bounds[3];
                ReferencedEnvelope tmpBounds = new ReferencedEnvelope(west, east, south, north, mercatorCrs);
                finalMercatorBounds.expandToInclude((Envelope)tmpBounds);
                String tmp = OmsOnlineTiles2Geotiff_DOCUMENTATION;
                if (this.pSourceType.equals("TMS")) {
                    tmp = this.inServiceUrl.replaceFirst("ZZZ", String.valueOf(z));
                    tmp = tmp.replaceFirst("XXX", String.valueOf(x));
                    tmp = tmp.replaceFirst("YYY", String.valueOf(y));
                } else if (this.pSourceType.equals("WMS")) {
                    ReferencedEnvelope llTB = tmpBounds.transform((CoordinateReferenceSystem)latLongCrs, true);
                    tmp = this.inServiceUrl.replaceFirst("SSS", String.valueOf(llTB.getMinY()));
                    tmp = tmp.replaceFirst("NNN", String.valueOf(llTB.getMaxY()));
                    tmp = tmp.replaceFirst("WWW", String.valueOf(llTB.getMinX()));
                    tmp = tmp.replaceFirst("EEE", String.valueOf(llTB.getMaxX()));
                } else {
                    throw new ModelsIllegalargumentException("Source Type can be only 0 or 1.", this);
                }
                URL url = new URL(tmp);
                try (InputStream imgStream = url.openStream();){
                    BufferedImage tileImg = ImageIO.read(imgStream);
                    g2d.drawImage((Image)tileImg, runningXPix, runningYPix, null);
                }
                catch (Exception ex) {
                    this.pm.errorMessage("Unable to get image: " + tmp);
                }
                runningYPix += 256;
            }
            runningXPix += 256;
            runningYPix = 0;
            this.pm.worked(1);
        }
        this.pm.done();
        this.pm.message("Zoom level: " + z + " has " + tileNum + " tiles.");
        double ww = finalMercatorBounds.getMinX();
        double ss = finalMercatorBounds.getMinY();
        double ee = finalMercatorBounds.getMaxX();
        double nn = finalMercatorBounds.getMaxY();
        double xres = (ee - ww) / (double)width;
        double yres = (nn - ss) / (double)height;
        RegionMap envelopeParams = new RegionMap();
        envelopeParams.put("NORTH", nn);
        envelopeParams.put("SOUTH", ss);
        envelopeParams.put("WEST", ww);
        envelopeParams.put("EAST", ee);
        envelopeParams.put("XRES", xres);
        envelopeParams.put("YRES", yres);
        envelopeParams.put("ROWS", Double.valueOf(height));
        envelopeParams.put("COLS", Double.valueOf(width));
        GridCoverage2D coverage = CoverageUtilities.buildCoverage("tmsraster", img, (HashMap<String, Double>)envelopeParams, mercatorCrs);
        OmsRasterWriter.writeRaster(this.outRaster, coverage);
    }

    public static void main(String[] args) throws Exception {
        TmsWms2Geotiff g = new TmsWms2Geotiff();
        g.inRoiPath = "/home/hydrologis/TMP/VIENNA/roi.shp";
        g.inServiceUrl = "http://maps.wien.gv.at/wmts/lb/farbe/google3857/ZZZ/YYY/XXX.jpeg";
        g.outRaster = "/home/hydrologis/TMP/VIENNA/vienna_zoom19.tiff";
        g.pSourceType = "TMS";
        g.pSchemaType = "Google";
        g.pZoomlevel = 19;
        g.process();
    }
}

