/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gears.modules.utils;

import java.awt.Point;
import java.awt.image.RenderedImage;
import java.util.HashSet;
import java.util.Iterator;
import javax.media.jai.iterator.RandomIter;
import javax.media.jai.iterator.RandomIterFactory;

public class BinaryFast {
    public static final int BACKGROUND = 0;
    public static final int FOREGROUND = 1;
    private int width;
    private int height;
    private int size;
    private int[][] pixels;
    private HashSet<Point> foregroundEdgePixels = new HashSet();
    private HashSet<Point> backgroundEdgePixels = new HashSet();

    public BinaryFast(int[][] data) {
        this.width = data.length;
        this.height = data[0].length;
        this.pixels = data;
        this.size = this.width * this.height;
        this.generateForegroundEdge();
        this.generateBackgroundEdgeFromForegroundEdge();
    }

    public BinaryFast(RenderedImage renderedImage) {
        this.width = renderedImage.getWidth();
        this.height = renderedImage.getHeight();
        this.pixels = new int[this.width][this.height];
        this.size = this.width * this.height;
        RandomIter iter = RandomIterFactory.create((RenderedImage)renderedImage, null);
        for (int i = 0; i < this.pixels.length; ++i) {
            for (int j = 0; j < this.pixels[0].length; ++j) {
                double sample = iter.getSampleDouble(i, j, 0);
                this.pixels[i][j] = sample == 1.0 ? 1 : 0;
            }
        }
        this.generateForegroundEdge();
        this.generateBackgroundEdgeFromForegroundEdge();
    }

    public void removePixel(Point p) {
        this.pixels[p.x][p.y] = 0;
    }

    public void addPixel(Point p) {
        this.pixels[p.x][p.y] = 1;
    }

    public int[] convertToArray() {
        int[] p = new int[this.size];
        for (int j = 0; j < this.height; ++j) {
            for (int i = 0; i < this.width; ++i) {
                p[j * this.width + i] = this.pixels[i][j];
            }
        }
        return p;
    }

    public void generatePixels(HashSet<Point> pix) {
        for (int j = 0; j < this.height; ++j) {
            for (int i = 0; i < this.width; ++i) {
                this.pixels[i][j] = 0;
            }
        }
        this.convertToPixels(pix);
    }

    public void convertToPixels(HashSet<Point> pix) {
        for (Point p : pix) {
            this.pixels[p.x][p.y] = 1;
        }
    }

    public void generateForegroundEdge() {
        this.foregroundEdgePixels.clear();
        for (int n = 0; n < this.height; ++n) {
            for (int m = 0; m < this.width; ++m) {
                if (this.pixels[m][n] != 1) continue;
                Point p = new Point(m, n);
                for (int j = -1; j < 2; ++j) {
                    for (int i = -1; i < 2; ++i) {
                        if (p.x + i < 0 || p.x + i >= this.width || p.y + j < 0 || p.y + j >= this.height || this.pixels[p.x + i][p.y + j] != 0 || this.foregroundEdgePixels.contains(p)) continue;
                        this.foregroundEdgePixels.add(p);
                    }
                }
            }
        }
    }

    public void generateBackgroundEdgeFromForegroundEdge() {
        this.backgroundEdgePixels.clear();
        Iterator<Point> it = this.foregroundEdgePixels.iterator();
        while (it.hasNext()) {
            Point p = new Point(it.next());
            for (int j = -1; j < 2; ++j) {
                for (int i = -1; i < 2; ++i) {
                    if (p.x + i < 0 || p.x + i >= this.width || p.y + j < 0 || p.y + j >= this.height) continue;
                    Point p2 = new Point(p.x + i, p.y + j);
                    if (this.pixels[p2.x][p2.y] != 0) continue;
                    this.backgroundEdgePixels.add(p2);
                }
            }
        }
    }

    public void generateForegroundEdgeFromBackgroundEdge() {
        this.foregroundEdgePixels.clear();
        Iterator<Point> it = this.backgroundEdgePixels.iterator();
        while (it.hasNext()) {
            Point p = new Point(it.next());
            for (int j = -1; j < 2; ++j) {
                for (int i = -1; i < 2; ++i) {
                    if (p.x + i < 0 || p.x + i >= this.width || p.y + j < 0 || p.y + j >= this.height) continue;
                    Point p2 = new Point(p.x + i, p.y + j);
                    if (this.pixels[p2.x][p2.y] != 1) continue;
                    this.foregroundEdgePixels.add(p2);
                }
            }
        }
    }

    public int[] getValues() {
        int[] graylevel = new int[this.size];
        int[] values1D = this.convertToArray();
        for (int i = 0; i < this.size; ++i) {
            graylevel[i] = values1D[i] & 0xFF;
        }
        return graylevel;
    }

    public HashSet<Point> getForegroundEdgePixels() {
        return this.foregroundEdgePixels;
    }

    public HashSet<Point> getBackgroundEdgePixels() {
        return this.backgroundEdgePixels;
    }

    public int[][] getPixels() {
        return this.pixels;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }
}

