/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gears.modules.utils.coveragelist;

import java.util.ArrayList;
import java.util.List;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Documentation;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Out;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.geotools.coverage.grid.GridCoverage2D;
import org.hortonmachine.gears.io.rasterreader.OmsRasterReader;
import org.hortonmachine.gears.libs.modules.HMModel;

@Description(value="A module that reads rasters.")
@Documentation(value="")
@Author(name="Andrea Antonello", contact="http://www.hydrologis.com")
@Keywords(value="Iterator, Raster")
@Label(value="List Data Reader")
@Name(value="rasterlister")
@Status(value=40)
@License(value="General Public License Version 3 (GPLv3)")
public class OmsCoverageLister
extends HMModel {
    @Description(value="The list of file from which to read rasters.")
    @UI(value="filespathlist")
    @In
    public List<String> inFiles;
    @Description(value="The optional requested boundary north coordinate.")
    @UI(value="process_north")
    @In
    public Double pNorth = null;
    @Description(value="The optional requested boundary south coordinate.")
    @UI(value="process_south")
    @In
    public Double pSouth = null;
    @Description(value="The optional requested boundary west coordinate.")
    @UI(value="process_west")
    @In
    public Double pWest = null;
    @Description(value="The optional requested boundary east coordinate.")
    @UI(value="process_east")
    @In
    public Double pEast = null;
    @Description(value="The optional requested resolution in x.")
    @UI(value="process_xres")
    @In
    public Double pXres = null;
    @Description(value="The optional requested resolution in y.")
    @UI(value="process_yres")
    @In
    public Double pYres = null;
    @Description(value="The optional requested numer of rows.")
    @UI(value="process_rows")
    @In
    public Integer pRows = null;
    @Description(value="The optional requested numer of cols.")
    @UI(value="process_cols")
    @In
    public Integer pCols = null;
    @Description(value="All rasters matching read from the input files.")
    @Out
    public List<GridCoverage2D> outGC = null;

    @Execute
    public void process() throws Exception {
        this.outGC = new ArrayList<GridCoverage2D>();
        for (String file : this.inFiles) {
            OmsRasterReader reader = new OmsRasterReader();
            reader.file = file;
            reader.pNorth = this.pNorth;
            reader.pSouth = this.pSouth;
            reader.pWest = this.pWest;
            reader.pEast = this.pEast;
            reader.pXres = this.pXres;
            reader.pYres = this.pYres;
            reader.pRows = this.pRows;
            reader.pCols = this.pCols;
            reader.process();
            this.outGC.add(reader.outRaster);
        }
    }
}

