/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gears.modules.utils.featureslist;

import java.util.ArrayList;
import java.util.List;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Documentation;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Out;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.hortonmachine.gears.io.vectorreader.OmsVectorReader;
import org.hortonmachine.gears.libs.modules.HMModel;

@Description(value="A module that reads vectors.")
@Documentation(value="")
@Author(name="Andrea Antonello", contact="http://www.hydrologis.com")
@Keywords(value="Iterator, Vector")
@Label(value="List Data Reader")
@Name(value="vectorlister")
@Status(value=40)
@License(value="General Public License Version 3 (GPLv3)")
public class OmsFeaturesLister
extends HMModel {
    @Description(value="The list of file from which to read features.")
    @UI(value="filespathlist")
    @In
    public List<String> inFiles;
    @Description(value="All features read from the input files.")
    @Out
    public List<SimpleFeatureCollection> outFC = null;

    @Execute
    public void process() throws Exception {
        this.outFC = new ArrayList<SimpleFeatureCollection>();
        for (String file : this.inFiles) {
            SimpleFeatureCollection featureCollection = OmsVectorReader.readVector(file);
            this.outFC.add(featureCollection);
        }
    }
}

