/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gears.modules.v.contourlabels;

import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Documentation;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Out;
import oms3.annotations.Status;
import org.geotools.data.memory.MemoryDataStore;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.store.ContentFeatureSource;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.gears.utils.features.FilterUtilities;
import org.hortonmachine.gears.utils.geometry.GeometryUtilities;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.opengis.geometry.BoundingBox;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

@Description(value="Generates a layer of point features with a given label text and angle, following reference lines intersecting them with a layer of countourlines.")
@Documentation(value="")
@Author(name="Andrea Antonello", contact="www.hydrologis.com")
@Keywords(value="Contourlines, Vector")
@Label(value="Vector Processing")
@Name(value="contourlineslabeler")
@Status(value=5)
@License(value="http://www.gnu.org/licenses/gpl-3.0.html")
public class OmsContourLinesLabeler
extends HMModel {
    @Description(value="The contour lines.")
    @In
    public SimpleFeatureCollection inContour;
    @Description(value="Field name of the contour elevation")
    @In
    public String fElevation;
    @Description(value="The lines to intersect with the contours to generate label points.")
    @In
    public SimpleFeatureCollection inLines;
    @Description(value="The buffer to consider for every line.")
    @In
    public double buffer;
    @Description(value="The labeled point layer.")
    @Out
    public SimpleFeatureCollection outPoints = null;

    @Execute
    public void process() throws Exception {
        if (!this.concatOr(this.outPoints == null, this.doReset)) {
            return;
        }
        SimpleFeatureType inSchema = (SimpleFeatureType)this.inContour.getSchema();
        MemoryDataStore memDatastore = new MemoryDataStore(this.inContour);
        ContentFeatureSource contourSource = memDatastore.getFeatureSource(memDatastore.getTypeNames()[0]);
        CoordinateReferenceSystem crs = inSchema.getCoordinateReferenceSystem();
        this.outPoints = new DefaultFeatureCollection();
        SimpleFeatureTypeBuilder b = new SimpleFeatureTypeBuilder();
        b.setName("labelpoints");
        b.setCRS(crs);
        b.add("the_geom", Point.class);
        b.add("elevation", Double.class);
        b.add("azimuth", Double.class);
        b.add("minus90", Double.class);
        SimpleFeatureType outType = b.buildFeatureType();
        int count = 0;
        SimpleFeatureIterator lineFeatureIterator = this.inLines.features();
        while (lineFeatureIterator.hasNext()) {
            SimpleFeature line = (SimpleFeature)lineFeatureIterator.next();
            Geometry lineGeom = (Geometry)line.getDefaultGeometry();
            Geometry lineBuffer = lineGeom.buffer(this.buffer);
            BoundingBox lineBounds = line.getBounds();
            Filter bboxFilter = FilterUtilities.getBboxFilter("the_geom", lineBounds);
            SimpleFeatureCollection filteredContours = contourSource.getFeatures(bboxFilter);
            SimpleFeatureIterator contourIterator = filteredContours.features();
            while (contourIterator.hasNext()) {
                Coordinate second;
                SimpleFeature contour = (SimpleFeature)contourIterator.next();
                Geometry contourGeom = (Geometry)contour.getDefaultGeometry();
                if (!lineBuffer.intersects(contourGeom)) continue;
                Geometry intersection = lineBuffer.intersection(contourGeom);
                Coordinate[] coordinates = intersection.getCoordinates();
                Coordinate first = coordinates[0];
                double azimuth = GeometryUtilities.azimuth(first, second = coordinates[1]);
                double azimuthFrom90 = azimuth - 90.0;
                if (azimuthFrom90 < 0.0) {
                    azimuthFrom90 = 360.0 + azimuthFrom90;
                }
                double elevation = ((Number)contour.getAttribute(this.fElevation)).doubleValue();
                Point labelPoint = GeometryUtilities.gf().createPoint(first);
                SimpleFeatureBuilder builder = new SimpleFeatureBuilder(outType);
                Object[] values = new Object[]{labelPoint, elevation, azimuth, azimuthFrom90};
                builder.addAll(values);
                SimpleFeature pointFeature = builder.buildFeature(outType.getTypeName() + "." + count++);
                ((DefaultFeatureCollection)this.outPoints).add(pointFeature);
            }
        }
    }
}

