/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gears.modules.v.contoursextractor;

import java.util.ArrayList;
import java.util.List;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Documentation;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Out;
import oms3.annotations.Status;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.process.raster.ContourProcess;
import org.hortonmachine.gears.libs.exceptions.ModelsIllegalargumentException;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.gears.utils.features.FeatureUtilities;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

@Description(value="Module that extracts contour lines from a raster.")
@Documentation(value="OmsContourExtractor.html")
@Author(name="Andrea Antonello", contact="http://www.hydrologis.com")
@Keywords(value="Raster, Vector")
@Label(value="Vector Processing")
@Name(value="contourextract")
@Status(value=5)
@License(value="General Public License Version 3 (GPLv3)")
public class OmsContourExtractor
extends HMModel {
    @Description(value="The raster on which to calculate the contours.")
    @In
    public GridCoverage2D inCoverage;
    @Description(value="The minimum value for the contours.")
    @In
    public Double pMin;
    @Description(value="The maximum value for the contours.")
    @In
    public Double pMax;
    @Description(value="The contours interval.")
    @In
    public Double pInterval;
    @Description(value="The generated contour lines vector.")
    @Out
    public SimpleFeatureCollection outGeodata = null;
    public static final String OMSCONTOUREXTRACTOR_DESCRIPTION = "Module that extracts contour lines from a raster.";
    public static final String OMSCONTOUREXTRACTOR_DOCUMENTATION = "OmsContourExtractor.html";
    public static final String OMSCONTOUREXTRACTOR_KEYWORDS = "Raster, Vector";
    public static final String OMSCONTOUREXTRACTOR_LABEL = "Vector Processing";
    public static final String OMSCONTOUREXTRACTOR_NAME = "contourextract";
    public static final int OMSCONTOUREXTRACTOR_STATUS = 5;
    public static final String OMSCONTOUREXTRACTOR_LICENSE = "General Public License Version 3 (GPLv3)";
    public static final String OMSCONTOUREXTRACTOR_AUTHORNAMES = "Andrea Antonello";
    public static final String OMSCONTOUREXTRACTOR_AUTHORCONTACTS = "http://www.hydrologis.com";
    public static final String OMSCONTOUREXTRACTOR_IN_COVERAGE_DESCRIPTION = "The raster on which to calculate the contours.";
    public static final String OMSCONTOUREXTRACTOR_P_MIN_DESCRIPTION = "The minimum value for the contours.";
    public static final String OMSCONTOUREXTRACTOR_P_MAX_DESCRIPTION = "The maximum value for the contours.";
    public static final String OMSCONTOUREXTRACTOR_P_INTERVAL_DESCRIPTION = "The contours interval.";
    public static final String OMSCONTOUREXTRACTOR_OUT_GEODATA_DESCRIPTION = "The generated contour lines vector.";

    @Execute
    public void process() throws Exception {
        if (!this.concatOr(this.outGeodata == null, this.doReset)) {
            return;
        }
        this.checkNull(this.inCoverage, this.pMin, this.pMax, this.pInterval);
        if (this.pMin > this.pMax) {
            throw new ModelsIllegalargumentException("Min has to be bigger than Max.", this, this.pm);
        }
        ArrayList<Double> contourIntervals = new ArrayList<Double>();
        this.pm.message("Adding levels:");
        for (double level = this.pMin.doubleValue(); level <= this.pMax; level += this.pInterval.doubleValue()) {
            contourIntervals.add(level);
            this.pm.message("-> " + level);
        }
        double[] levels = new double[contourIntervals.size()];
        for (int i = 0; i < levels.length; ++i) {
            levels[i] = (Double)contourIntervals.get(i);
        }
        this.pm.beginTask("Extracting contours...", -1);
        ContourProcess contourProcess = new ContourProcess();
        SimpleFeatureCollection contoursFC = contourProcess.execute(this.inCoverage, Integer.valueOf(0), levels, null, null, null, null, null);
        this.outGeodata = new DefaultFeatureCollection();
        List<Geometry> contours = FeatureUtilities.featureCollectionToGeometriesList(contoursFC, true, "value");
        for (Geometry geom : contours) {
            LineString lineString = (LineString)geom;
            Object userData = lineString.getUserData();
            double elev = -1.0;
            if (userData instanceof Double) {
                elev = (Double)userData;
                lineString.setUserData(null);
            }
            SimpleFeatureBuilder builder = new SimpleFeatureBuilder((SimpleFeatureType)contoursFC.getSchema());
            Object[] values = new Object[]{lineString, elev};
            builder.addAll(values);
            SimpleFeature feature = builder.buildFeature(null);
            ((DefaultFeatureCollection)this.outGeodata).add(feature);
        }
    }
}

