/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gears.modules.v.intersections;

import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.hortonmachine.gears.utils.math.NumericsUtilities;
import org.locationtech.jts.geom.Geometry;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

public class FeatureElevationComparer
implements Comparable<FeatureElevationComparer> {
    private SimpleFeature feature;
    private double elevation;
    private Geometry geometry;
    private Geometry bufferPolygon;
    private boolean isDirty = false;
    private boolean isSnapped = false;
    private final double lengthThreshold;
    private boolean toRemove = false;
    private final double buffer;

    public FeatureElevationComparer(SimpleFeature feature, String field, double buffer, double lengthThreshold) {
        this.feature = feature;
        this.buffer = buffer;
        this.lengthThreshold = lengthThreshold;
        this.elevation = ((Number)feature.getAttribute(field)).doubleValue();
        this.geometry = (Geometry)feature.getDefaultGeometry();
        if (buffer > 0.0) {
            try {
                this.bufferPolygon = this.geometry.buffer(buffer);
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    System.out.println("TRYING WITH WIDER BUFFER: *2");
                    this.bufferPolygon = this.geometry.buffer(buffer * 2.0);
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                    System.out.println("TRYING WITH WIDER BUFFER: *4");
                    this.bufferPolygon = this.geometry.buffer(buffer * 4.0);
                }
            }
        }
    }

    public SimpleFeature getFeature() {
        return this.feature;
    }

    public Geometry getGeometry() {
        return this.geometry;
    }

    public double getElevation() {
        return this.elevation;
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    public void setDirty(boolean isDirty) {
        this.isDirty = isDirty;
    }

    public Geometry getBufferPolygon() {
        return this.bufferPolygon;
    }

    public void setBufferPolygon(Geometry bufferPolygon) {
        this.bufferPolygon = bufferPolygon;
    }

    public boolean isSnapped() {
        return this.isSnapped;
    }

    public void setSnapped(boolean isSnapped) {
        this.isSnapped = isSnapped;
    }

    public boolean toRemove() {
        return this.toRemove;
    }

    public void substituteGeometry(Geometry newGeometry) {
        if (this.toRemove) {
            return;
        }
        if (newGeometry.getLength() < this.lengthThreshold) {
            this.feature = null;
            this.geometry = null;
            this.toRemove = true;
            return;
        }
        Object[] attributes = this.feature.getAttributes().toArray();
        Object[] newAttributes = new Object[attributes.length];
        System.arraycopy(attributes, 0, newAttributes, 0, attributes.length);
        newAttributes[0] = newGeometry;
        SimpleFeatureType featureType = this.feature.getFeatureType();
        SimpleFeatureBuilder builder = new SimpleFeatureBuilder(featureType);
        builder.addAll(newAttributes);
        this.feature = builder.buildFeature(this.feature.getID());
        this.geometry = newGeometry;
        this.bufferPolygon = this.geometry.buffer(this.buffer);
    }

    @Override
    public int compareTo(FeatureElevationComparer o) {
        if (this.elevation < o.getElevation()) {
            return 1;
        }
        if (this.elevation > o.getElevation()) {
            return -1;
        }
        return 0;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this.elevation);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (obj instanceof FeatureElevationComparer) {
            FeatureElevationComparer o = (FeatureElevationComparer)obj;
            return NumericsUtilities.dEq(this.elevation, o.getElevation());
        }
        return false;
    }
}

