/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gears.modules.v.intersections;

import java.util.List;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Out;
import oms3.annotations.Status;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.hortonmachine.gears.libs.exceptions.ModelsIllegalargumentException;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.gears.utils.features.FeatureUtilities;
import org.hortonmachine.gears.utils.geometry.EGeometryType;
import org.hortonmachine.gears.utils.math.NumericsUtilities;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.prep.PreparedGeometry;
import org.locationtech.jts.geom.prep.PreparedGeometryFactory;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

@Description(value="Finds intersection geometries in feature collections")
@Author(name="Andrea Antonello", contact="www.hydrologis.com")
@Keywords(value="Vector")
@Label(value="Vector Processing")
@Name(value="intersectionfinder")
@Status(value=10)
@License(value="http://www.gnu.org/licenses/gpl-3.0.html")
public class OmsIntersectionFinder
extends HMModel {
    @Description(value="The map to test for intersections.")
    @In
    public SimpleFeatureCollection inMap = null;
    @Description(value="The intersections points map.")
    @Out
    public SimpleFeatureCollection outPointsMap = null;
    @Description(value="The intersections lines map.")
    @Out
    public SimpleFeatureCollection outLinesMap = null;

    @Execute
    public void process() throws Exception {
        if (!this.concatOr(this.outPointsMap == null && this.outLinesMap == null, this.doReset)) {
            return;
        }
        this.outPointsMap = new DefaultFeatureCollection();
        this.outLinesMap = new DefaultFeatureCollection();
        EGeometryType geometryType = EGeometryType.forGeometryType(((SimpleFeatureType)this.inMap.getSchema()).getGeometryDescriptor().getType());
        switch (geometryType) {
            case LINESTRING: 
            case MULTILINESTRING: {
                this.intersectLines();
                break;
            }
            case POLYGON: 
            case MULTIPOLYGON: {
                throw new ModelsIllegalargumentException("The module doesn't work for polygons yet.", this, this.pm);
            }
            default: {
                throw new ModelsIllegalargumentException("The module doesn't work for points.", this, this.pm);
            }
        }
    }

    private void intersectLines() {
        SimpleFeatureTypeBuilder b = new SimpleFeatureTypeBuilder();
        b.setName("pointintersections");
        b.setCRS(((SimpleFeatureType)this.inMap.getSchema()).getCoordinateReferenceSystem());
        b.add("the_geom", Point.class);
        SimpleFeatureType pointType = b.buildFeatureType();
        b = new SimpleFeatureTypeBuilder();
        b.setName("lineintersections");
        b.setCRS(((SimpleFeatureType)this.inMap.getSchema()).getCoordinateReferenceSystem());
        b.add("the_geom", LineString.class);
        SimpleFeatureType linesType = b.buildFeatureType();
        int size = this.inMap.size();
        List<Geometry> geometriesList = FeatureUtilities.featureCollectionToGeometriesList(this.inMap, true, null);
        int id = 0;
        this.pm.beginTask("Checking intersections...", size);
        for (int i = 0; i < size; ++i) {
            LineString line = (LineString)geometriesList.get(i);
            PreparedGeometry preparedLine = PreparedGeometryFactory.prepare((Geometry)line);
            for (int j = i + 1; j < size; ++j) {
                LineString otherLine = (LineString)geometriesList.get(j);
                if (!preparedLine.intersects((Geometry)otherLine)) continue;
                Geometry intersection = line.intersection((Geometry)otherLine);
                int numGeometries = intersection.getNumGeometries();
                if (numGeometries < 3) {
                    Point start1 = line.getStartPoint();
                    Point end1 = line.getEndPoint();
                    Point start2 = otherLine.getStartPoint();
                    Point end2 = otherLine.getEndPoint();
                    if (numGeometries == 1 ? start1.distance((Geometry)end2) < NumericsUtilities.D_TOLERANCE || start1.distance((Geometry)start2) < NumericsUtilities.D_TOLERANCE || end1.distance((Geometry)start2) < NumericsUtilities.D_TOLERANCE || end1.distance((Geometry)end2) < NumericsUtilities.D_TOLERANCE : numGeometries == 2 && (start1.distance((Geometry)end2) < NumericsUtilities.D_TOLERANCE && start2.distance((Geometry)end1) < NumericsUtilities.D_TOLERANCE || start1.distance((Geometry)start2) < NumericsUtilities.D_TOLERANCE && end1.distance((Geometry)end2) < NumericsUtilities.D_TOLERANCE)) continue;
                }
                for (int k = 0; k < numGeometries; ++k) {
                    SimpleFeature feature;
                    Object[] values;
                    SimpleFeatureBuilder builder;
                    Geometry geometryN = intersection.getGeometryN(k);
                    if (geometryN instanceof Point) {
                        builder = new SimpleFeatureBuilder(pointType);
                        Point p = (Point)geometryN;
                        values = new Object[]{p};
                        builder.addAll(values);
                        feature = builder.buildFeature(pointType.getTypeName() + "." + id++);
                        ((DefaultFeatureCollection)this.outPointsMap).add(feature);
                        continue;
                    }
                    if (!(geometryN instanceof LineString)) continue;
                    builder = new SimpleFeatureBuilder(linesType);
                    LineString l = (LineString)geometryN;
                    values = new Object[]{l};
                    builder.addAll(values);
                    feature = builder.buildFeature(linesType.getTypeName() + "." + id++);
                    ((DefaultFeatureCollection)this.outLinesMap).add(feature);
                }
            }
            this.pm.worked(1);
        }
        this.pm.done();
    }
}

