/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gears.modules.v.marchingsquares;

import java.awt.geom.Point2D;
import java.awt.image.RenderedImage;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import javax.media.jai.iterator.RandomIter;
import javax.media.jai.iterator.RandomIterFactory;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Documentation;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Out;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.hortonmachine.gears.libs.modules.HMConstants;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.gears.utils.RegionMap;
import org.hortonmachine.gears.utils.coverage.CoverageUtilities;
import org.hortonmachine.gears.utils.geometry.GeometryUtilities;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Polygon;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.TransformException;

@Description(value="Module for raster to vector conversion")
@Documentation(value="")
@Author(name="Andrea Antonello, Daniele Andreis", contact="www.hydrologis.com")
@Keywords(value="Raster, Vector")
@Label(value="Vector Processing")
@Name(value="marchingsquaresvectorizer")
@Status(value=10)
@License(value="General Public License Version 3 (GPLv3)")
@UI(value="hide")
public class OmsMarchingSquaresVectorializer
extends HMModel {
    @Description(value="The coverage that has to be converted.")
    @In
    public GridCoverage2D inGeodata;
    @Description(value="The value to use to trace the polygons. If it is null then all the value of the raster are used")
    @In
    public Double pValue = -9999.0;
    @Description(value="The value to use as a name for the raster value in the Feature.")
    @In
    public String defaultFeatureField = "value";
    @Description(value="A threshold on cell number to filter away polygons with cells less than that.")
    @In
    public double pThres = 0.0;
    @Description(value="The extracted features.")
    @Out
    public SimpleFeatureCollection outGeodata = null;
    public List<java.awt.Polygon> awtGeometriesList;
    private RandomIter iter = null;
    private double xRes;
    private double yRes;
    private GridGeometry2D gridGeometry;
    private int height;
    private int width;
    private BitSet bitSet = null;
    private CoordinateReferenceSystem crs;

    @Execute
    public void process() throws Exception {
        java.awt.Polygon awtPolygon;
        Polygon polygon;
        double value;
        int col;
        int row;
        if (!this.concatOr(this.outGeodata == null, this.doReset)) {
            return;
        }
        if (this.iter == null) {
            RenderedImage inputRI = this.inGeodata.getRenderedImage();
            this.iter = RandomIterFactory.create((RenderedImage)inputRI, null);
            RegionMap regionMap = CoverageUtilities.getRegionParamsFromGridCoverage(this.inGeodata);
            this.height = ((Double)regionMap.get("ROWS")).intValue();
            this.width = ((Double)regionMap.get("COLS")).intValue();
            this.xRes = (Double)regionMap.get("XRES");
            this.yRes = (Double)regionMap.get("YRES");
            this.crs = this.inGeodata.getCoordinateReferenceSystem();
            this.bitSet = new BitSet(this.width * this.height);
            this.gridGeometry = this.inGeodata.getGridGeometry();
        }
        ArrayList<Polygon> geometriesList = new ArrayList<Polygon>();
        this.awtGeometriesList = new ArrayList<java.awt.Polygon>();
        this.pm.beginTask("Extracting vectors...", this.height);
        ArrayList<Double> valueRaster = new ArrayList<Double>();
        if (this.pValue != null) {
            valueRaster.add(0, this.pValue);
            for (row = 0; row < this.height; ++row) {
                for (col = 0; col < this.width; ++col) {
                    value = this.iter.getSampleDouble(col, row, 0);
                    if (HMConstants.isNovalue(value) || this.bitSet.get(row * this.width + col) || !(Math.abs(value - this.pValue) < 1.0E-7) || (polygon = this.identifyPerimeter(col, row, awtPolygon = new java.awt.Polygon())) == null) continue;
                    geometriesList.add(polygon);
                    this.awtGeometriesList.add(awtPolygon);
                }
                this.pm.worked(1);
            }
        } else {
            this.pValue = -9999.0;
            for (row = 0; row < this.height; ++row) {
                for (col = 0; col < this.width; ++col) {
                    value = this.iter.getSampleDouble(col, row, 0);
                    if (value == this.pValue) continue;
                    this.pValue = value;
                    if (HMConstants.isNovalue(value) || this.bitSet.get(row * this.width + col) || value != this.pValue || (polygon = this.identifyPerimeter(col, row, awtPolygon = new java.awt.Polygon())) == null) continue;
                    valueRaster.add(this.pValue);
                    geometriesList.add(polygon);
                    this.awtGeometriesList.add(awtPolygon);
                }
                this.pm.worked(1);
            }
        }
        this.pm.done();
        SimpleFeatureTypeBuilder b = new SimpleFeatureTypeBuilder();
        b.setName("raster2vector");
        b.setCRS(this.crs);
        b.add("the_geom", Polygon.class);
        b.add("cat", Integer.class);
        b.add(this.defaultFeatureField, Double.class);
        SimpleFeatureType type = b.buildFeatureType();
        this.outGeodata = new DefaultFeatureCollection();
        int index = 0;
        for (Polygon polygon2 : geometriesList) {
            Double tmpValue = (Double)valueRaster.get(index);
            SimpleFeatureBuilder builder = new SimpleFeatureBuilder(type);
            Object[] values = new Object[]{polygon2, index, tmpValue};
            builder.addAll(values);
            SimpleFeature feature = builder.buildFeature(type.getTypeName() + "." + index);
            ++index;
            ((DefaultFeatureCollection)this.outGeodata).add(feature);
        }
    }

    private Polygon identifyPerimeter(int initialX, int initialY, java.awt.Polygon awtPolygon) throws TransformException {
        if (initialX < 0 || initialX > this.width - 1 || initialY < 0 || initialY > this.height - 1) {
            throw new IllegalArgumentException("Coordinate outside the bounds.");
        }
        int initialValue = this.value(initialX, initialY);
        if (initialValue == 0) {
            throw new IllegalArgumentException(String.format("Supplied initial coordinates (%d, %d) do not lie on a perimeter.", initialX, initialY));
        }
        Point2D.Double worldPosition = new Point2D.Double(initialX, initialY);
        this.gridGeometry.getGridToCRS2D().transform((Point2D)worldPosition, (Point2D)worldPosition);
        if (initialValue == 15) {
            return null;
        }
        Coordinate startCoordinate = new Coordinate(((Point2D)worldPosition).getX() + this.xRes / 2.0, ((Point2D)worldPosition).getY() - this.yRes / 2.0);
        ArrayList<Coordinate> coordinateList = new ArrayList<Coordinate>(200);
        coordinateList.add(startCoordinate);
        double currentX = startCoordinate.x;
        double currentY = startCoordinate.y;
        int x = initialX;
        int y = initialY;
        awtPolygon.addPoint(x, y);
        boolean previousWentNorth = false;
        boolean previousWentEast = false;
        do {
            Coordinate direction = null;
            int dx = 0;
            int dy = 0;
            int v = this.value(x, y);
            switch (v) {
                case 1: {
                    dy = -1;
                    currentY += this.yRes;
                    previousWentNorth = true;
                    break;
                }
                case 2: {
                    dx = 1;
                    currentX += this.xRes;
                    previousWentEast = true;
                    break;
                }
                case 3: {
                    dx = 1;
                    currentX += this.xRes;
                    previousWentEast = true;
                    break;
                }
                case 4: {
                    dx = -1;
                    currentX -= this.xRes;
                    previousWentEast = false;
                    break;
                }
                case 5: {
                    dy = -1;
                    currentY += this.yRes;
                    previousWentNorth = true;
                    break;
                }
                case 6: {
                    if (!previousWentNorth) {
                        dx = -1;
                        currentX -= this.xRes;
                        previousWentEast = false;
                        break;
                    }
                    dx = 1;
                    currentX += this.xRes;
                    previousWentEast = true;
                    break;
                }
                case 7: {
                    dx = 1;
                    currentX += this.xRes;
                    previousWentEast = true;
                    break;
                }
                case 8: {
                    dy = 1;
                    currentY -= this.yRes;
                    previousWentNorth = false;
                    break;
                }
                case 9: {
                    if (previousWentEast) {
                        dy = -1;
                        currentY += this.yRes;
                        previousWentNorth = true;
                        break;
                    }
                    dy = 1;
                    currentY -= this.yRes;
                    previousWentNorth = false;
                    break;
                }
                case 10: {
                    dy = 1;
                    currentY -= this.yRes;
                    previousWentNorth = false;
                    break;
                }
                case 11: {
                    dy = 1;
                    currentY -= this.yRes;
                    previousWentNorth = false;
                    break;
                }
                case 12: {
                    dx = -1;
                    currentX -= this.xRes;
                    previousWentEast = false;
                    break;
                }
                case 13: {
                    dy = -1;
                    currentY += this.yRes;
                    previousWentNorth = true;
                    break;
                }
                case 14: {
                    dx = -1;
                    currentX -= this.xRes;
                    previousWentEast = false;
                    break;
                }
                default: {
                    throw new IllegalStateException("Illegat state: " + v);
                }
            }
            direction = new Coordinate(currentX, currentY);
            coordinateList.add(direction);
            awtPolygon.addPoint(x += dx, y += dy);
        } while (x != initialX || y != initialY);
        double polygonArea = GeometryUtilities.getPolygonArea(awtPolygon.xpoints, awtPolygon.ypoints, coordinateList.size() - 1);
        if (polygonArea < this.pThres) {
            return null;
        }
        GeometryFactory gf = GeometryUtilities.gf();
        coordinateList.add(startCoordinate);
        Coordinate[] coordinateArray = coordinateList.toArray(new Coordinate[coordinateList.size()]);
        LinearRing linearRing = gf.createLinearRing(coordinateArray);
        Polygon polygon = gf.createPolygon(linearRing, null);
        return polygon;
    }

    private int value(int x, int y) {
        int sum = 0;
        if (this.isSet(x, y)) {
            sum |= 1;
        }
        if (this.isSet(x + 1, y)) {
            sum |= 2;
        }
        if (this.isSet(x, y + 1)) {
            sum |= 4;
        }
        if (this.isSet(x + 1, y + 1)) {
            sum |= 8;
        }
        if (sum == 0) {
            System.out.println(x + "/" + y);
        }
        this.bitSet.set(y * this.width + x);
        return sum;
    }

    private boolean isSet(int x, int y) {
        boolean isOutsideGrid;
        boolean bl = isOutsideGrid = x < 0 || x >= this.width || y < 0 || y >= this.height;
        if (isOutsideGrid) {
            return false;
        }
        double value = this.iter.getSampleDouble(x, y, 0);
        if (HMConstants.isNovalue(value)) {
            return false;
        }
        return value == this.pValue;
    }
}

