/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gears.modules.v.rastercattofeatureattribute;

import java.awt.image.RenderedImage;
import javax.media.jai.iterator.RandomIter;
import javax.media.jai.iterator.RandomIterFactory;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Documentation;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Out;
import oms3.annotations.Status;
import org.geotools.coverage.grid.GridCoordinates2D;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.geometry.DirectPosition2D;
import org.geotools.geometry.Envelope2D;
import org.hortonmachine.gears.libs.exceptions.ModelsIllegalargumentException;
import org.hortonmachine.gears.libs.modules.HMConstants;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.gears.modules.r.scanline.OmsScanLineRasterizer;
import org.hortonmachine.gears.modules.r.summary.OmsRasterSummary;
import org.hortonmachine.gears.utils.features.FeatureExtender;
import org.hortonmachine.gears.utils.features.FeatureUtilities;
import org.hortonmachine.gears.utils.geometry.EGeometryType;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.geometry.DirectPosition;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.TransformException;

@Description(value="Module that extracts raster categories and adds them to a feature collection.")
@Documentation(value="OmsRasterCatToFeatureAttribute.html")
@Author(name="Andrea Antonello", contact="http://www.hydrologis.com")
@Keywords(value="Raster, Vector")
@Label(value="Vector Processing")
@Name(value="rat2featureattr")
@Status(value=40)
@License(value="General Public License Version 3 (GPLv3)")
public class OmsRasterCatToFeatureAttribute
extends HMModel {
    @Description(value="The raster on which to map the vector features.")
    @In
    public GridCoverage2D inRaster;
    @Description(value="The vector to use for the geometric mapping.")
    @In
    public SimpleFeatureCollection inVector = null;
    @Description(value="The name for the new field to create (if existing, the field is populated).")
    @In
    public String fNew = "new";
    @Description(value="The position of the coordinate to take in the case of multi geometries.")
    @In
    public String pPos = "middle";
    @Description(value="The extended vector.")
    @Out
    public SimpleFeatureCollection outVector = null;
    public static final String OMSRASTERCATTOFEATUREATTRIBUTE_DESCRIPTION = "Module that extracts raster categories and adds them to a feature collection.";
    public static final String OMSRASTERCATTOFEATUREATTRIBUTE_DOCUMENTATION = "OmsRasterCatToFeatureAttribute.html";
    public static final String OMSRASTERCATTOFEATUREATTRIBUTE_KEYWORDS = "Raster, Vector";
    public static final String OMSRASTERCATTOFEATUREATTRIBUTE_LABEL = "Vector Processing";
    public static final String OMSRASTERCATTOFEATUREATTRIBUTE_NAME = "rat2featureattr";
    public static final int OMSRASTERCATTOFEATUREATTRIBUTE_STATUS = 40;
    public static final String OMSRASTERCATTOFEATUREATTRIBUTE_LICENSE = "General Public License Version 3 (GPLv3)";
    public static final String OMSRASTERCATTOFEATUREATTRIBUTE_AUTHORNAMES = "Andrea Antonello";
    public static final String OMSRASTERCATTOFEATUREATTRIBUTE_AUTHORCONTACTS = "http://www.hydrologis.com";
    public static final String OMSRASTERCATTOFEATUREATTRIBUTE_IN_RASTER_DESCRIPTION = "The raster on which to map the vector features.";
    public static final String OMSRASTERCATTOFEATUREATTRIBUTE_IN_VECTOR_DESCRIPTION = "The vector to use for the geometric mapping.";
    public static final String OMSRASTERCATTOFEATUREATTRIBUTE_F_NEW_DESCRIPTION = "The name for the new field to create (if existing, the field is populated).";
    public static final String OMSRASTERCATTOFEATUREATTRIBUTE_P_POS_DESCRIPTION = "The position of the coordinate to take in the case of multi geometries.";
    public static final String OMSRASTERCATTOFEATUREATTRIBUTE_OUT_VECTOR_DESCRIPTION = "The extended vector.";
    private static final String MIDDLE = "middle";
    private static final String START = "start";
    private static final String END = "end";
    private RandomIter inIter = null;
    private GridGeometry2D gridGeometry;
    private CoordinateReferenceSystem crs;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Execute
    public void process() throws Exception {
        RenderedImage inputRI = this.inRaster.getRenderedImage();
        try {
            this.inIter = RandomIterFactory.create((RenderedImage)inputRI, null);
            this.gridGeometry = this.inRaster.getGridGeometry();
            SimpleFeatureType featureType = (SimpleFeatureType)this.inVector.getSchema();
            this.crs = ((SimpleFeatureType)this.inVector.getSchema()).getCoordinateReferenceSystem();
            FeatureExtender fExt = null;
            Envelope2D inCoverageEnvelope = this.inRaster.getEnvelope2D();
            this.outVector = new DefaultFeatureCollection();
            SimpleFeatureIterator featureIterator = this.inVector.features();
            int all = this.inVector.size();
            this.pm.beginTask("Extracting raster information...", all);
            String setFieldName = FeatureUtilities.findAttributeName(featureType, this.fNew);
            while (featureIterator.hasNext()) {
                SimpleFeature finalFeature;
                Coordinate c;
                SimpleFeature feature = (SimpleFeature)featureIterator.next();
                Geometry geometry = (Geometry)feature.getDefaultGeometry();
                double value = -1.0;
                Coordinate[] coordinates = geometry.getCoordinates();
                if (EGeometryType.isPoint(geometry)) {
                    c = coordinates[0];
                    if (!inCoverageEnvelope.contains(c.x, c.y)) continue;
                    value = this.getRasterValue(c);
                    if (fExt == null) {
                        fExt = new FeatureExtender(featureType, new String[]{this.fNew}, new Class[]{Double.class});
                    }
                    if (setFieldName == null) {
                        finalFeature = fExt.extendFeature(feature, new Object[]{value});
                    } else {
                        feature.setAttribute(setFieldName, (Object)value);
                        finalFeature = feature;
                    }
                    ((DefaultFeatureCollection)this.outVector).add(finalFeature);
                } else if (EGeometryType.isLine(geometry)) {
                    c = this.pPos.trim().equalsIgnoreCase(START) ? coordinates[0] : (this.pPos.trim().equalsIgnoreCase(END) ? coordinates[coordinates.length - 1] : coordinates[coordinates.length / 2]);
                    if (!inCoverageEnvelope.contains(c.x, c.y)) continue;
                    value = this.getRasterValue(c);
                    if (fExt == null) {
                        fExt = new FeatureExtender(featureType, new String[]{this.fNew}, new Class[]{Double.class});
                    }
                    if (setFieldName == null) {
                        finalFeature = fExt.extendFeature(feature, new Object[]{value});
                    } else {
                        feature.setAttribute(setFieldName, (Object)value);
                        finalFeature = feature;
                    }
                    ((DefaultFeatureCollection)this.outVector).add(finalFeature);
                } else if (EGeometryType.isPolygon(geometry)) {
                    if (fExt == null) {
                        String max = this.fNew + "_max";
                        String min = this.fNew + "_min";
                        String avg = this.fNew + "_avg";
                        String sum = this.fNew + "_sum";
                        fExt = new FeatureExtender(featureType, new String[]{min, max, avg, sum}, new Class[]{Double.class, Double.class, Double.class, Double.class});
                    }
                    SimpleFeature singleFeature = FeatureUtilities.toDummyFeature(geometry, this.crs);
                    DefaultFeatureCollection newCollection = new DefaultFeatureCollection();
                    newCollection.add(singleFeature);
                    OmsScanLineRasterizer raster = new OmsScanLineRasterizer();
                    raster.inVector = newCollection;
                    raster.inRaster = this.inRaster;
                    raster.pValue = 1.0;
                    raster.process();
                    GridCoverage2D rasterizedVector = raster.outRaster;
                    double[] minMaxAvgSum = OmsRasterSummary.getMinMaxAvgSum(rasterizedVector);
                    SimpleFeature extendedFeature = fExt.extendFeature(feature, new Object[]{minMaxAvgSum[0], minMaxAvgSum[1], minMaxAvgSum[2], minMaxAvgSum[3]});
                    ((DefaultFeatureCollection)this.outVector).add(extendedFeature);
                } else {
                    throw new ModelsIllegalargumentException("The Geometry type is not supported.", this, this.pm);
                }
                this.pm.worked(1);
            }
            featureIterator.close();
            this.pm.done();
        }
        finally {
            this.inIter.done();
        }
    }

    private double getRasterValue(Coordinate c) throws TransformException {
        GridCoordinates2D gridCoord = this.gridGeometry.worldToGrid((DirectPosition)new DirectPosition2D(c.x, c.y));
        double value = this.inIter.getSampleDouble(gridCoord.x, gridCoord.y, 0);
        if (HMConstants.isNovalue(value) || value >= 3.4028234663852886E38 || value <= -3.4028234663852886E38) {
            value = -9999.0;
        }
        return value;
    }
}

