/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gears.modules.v.smoothing;

import java.util.ArrayList;
import java.util.List;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Documentation;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Out;
import oms3.annotations.Status;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.DefaultFeatureCollection;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.gears.utils.features.FeatureGeometrySubstitutor;
import org.hortonmachine.gears.utils.features.FeatureUtilities;
import org.hortonmachine.gears.utils.geometry.GeometryUtilities;
import org.jaitools.jts.LineSmoother;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

@Description(value="The line smoother from the jaitools project.")
@Documentation(value="OmsLineSmootherJaitools.html")
@Author(name="Andrea Antonello", contact="http://www.hydrologis.com")
@Keywords(value="Smoothing, Vector")
@Label(value="Vector Processing")
@Name(value="linesmootherjai")
@Status(value=40)
@License(value="General Public License Version 3 (GPLv3)")
public class OmsLineSmootherJaitools
extends HMModel {
    @Description(value="The vector containing the lines to be smoothed.")
    @In
    public SimpleFeatureCollection inVector;
    @Description(value="A value between 0 and 1 (inclusive) specifying the tightness of fit of the smoothed boundary (0 is loose).")
    @In
    public double pAlpha = 0.0;
    @Description(value="The smoothed features.")
    @Out
    public SimpleFeatureCollection outVector;
    private GeometryFactory gF = GeometryUtilities.gf();

    @Execute
    public void process() throws Exception {
        if (!this.concatOr(this.outVector == null, this.doReset)) {
            return;
        }
        this.outVector = new DefaultFeatureCollection();
        this.pm.message("Collecting geometries...");
        List<SimpleFeature> linesList = FeatureUtilities.featureCollectionToList(this.inVector);
        int size = this.inVector.size();
        FeatureGeometrySubstitutor fGS = new FeatureGeometrySubstitutor((SimpleFeatureType)this.inVector.getSchema());
        this.pm.beginTask("Smoothing features...", size);
        LineSmoother smoother = new LineSmoother(this.gF);
        for (SimpleFeature line : linesList) {
            Geometry geometry = (Geometry)line.getDefaultGeometry();
            int numGeometries = geometry.getNumGeometries();
            ArrayList<LineString> smoothedList = new ArrayList<LineString>();
            for (int i = 0; i < numGeometries; ++i) {
                Geometry geometryN = geometry.getGeometryN(i);
                if (!(geometryN instanceof LineString)) continue;
                LineString lineString = (LineString)geometryN;
                LineString smoothed = smoother.smooth(lineString, this.pAlpha);
                smoothedList.add(smoothed);
            }
            if (smoothedList.size() != 0) {
                LineString[] lsArray = smoothedList.toArray(new LineString[smoothedList.size()]);
                MultiLineString multiLineString = this.gF.createMultiLineString(lsArray);
                SimpleFeature newFeature = fGS.substituteGeometry(line, (Geometry)multiLineString);
                ((DefaultFeatureCollection)this.outVector).add(newFeature);
            }
            this.pm.worked(1);
        }
        this.pm.done();
    }
}

