/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gears.modules.v.vectorclipper;

import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Documentation;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Out;
import oms3.annotations.Status;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.feature.DefaultFeatureCollection;
import org.hortonmachine.gears.libs.exceptions.ModelsIllegalargumentException;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.gears.utils.features.FeatureUtilities;
import org.hortonmachine.gears.utils.geometry.EGeometryType;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.prep.PreparedGeometry;
import org.locationtech.jts.geom.prep.PreparedGeometryFactory;
import org.locationtech.jts.index.strtree.STRtree;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

@Description(value="A vector clipping module.")
@Documentation(value="")
@Author(name="Andrea Antonello", contact="www.hydrologis.com")
@Keywords(value="JTS, Clip, Vector")
@Label(value="Vector Processing")
@Name(value="clipper")
@Status(value=5)
@License(value="http://www.gnu.org/licenses/gpl-3.0.html")
public class OmsVectorClipper
extends HMModel {
    @Description(value="The vector map to be clipped.")
    @In
    public SimpleFeatureCollection inMap = null;
    @Description(value="The clipping vector map.")
    @In
    public SimpleFeatureCollection inClipper = null;
    @Description(value="Max threads to use (default 1)")
    @In
    public int pMaxThreads = 1;
    @Description(value="The resulting vector map.")
    @Out
    public SimpleFeatureCollection outMap = null;

    @Execute
    public void process() throws Exception {
        this.checkNull(this.inMap, this.inClipper);
        if (!EGeometryType.isPolygon(((SimpleFeatureType)this.inClipper.getSchema()).getGeometryDescriptor())) {
            throw new ModelsIllegalargumentException("The clipping geometry needs to be polygon.", this, this.pm);
        }
        this.pm.beginTask("Indexing geometries...", -1);
        STRtree geomsTree = new STRtree(2000);
        SimpleFeatureIterator featuresToClip = this.inMap.features();
        while (featuresToClip.hasNext()) {
            SimpleFeature feature = (SimpleFeature)featuresToClip.next();
            Geometry geometry = (Geometry)feature.getDefaultGeometry();
            geomsTree.insert(geometry.getEnvelopeInternal(), (Object)feature);
        }
        this.pm.done();
        ExecutorService fixedThreadPool = Executors.newFixedThreadPool(this.pMaxThreads);
        final ConcurrentLinkedQueue newFeatures = new ConcurrentLinkedQueue();
        List<Geometry> clipperGeoms = FeatureUtilities.featureCollectionToGeometriesList(this.inClipper, false, null);
        int index = 1;
        int clipperCount = clipperGeoms.size();
        for (Geometry clipperGeom : clipperGeoms) {
            this.pm.message("Working on geometry " + index++ + " of " + clipperCount);
            final List result = geomsTree.query(clipperGeom.getEnvelopeInternal());
            int size = result.size();
            int splitSize = (int)Math.ceil((double)size / (double)this.pMaxThreads);
            final CountDownLatch latch = new CountDownLatch(this.pMaxThreads);
            this.pm.beginTask("Clipping...", this.pMaxThreads);
            int i = 0;
            while (i < size) {
                int endIndex = i + splitSize;
                if (endIndex > size) {
                    endIndex = size - 1;
                }
                final PreparedGeometry cGeom = PreparedGeometryFactory.prepare((Geometry)clipperGeom);
                final int start = i;
                final int end = endIndex;
                Runnable runner = new Runnable(){

                    @Override
                    public void run() {
                        try {
                            for (int j = start; j <= end; ++j) {
                                SimpleFeature feature = (SimpleFeature)result.get(j);
                                Geometry geometry = (Geometry)feature.getDefaultGeometry();
                                if (!cGeom.intersects(geometry)) continue;
                                Geometry intersectionGeom = cGeom.getGeometry().intersection(geometry);
                                feature.setDefaultGeometry((Object)intersectionGeom);
                                newFeatures.add(feature);
                            }
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                        latch.countDown();
                        OmsVectorClipper.this.pm.worked(1);
                    }
                };
                fixedThreadPool.execute(runner);
                i = i + splitSize + 1;
            }
            latch.await();
            this.pm.done();
        }
        try {
            fixedThreadPool.shutdown();
            fixedThreadPool.awaitTermination(30L, TimeUnit.DAYS);
            fixedThreadPool.shutdownNow();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.outMap = new DefaultFeatureCollection();
        ((DefaultFeatureCollection)this.outMap).addAll(newFeatures);
    }
}

