/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gears.modules.v.vectorconverter;

import java.io.File;
import java.io.FileInputStream;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Documentation;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Out;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.geotools.data.PrjFileReader;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.hortonmachine.gears.io.dxfdwg.libs.dxf.DxfFile;
import org.hortonmachine.gears.libs.exceptions.ModelsIllegalargumentException;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.gears.utils.CrsUtilities;
import org.hortonmachine.gears.utils.files.FileUtilities;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

@Description(value="Module to convert dxf files to geotools vecotors.")
@Documentation(value="OmsDxfConverter.html")
@Author(name="Andrea Antonello", contact="http://www.hydrologis.com")
@Keywords(value="IO, OmsDwgConverter, Feature, Vector, Reading")
@Label(value="Vector Processing")
@Name(value="dxfimport")
@Status(value=40)
@License(value="General Public License Version 3 (GPLv3)")
public class OmsDxfConverter
extends HMModel {
    @Description(value="The dxf file.")
    @UI(value="infile_vector")
    @In
    public String file = null;
    @Description(value="The code defining the coordinate reference system, composed by authority and code number (ex. EPSG:4328). Applied in the case the file is missing.")
    @UI(value="crs")
    @In
    public String pCode;
    @Description(value="The output point vector.")
    @Out
    public SimpleFeatureCollection pointsVector = null;
    @Description(value="The output lines vector.")
    @Out
    public SimpleFeatureCollection lineVector = null;
    @Description(value="The output polygons vector.")
    @Out
    public SimpleFeatureCollection polygonVector = null;
    private CoordinateReferenceSystem crs;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Execute
    public void process() throws Exception {
        String nameWithoutExtention;
        if (!this.concatOr(this.pointsVector == null, this.lineVector == null, this.polygonVector == null, this.doReset)) {
            return;
        }
        File dxfFile = new File(this.file);
        File parentFolder = dxfFile.getParentFile();
        File prjFile = new File(parentFolder, (nameWithoutExtention = FileUtilities.getNameWithoutExtention(dxfFile)) + ".prj");
        if (prjFile.exists()) {
            try (FileInputStream instream = null;){
                instream = new FileInputStream(prjFile);
                FileChannel channel = instream.getChannel();
                PrjFileReader reader = new PrjFileReader((ReadableByteChannel)channel);
                this.crs = reader.getCoordinateReferenceSystem();
            }
        }
        if (this.crs == null) {
            if (this.pCode != null) {
                this.crs = CrsUtilities.getCrsFromEpsg(this.pCode, null);
            } else {
                throw new ModelsIllegalargumentException("Please specify the CRS for the imported DXF file.", this, this.pm);
            }
        }
        DxfFile dxf = DxfFile.createFromFile(dxfFile, this.crs);
        this.pointsVector = dxf.getPoints();
        this.lineVector = dxf.getLines();
        this.polygonVector = dxf.getPolygons();
    }
}

