/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gears.modules.v.vectorfilter;

import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Documentation;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Out;
import oms3.annotations.Status;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.feature.DefaultFeatureCollection;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.gears.utils.features.FilterUtilities;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.filter.Filter;

@Description(value="Module that creates a subset of a vector based on a filtered vector.")
@Documentation(value="OmsVectorFilter.html")
@Author(name="Andrea Antonello", contact="http://www.hydrologis.com")
@Keywords(value="Filter, Vector, OmsVectorReshaper")
@Label(value="Vector Processing")
@Name(value="vfilter")
@Status(value=40)
@License(value="General Public License Version 3 (GPLv3)")
public class OmsVectorFilter
extends HMModel {
    @Description(value="The vector to filter.")
    @In
    public SimpleFeatureCollection inVector;
    @Description(value="The ECQL filter function.")
    @In
    public String pCql = null;
    @Description(value="The filtered vector.")
    @Out
    public SimpleFeatureCollection outVector;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Execute
    public void process() throws Exception {
        if (!this.concatOr(this.outVector == null, this.doReset)) {
            return;
        }
        this.checkNull(this.inVector, this.pCql);
        Filter cqlFilter = FilterUtilities.getCQLFilter(this.pCql);
        SimpleFeatureCollection subCollection = this.inVector.subCollection(cqlFilter);
        this.outVector = new DefaultFeatureCollection();
        try (SimpleFeatureIterator iterator = subCollection.features();){
            while (iterator.hasNext()) {
                SimpleFeature feature = (SimpleFeature)iterator.next();
                ((DefaultFeatureCollection)this.outVector).add(feature);
            }
        }
    }
}

