/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gears.modules.v.vectorize;

import java.awt.image.RenderedImage;
import javax.media.jai.iterator.RandomIter;
import javax.media.jai.iterator.RandomIterFactory;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Documentation;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Out;
import oms3.annotations.Status;
import org.geotools.coverage.grid.GridCoordinates2D;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.hortonmachine.gears.libs.modules.HMConstants;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.gears.utils.RegionMap;
import org.hortonmachine.gears.utils.coverage.CoverageUtilities;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.geometry.DirectPosition;

@Description(value="Module that creates a points vector layer from raster values.")
@Documentation(value="")
@Author(name="Andrea Antonello", contact="http://www.hydrologis.com")
@Keywords(value="Raster, Vector")
@Label(value="Vector Processing")
@Name(value="pvectorizer")
@Status(value=5)
@License(value="General Public License Version 3 (GPLv3)")
public class OmsPointsVectorizer
extends HMModel {
    @Description(value="The raster that has to be converted.")
    @In
    public GridCoverage2D inRaster;
    @Description(value="The field name to use as a name for the raster value in the vector.")
    @In
    public String fDefault = "value";
    @Description(value="The extracted vector.")
    @Out
    public SimpleFeatureCollection outVector = null;

    @Execute
    public void process() throws Exception {
        if (!this.concatOr(this.outVector == null, this.doReset)) {
            return;
        }
        this.checkNull(this.inRaster);
        GridGeometry2D gridGeometry = this.inRaster.getGridGeometry();
        RegionMap regionMap = CoverageUtilities.getRegionParamsFromGridCoverage(this.inRaster);
        int cols = regionMap.getCols();
        int rows = regionMap.getRows();
        SimpleFeatureTypeBuilder b = new SimpleFeatureTypeBuilder();
        b.setName("pointtype");
        b.setCRS(this.inRaster.getCoordinateReferenceSystem());
        b.add("the_geom", Point.class);
        b.add(this.fDefault, Double.class);
        SimpleFeatureType type = b.buildFeatureType();
        GeometryFactory gF = new GeometryFactory();
        this.outVector = new DefaultFeatureCollection();
        RandomIter rasterIter = RandomIterFactory.create((RenderedImage)this.inRaster.getRenderedImage(), null);
        this.pm.beginTask("Extracting points...", rows);
        for (int r = 0; r < rows; ++r) {
            for (int c = 0; c < cols; ++c) {
                double value = rasterIter.getSampleDouble(c, r, 0);
                if (HMConstants.isNovalue(value)) continue;
                DirectPosition world = gridGeometry.gridToWorld(new GridCoordinates2D(c, r));
                double[] coordinate = world.getCoordinate();
                Coordinate coord = new Coordinate(coordinate[0], coordinate[1]);
                Point point = gF.createPoint(coord);
                SimpleFeatureBuilder builder = new SimpleFeatureBuilder(type);
                Object[] values = new Object[]{point, value};
                builder.addAll(values);
                SimpleFeature feature = builder.buildFeature(null);
                ((DefaultFeatureCollection)this.outVector).add(feature);
            }
        }
    }
}

