/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gears.modules.v.vectormerger;

import java.util.List;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Documentation;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Out;
import oms3.annotations.Status;
import org.geotools.data.DataUtilities;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.feature.DefaultFeatureCollection;
import org.hortonmachine.gears.libs.exceptions.ModelsIllegalargumentException;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.gears.utils.features.FeatureExtender;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

@Description(value="Module for merging vecotrs into one single.")
@Documentation(value="OmsVectorMerger.html")
@Author(name="Andrea Antonello", contact="http://www.hydrologis.com")
@Keywords(value="IO, Feature, Vector, Merge")
@Label(value="Vector Processing")
@Name(value="vmerge")
@Status(value=40)
@License(value="General Public License Version 3 (GPLv3)")
public class OmsVectorMerger
extends HMModel {
    @Description(value="The input vectors to be merged.")
    @In
    public List<SimpleFeatureCollection> inVectors;
    @Description(value="The output vector.")
    @Out
    public SimpleFeatureCollection outVector;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Execute
    public void process() throws Exception {
        this.checkNull(this.inVectors);
        SimpleFeatureType firstType = null;
        FeatureExtender fEx = null;
        this.pm.beginTask("Merging features...", this.inVectors.size());
        try {
            this.outVector = new DefaultFeatureCollection();
            for (SimpleFeatureCollection featureCollection : this.inVectors) {
                if (firstType == null) {
                    firstType = (SimpleFeatureType)featureCollection.getSchema();
                    fEx = new FeatureExtender(firstType, new String[0], new Class[0]);
                } else {
                    SimpleFeatureType schema = (SimpleFeatureType)featureCollection.getSchema();
                    int compare = DataUtilities.compare((SimpleFeatureType)firstType, (SimpleFeatureType)schema);
                    if (compare != 0) {
                        throw new ModelsIllegalargumentException("Merging is done only on same feature types.", this, this.pm);
                    }
                }
                SimpleFeatureIterator featureIterator = featureCollection.features();
                while (featureIterator.hasNext()) {
                    SimpleFeature f = (SimpleFeature)featureIterator.next();
                    SimpleFeature extendFeature = fEx.extendFeature(f, new Object[0]);
                    ((DefaultFeatureCollection)this.outVector).add(extendFeature);
                }
                this.pm.worked(1);
            }
        }
        finally {
            this.pm.done();
        }
    }
}

