/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gears.modules.v.vectoroperations;

import java.util.ArrayList;
import java.util.List;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Documentation;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Out;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.DefaultFeatureCollection;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.gears.utils.features.FeatureGeometrySubstitutor;
import org.hortonmachine.gears.utils.features.FeatureUtilities;
import org.hortonmachine.gears.utils.geometry.GeometryUtilities;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.operation.buffer.BufferOp;
import org.locationtech.jts.operation.buffer.BufferParameters;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

@Description(value="A module that performs a buffer operation on a vector layer.")
@Documentation(value="")
@Author(name="Andrea Antonello", contact="www.hydrologis.com")
@Keywords(value="JTS, OmsBuffer")
@Label(value="Vector Processing")
@Name(value="vbuffer")
@Status(value=5)
@License(value="http://www.gnu.org/licenses/gpl-3.0.html")
public class OmsBuffer
extends HMModel {
    @Description(value="The input vector map.")
    @In
    public SimpleFeatureCollection inMap = null;
    @Description(value="The buffer distance.")
    @In
    public double pBuffer = 10.0;
    @Description(value="The field to use as buffer distance.")
    @In
    public String pBufferField;
    @Description(value="Flag to toggle singlesided buffer.")
    @In
    public boolean doSinglesided = false;
    @Description(value="The join style to use.")
    @UI(value="combo:round,mitre,bevel")
    @In
    public String pJoinstyle = "round";
    @Description(value="The cap style to use.")
    @UI(value="combo:round,flat,square")
    @In
    public String pCapstyle = "round";
    @Description(value="The buffered vector map.")
    @Out
    public SimpleFeatureCollection outMap = null;
    public static final String OMSBUFFER_DESCRIPTION = "A module that performs a buffer operation on a vector layer.";
    public static final String OMSBUFFER_DOCUMENTATION = "";
    public static final String OMSBUFFER_KEYWORDS = "JTS, OmsBuffer";
    public static final String OMSBUFFER_LABEL = "Vector Processing";
    public static final String OMSBUFFER_NAME = "vbuffer";
    public static final int OMSBUFFER_STATUS = 5;
    public static final String OMSBUFFER_LICENSE = "http://www.gnu.org/licenses/gpl-3.0.html";
    public static final String OMSBUFFER_AUTHORNAMES = "Andrea Antonello";
    public static final String OMSBUFFER_AUTHORCONTACTS = "www.hydrologis.com";
    public static final String OMSBUFFER_IN_MAP_DESCRIPTION = "The input vector map.";
    public static final String OMSBUFFER_P_BUFFER_DESCRIPTION = "The buffer distance.";
    public static final String OMSBUFFER_P_BUFFERFIELD_DESCRIPTION = "The field to use as buffer distance.";
    public static final String OMSBUFFER_DO_SINGLE_SIDED_DESCRIPTION = "Flag to toggle singlesided buffer.";
    public static final String OMSBUFFER_P_JOIN_STYLE_DESCRIPTION = "The join style to use.";
    public static final String OMSBUFFER_P_CAP_STYLE_DESCRIPTION = "The cap style to use.";
    public static final String OMSBUFFER_OUT_MAP_DESCRIPTION = "The buffered vector map.";
    private double mitreLimit = 5.0;
    private int quadrantSegments = 8;

    @Execute
    public void process() throws Exception {
        this.checkNull(this.inMap);
        int joinStyle = this.pJoinstyle.equals("mitre") ? 2 : (this.pJoinstyle.equals("bevel") ? 3 : 1);
        int endCapStyle = this.pCapstyle.equals("flat") ? 2 : (this.pCapstyle.equals("square") ? 3 : 1);
        FeatureGeometrySubstitutor fgs = new FeatureGeometrySubstitutor((SimpleFeatureType)this.inMap.getSchema(), MultiPolygon.class);
        DefaultFeatureCollection outMaptmp = new DefaultFeatureCollection("new", fgs.getNewFeatureType());
        GeometryFactory gf = GeometryUtilities.gf();
        List<SimpleFeature> featuresList = FeatureUtilities.featureCollectionToList(this.inMap);
        this.pm.beginTask("Buffering geometries...", featuresList.size());
        for (SimpleFeature feature : featuresList) {
            Object bFieldObj;
            Geometry geometry = (Geometry)feature.getDefaultGeometry();
            double buf = this.pBuffer;
            if (this.pBufferField != null && (bFieldObj = feature.getAttribute(this.pBufferField)) instanceof Number) {
                buf = ((Number)bFieldObj).doubleValue();
            }
            BufferParameters bP = new BufferParameters(this.quadrantSegments, endCapStyle, joinStyle, this.mitreLimit);
            Geometry bufferedGeom = BufferOp.bufferOp((Geometry)geometry, (double)buf, (BufferParameters)bP);
            ArrayList<Polygon> polygons = new ArrayList<Polygon>(bufferedGeom.getNumGeometries());
            for (int i = 0; i < bufferedGeom.getNumGeometries(); ++i) {
                Geometry geometryN = bufferedGeom.getGeometryN(i);
                if (geometryN instanceof Polygon) {
                    polygons.add((Polygon)geometryN);
                    continue;
                }
                this.pm.errorMessage("Ignored non polygonal geometry in: " + geometryN.toText());
            }
            MultiPolygon multiPolygon = gf.createMultiPolygon(polygons.toArray(GeometryUtilities.TYPE_POLYGON));
            SimpleFeature newFeature = fgs.substituteGeometry(feature, (Geometry)multiPolygon);
            outMaptmp.add(newFeature);
            this.pm.worked(1);
        }
        this.pm.done();
        this.outMap = outMaptmp;
    }
}

