/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gears.modules.v.vectoroverlayoperators;

import java.util.List;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Out;
import oms3.annotations.Status;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.DefaultFeatureCollection;
import org.hortonmachine.gears.libs.exceptions.ModelsIllegalargumentException;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.gears.utils.features.FeatureGeometrySubstitutor;
import org.hortonmachine.gears.utils.features.FeatureUtilities;
import org.hortonmachine.gears.utils.geometry.EGeometryType;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.prep.PreparedGeometry;
import org.locationtech.jts.geom.prep.PreparedGeometryFactory;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

@Description(value="Vector layer intersector with maintaining of attributes.")
@Author(name="Andrea Antonello, Silvia Franceschi", contact="www.hydrologis.com")
@Keywords(value="vector, intersect, attributes")
@Label(value="Vector Processing")
@Name(value="_vectorintersctor")
@Status(value=10)
@License(value="http://www.gnu.org/licenses/gpl-3.0.html")
public class OmsVectorIntersector
extends HMModel {
    @Description(value="The first vector map.")
    @In
    public SimpleFeatureCollection inMap1 = null;
    @Description(value="The second vector map.")
    @In
    public SimpleFeatureCollection inMap2 = null;
    @Description(value="If enabled attributes of map 1 are kept, else of map 2.")
    @In
    public boolean doKeepFirstAttributes = true;
    @Description(value="The resulting vector map.")
    @Out
    public SimpleFeatureCollection outMap = null;
    public static final String NAME = "vectorintersctor";
    public static final String DESCRIPTION = "Vector layer intersector with maintaining of attributes.";
    public static final String KEYWORDS = "vector, intersect, attributes";
    public static final String KEEP_FIRST_ATTRIBUTES = "If enabled attributes of map 1 are kept, else of map 2.";

    @Execute
    public void process() throws Exception {
        this.checkNull(this.inMap1, this.inMap2);
        this.outMap = new DefaultFeatureCollection();
        if (!this.doKeepFirstAttributes) {
            SimpleFeatureCollection inMapTmp = this.inMap1;
            this.inMap1 = this.inMap2;
            this.inMap2 = inMapTmp;
        }
        List<Geometry> geometries = FeatureUtilities.featureCollectionToGeometriesList(this.inMap2, false, null);
        GeometryCollection geometryCollection = new GeometryCollection(geometries.toArray(new Geometry[geometries.size()]), this.gf);
        Geometry intersectionGeometry = geometryCollection.buffer(0.0);
        PreparedGeometry preparedIntersectionGeometry = PreparedGeometryFactory.prepare((Geometry)intersectionGeometry);
        List<SimpleFeature> mainFeatures = FeatureUtilities.featureCollectionToList(this.inMap1);
        if (mainFeatures.size() == 0) {
            throw new ModelsIllegalargumentException("No features found in the layer.", this);
        }
        EGeometryType geometryType = EGeometryType.forGeometry((Geometry)mainFeatures.get(0).getDefaultGeometry());
        Class<?> multiClazz = geometryType.getMultiClazz();
        EGeometryType newGeometryType = EGeometryType.forClass(multiClazz);
        FeatureGeometrySubstitutor sub = new FeatureGeometrySubstitutor((SimpleFeatureType)this.inMap1.getSchema(), multiClazz);
        this.pm.beginTask("Performing intersection...", mainFeatures.size());
        for (SimpleFeature feature : mainFeatures) {
            Geometry geometry = (Geometry)feature.getDefaultGeometry();
            if (preparedIntersectionGeometry.intersects(geometry)) {
                Geometry intersection = geometry.intersection(intersectionGeometry);
                EGeometryType intersectionGeometryType = EGeometryType.forGeometry(intersection);
                if (intersectionGeometryType.isCompatibleWith(newGeometryType)) {
                    SimpleFeature newFeature = sub.substituteGeometry(feature, intersection);
                    ((DefaultFeatureCollection)this.outMap).add(newFeature);
                } else {
                    this.pm.errorMessage("Could not add intersection result geometry to layer due to incompatibility: " + intersection);
                }
            }
            this.pm.worked(1);
        }
        this.pm.done();
    }
}

