/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gears.modules.v.vectorreshaper;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Documentation;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Out;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.feature.SchemaException;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.filter.text.cql2.CQL;
import org.geotools.filter.text.cql2.CQLException;
import org.hortonmachine.gears.libs.exceptions.ModelsIllegalargumentException;
import org.hortonmachine.gears.libs.exceptions.ModelsRuntimeException;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.locationtech.jts.geom.Geometry;
import org.opengis.feature.Feature;
import org.opengis.feature.FeatureVisitor;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeType;
import org.opengis.feature.type.GeometryType;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.PropertyName;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

@Description(value="Module to reshape a vector.")
@Documentation(value="OmsVectorReshaper.html")
@Author(name="Andrea Antonello, Jody Garnett", contact="http://www.hydrologis.com")
@Keywords(value="Reshape, Vector, OmsVectorFilter")
@Label(value="Vector Processing")
@Name(value="reshape")
@Status(value=40)
@License(value="General Public License Version 3 (GPLv3)")
public class OmsVectorReshaper
extends HMModel {
    @Description(value="The vector to reshape.")
    @In
    public SimpleFeatureCollection inVector;
    @Description(value="The ECQL reshape function.")
    @UI(value="multiline5")
    @In
    public String pCql = null;
    @Description(value="The list of fields to remove, comma separated.")
    @In
    public String pRemove = null;
    @Description(value="The new reshaped vector.")
    @Out
    public SimpleFeatureCollection outVector;
    private SimpleFeature sample = null;
    static int count = 0;

    @Execute
    public void process() throws Exception {
        if (!this.concatOr(this.outVector == null, this.doReset)) {
            return;
        }
        this.checkNull(this.inVector, this.pCql);
        ArrayList<String> removeNames = new ArrayList<String>();
        if (this.pRemove != null) {
            String[] split;
            for (String string : split = this.pRemove.split(",")) {
                removeNames.add(string.trim());
            }
        }
        SimpleFeatureType originalFeatureType = (SimpleFeatureType)this.inVector.getSchema();
        List attributeDescriptors = originalFeatureType.getAttributeDescriptors();
        LinkedHashMap<String, String> functionMap = new LinkedHashMap<String, String>();
        for (String[] attributeDescriptor : attributeDescriptors) {
            String name = attributeDescriptor.getLocalName();
            if (removeNames.contains(name.trim())) continue;
            functionMap.put(name, name);
        }
        if (this.pCql != null && this.pCql.length() > 0) {
            String[] split = this.pCql.trim().split("\n");
            if (split != null && split.length > 0) {
                for (String line : split) {
                    int indexOfEquals = line.indexOf(61);
                    if (indexOfEquals != -1) {
                        String key = line.substring(0, indexOfEquals);
                        String value = line.substring(indexOfEquals + 1);
                        functionMap.put(key.trim(), value.trim());
                        continue;
                    }
                    this.pm.errorMessage("Ignoring expression: " + line);
                }
            }
        } else {
            throw new ModelsIllegalargumentException("No CQL function has been provided.", this, this.pm);
        }
        StringBuilder sB = new StringBuilder();
        Set entrySet = functionMap.entrySet();
        for (Map.Entry entry : entrySet) {
            sB.append("\n").append((String)entry.getKey()).append("=").append((String)entry.getValue());
        }
        String expressionString = sB.substring(1);
        this.sample = this.getSample();
        List<String> names = this.createNameList(expressionString);
        final List<Expression> expressions = this.createExpressionList(expressionString);
        SimpleFeatureType newFeatureType = this.createFeatureType(expressionString, originalFeatureType, names, expressions);
        this.outVector = new DefaultFeatureCollection();
        final SimpleFeatureBuilder build = new SimpleFeatureBuilder(newFeatureType);
        this.inVector.accepts(new FeatureVisitor(){

            public void visit(Feature rawFeature) {
                SimpleFeature feature = (SimpleFeature)rawFeature;
                for (int i = 0; i < expressions.size(); ++i) {
                    build.add(((Expression)expressions.get(i)).evaluate((Object)feature));
                }
                SimpleFeature created = build.buildFeature(feature.getID());
                ((DefaultFeatureCollection)OmsVectorReshaper.this.outVector).add(created);
            }
        }, null);
    }

    private SimpleFeature getSample() {
        try (SimpleFeatureIterator iterator = this.inVector.features();){
            if (!iterator.hasNext()) {
                throw new ModelsRuntimeException("Input featurecollection is empty.", this.getClass().getSimpleName());
            }
            SimpleFeature simpleFeature = (SimpleFeature)iterator.next();
            return simpleFeature;
        }
    }

    private SimpleFeatureType createFeatureType(String expressionString, SimpleFeatureType originalFeatureType, List<String> names, List<Expression> expressions) throws SchemaException {
        SimpleFeatureTypeBuilder build = new SimpleFeatureTypeBuilder();
        for (int i = 0; i < names.size(); ++i) {
            String name = names.get(i);
            Expression expression = expressions.get(i);
            Object value = expression.evaluate((Object)this.sample);
            Class<?> binding = null;
            if (value == null) {
                if (expression instanceof PropertyName) {
                    String path = ((PropertyName)expression).getPropertyName();
                    AttributeType attributeType = this.sample.getFeatureType().getType(path);
                    if (attributeType == null) {
                        throw new ModelsIllegalargumentException("Attribute type is null", this.getClass().getSimpleName(), this.pm);
                    }
                    binding = attributeType.getClass();
                }
            } else {
                binding = value.getClass();
            }
            if (binding == null) {
                throw new ModelsIllegalargumentException("Binding is null", this.getClass().getSimpleName(), this.pm);
            }
            if (Geometry.class.isAssignableFrom(binding)) {
                AttributeType originalAttributeType = originalFeatureType.getType(name);
                CoordinateReferenceSystem crs = originalAttributeType instanceof GeometryType ? ((GeometryType)originalAttributeType).getCoordinateReferenceSystem() : originalFeatureType.getCoordinateReferenceSystem();
                build.crs(crs);
                build.add(name, binding);
                continue;
            }
            build.add(name, binding);
        }
        build.setName(this.getNewTypeName(originalFeatureType.getTypeName()));
        return build.buildFeatureType();
    }

    private List<String> createNameList(String expressionString) {
        ArrayList<String> list = new ArrayList<String>();
        String definition = expressionString.replaceAll("\r", "\n").replaceAll("[\n\r][\n\r]", "\n");
        for (String line : definition.split("\n")) {
            int mark = line.indexOf("=");
            if (mark == -1) continue;
            String name = line.substring(0, mark).trim();
            if (list.contains(name)) {
                System.out.println("Name already existing");
                continue;
            }
            list.add(name);
        }
        return list;
    }

    private List<Expression> createExpressionList(String expressionString) {
        ArrayList<Expression> list = new ArrayList<Expression>();
        String definition = expressionString.replaceAll("\r", "\n").replaceAll("[\n\r][\n\r]", "\n");
        for (String line : definition.split("\n")) {
            Expression expression;
            int mark = line.indexOf("=");
            if (mark == -1) continue;
            String expressionDefinition = line.substring(mark + 1).trim();
            try {
                expression = CQL.toExpression((String)expressionDefinition);
            }
            catch (CQLException e) {
                throw new ModelsRuntimeException(e.toString(), this);
            }
            list.add(expression);
        }
        return list;
    }

    public String getNewTypeName(String typeName) {
        return typeName + count++;
    }
}

