/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gears.modules.v.vectorsimplifier;

import java.util.ArrayList;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Documentation;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Out;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.feature.DefaultFeatureCollection;
import org.hortonmachine.gears.libs.exceptions.ModelsIllegalargumentException;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.gears.utils.features.FeatureGeometrySubstitutor;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.precision.GeometryPrecisionReducer;
import org.locationtech.jts.simplify.DouglasPeuckerSimplifier;
import org.locationtech.jts.simplify.TopologyPreservingSimplifier;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

@Description(value="Collection of vector simplification algorithms.")
@Documentation(value="OmsVectorSimplifier.html")
@Author(name="Andrea Antonello", contact="http://www.hydrologis.com")
@Keywords(value="Simplify, OmsLineSmootherMcMaster, OmsLineSmootherJaitools")
@Label(value="Vector Processing")
@Name(value="vsimplify")
@Status(value=40)
@License(value="General Public License Version 3 (GPLv3)")
public class OmsVectorSimplifier
extends HMModel {
    @Description(value="The vector to be simplified.")
    @In
    public SimpleFeatureCollection inVector;
    @Description(value="The simplification type: TopologyPreservingSimplifier = 0, Douglas Peucker = 1 (default = 0).")
    @UI(value="combo:TopologyPreservingSimplifier,Douglas Peucker,Reduce coordinate precision")
    @In
    public String pType = "TopologyPreservingSimplifier";
    @Description(value="The distance tolerance for the simplification.")
    @In
    public double pTolerance = 0.2;
    @Description(value="The amount by which to multiply a coordinate after subtracting the offset, to obtain a precise coordinate")
    @In
    public Double pScale = 1000.0;
    @Description(value="The simplified vector.")
    @Out
    public SimpleFeatureCollection outVector;
    public static final String OMSVECTORSIMPLIFIER_DESCRIPTION = "Collection of vector simplification algorithms.";
    public static final String OMSVECTORSIMPLIFIER_DOCUMENTATION = "OmsVectorSimplifier.html";
    public static final String OMSVECTORSIMPLIFIER_KEYWORDS = "Simplify, OmsLineSmootherMcMaster, OmsLineSmootherJaitools";
    public static final String OMSVECTORSIMPLIFIER_LABEL = "Vector Processing";
    public static final String OMSVECTORSIMPLIFIER_NAME = "vsimplify";
    public static final int OMSVECTORSIMPLIFIER_STATUS = 40;
    public static final String OMSVECTORSIMPLIFIER_LICENSE = "General Public License Version 3 (GPLv3)";
    public static final String OMSVECTORSIMPLIFIER_AUTHORNAMES = "Andrea Antonello";
    public static final String OMSVECTORSIMPLIFIER_AUTHORCONTACTS = "http://www.hydrologis.com";
    public static final String OMSVECTORSIMPLIFIER_IN_VECTOR_DESCRIPTION = "The vector to be simplified.";
    public static final String OMSVECTORSIMPLIFIER_P_TYPE_DESCRIPTION = "The simplification type: TopologyPreservingSimplifier = 0, Douglas Peucker = 1 (default = 0).";
    public static final String OMSVECTORSIMPLIFIER_P_TOLERANCE_DESCRIPTION = "The distance tolerance for the simplification.";
    public static final String OMSVECTORSIMPLIFIER_P_SCALE_DESCRIPTION = "The amount by which to multiply a coordinate after subtracting the offset, to obtain a precise coordinate";
    public static final String OMSVECTORSIMPLIFIER_OUT_VECTOR_DESCRIPTION = "The simplified vector.";

    @Execute
    public void process() throws Exception {
        if (!this.concatOr(this.outVector == null, this.doReset)) {
            return;
        }
        SimpleFeatureIterator inFeatureIterator = this.inVector.features();
        this.outVector = new DefaultFeatureCollection();
        FeatureGeometrySubstitutor fGS = new FeatureGeometrySubstitutor((SimpleFeatureType)this.inVector.getSchema());
        GeometryPrecisionReducer geometryReducer = null;
        int size = this.inVector.size();
        this.pm.beginTask("Simplifing features...", size);
        while (inFeatureIterator.hasNext()) {
            SimpleFeature feature = (SimpleFeature)inFeatureIterator.next();
            Geometry geometry = (Geometry)feature.getDefaultGeometry();
            ArrayList<Geometry> geomList = new ArrayList<Geometry>();
            int numGeometries = geometry.getNumGeometries();
            block11: for (int i = 0; i < numGeometries; ++i) {
                Geometry geometryN = geometry.getGeometryN(i);
                switch (this.pType) {
                    case "TopologyPreservingSimplifier": {
                        TopologyPreservingSimplifier tpSimplifier = new TopologyPreservingSimplifier(geometryN);
                        tpSimplifier.setDistanceTolerance(this.pTolerance);
                        Geometry tpsGeometry = tpSimplifier.getResultGeometry();
                        geomList.add(tpsGeometry);
                        continue block11;
                    }
                    case "Douglas Peucker": {
                        DouglasPeuckerSimplifier dpSimplifier = new DouglasPeuckerSimplifier(geometryN);
                        dpSimplifier.setDistanceTolerance(this.pTolerance);
                        Geometry dpsGeometry = dpSimplifier.getResultGeometry();
                        geomList.add(dpsGeometry);
                        continue block11;
                    }
                    case "Reduce coordinate precision": {
                        if (geometryReducer == null) {
                            if (this.pScale == null) {
                                throw new ModelsIllegalargumentException("To reduce the precision the scale parameter needs to be set.", this);
                            }
                            geometryReducer = new GeometryPrecisionReducer(new PrecisionModel(this.pScale.doubleValue()));
                        }
                        geomList.add(geometryReducer.reduce(geometryN));
                    }
                }
            }
            Geometry newGeometry = null;
            if (geomList.size() == 1) {
                newGeometry = (Geometry)geomList.get(0);
            } else {
                Geometry[] geomArray = geomList.toArray(new Geometry[geomList.size()]);
                newGeometry = new GeometryCollection(geomArray, this.gf);
            }
            SimpleFeature newFeature = fGS.substituteGeometry(feature, newGeometry);
            ((DefaultFeatureCollection)this.outVector).add(newFeature);
            this.pm.worked(1);
        }
        this.pm.done();
        inFeatureIterator.close();
    }
}

