/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gears.modules.v.vectortablejoiner;

import java.util.HashMap;
import java.util.List;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Documentation;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Out;
import oms3.annotations.Status;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.feature.DefaultFeatureCollection;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.gears.utils.features.FeatureExtender;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

@Description(value="Module that joins attributes from one vector into another based on a common field.")
@Documentation(value="OmsVectorTableJoiner.html")
@Author(name="Andrea Antonello", contact="http://www.hydrologis.com")
@Keywords(value="Join, OmsVectorFieldRounder")
@Label(value="Vector Processing")
@Name(value="vjoin")
@Status(value=40)
@License(value="General Public License Version 3 (GPLv3)")
public class OmsVectorTableJoiner
extends HMModel {
    @Description(value="The vector to extend.")
    @In
    public SimpleFeatureCollection inVector;
    @Description(value="The dbf tabledata to merge in.")
    @In
    public HashMap<String, List<Object>> tabledata = null;
    @Description(value="The common field (if different in the two sources, commaseparated, first shapefile, then dbf.")
    @In
    public String fCommon = null;
    @Description(value="The commaseparated list of fields to merge in.")
    @In
    public String pFields = null;
    @Description(value="The joined vector.")
    @Out
    public SimpleFeatureCollection outVector;

    @Execute
    public void process() throws Exception {
        if (!this.concatOr(this.outVector == null, this.doReset)) {
            return;
        }
        String[] fields = this.pFields.split(",");
        Class[] classes = new Class[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            List<Object> list = this.tabledata.get(fields[i].trim());
            classes[i] = list.get(0).getClass();
        }
        String shapeField = this.fCommon;
        String tableField = this.fCommon;
        int comma = this.fCommon.indexOf(",");
        if (comma != -1) {
            String[] split = this.fCommon.split(",");
            shapeField = split[0].trim();
            tableField = split[1].trim();
        }
        List<Object> commonAttributeList = this.tabledata.get(tableField);
        FeatureExtender fExt = new FeatureExtender((SimpleFeatureType)this.inVector.getSchema(), fields, classes);
        this.outVector = new DefaultFeatureCollection();
        int size = this.inVector.size();
        this.pm.beginTask("Merging data...", size);
        SimpleFeatureIterator inFeatureIterator = this.inVector.features();
        while (inFeatureIterator.hasNext()) {
            SimpleFeature feature = (SimpleFeature)inFeatureIterator.next();
            Object attribute = feature.getAttribute(shapeField);
            int index = commonAttributeList.indexOf(attribute);
            if (index == -1) {
                if (attribute instanceof Number) {
                    Double doubleAttribute = ((Number)attribute).doubleValue();
                    index = commonAttributeList.indexOf(doubleAttribute);
                }
                if (index == -1) {
                    System.out.println("Jumped feature: " + feature.getID());
                    continue;
                }
            }
            Object[] newAttributes = new Object[fields.length];
            for (int i = 0; i < fields.length; ++i) {
                Object object;
                List<Object> list = this.tabledata.get(fields[i]);
                newAttributes[i] = object = list.get(index);
            }
            SimpleFeature newFeature = fExt.extendFeature(feature, newAttributes);
            ((DefaultFeatureCollection)this.outVector).add(newFeature);
            this.pm.worked(1);
        }
        this.pm.done();
        inFeatureIterator.close();
    }
}

