/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gears.spatialite;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.hortonmachine.dbs.compat.GeometryColumn;
import org.hortonmachine.dbs.compat.IHMResultSet;
import org.hortonmachine.dbs.compat.IHMStatement;
import org.hortonmachine.dbs.spatialite.hm.SpatialiteThreadsafeDb;
import org.hortonmachine.gears.utils.CrsUtilities;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class GTSpatialiteThreadsafeDb
extends SpatialiteThreadsafeDb {
    public ReferencedEnvelope getTableBounds(String tableName) throws Exception {
        GeometryColumn gCol = this.getGeometryColumnsForTable(tableName);
        String geomFieldName = gCol.geometryColumnName;
        int srid = gCol.srid;
        CoordinateReferenceSystem crs = CrsUtilities.getCrsFromSrid(srid);
        String trySql = "SELECT extent_min_x, extent_min_y, extent_max_x, extent_max_y FROM vector_layers_statistics WHERE table_name='" + tableName + "' AND geometry_column='" + geomFieldName + "'";
        ReferencedEnvelope resEnv = (ReferencedEnvelope)this.execOnConnection(connection -> {
            try (IHMStatement stmt = connection.createStatement();){
                ReferencedEnvelope referencedEnvelope;
                block16: {
                    IHMResultSet rs;
                    block14: {
                        ReferencedEnvelope referencedEnvelope2;
                        block15: {
                            rs = stmt.executeQuery(trySql);
                            try {
                                double maxY;
                                if (!rs.next()) break block14;
                                double minX = rs.getDouble(1);
                                double minY = rs.getDouble(2);
                                double maxX = rs.getDouble(3);
                                ReferencedEnvelope env = new ReferencedEnvelope(minX, maxX, minY, maxY = rs.getDouble(4), crs);
                                if (env.getWidth() == 0.0 || env.getHeight() == 0.0) break block14;
                                referencedEnvelope2 = env;
                                if (rs == null) break block15;
                            }
                            catch (Throwable throwable) {
                                if (rs != null) {
                                    try {
                                        rs.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                }
                                throw throwable;
                            }
                            rs.close();
                        }
                        return referencedEnvelope2;
                    }
                    referencedEnvelope = null;
                    if (rs == null) break block16;
                    rs.close();
                }
                return referencedEnvelope;
            }
        });
        if (resEnv != null) {
            return resEnv;
        }
        String sql = "SELECT Min(MbrMinX(" + geomFieldName + ")) AS min_x, Min(MbrMinY(" + geomFieldName + ")) AS min_y,Max(MbrMaxX(" + geomFieldName + ")) AS max_x, Max(MbrMaxY(" + geomFieldName + ")) AS max_y FROM " + tableName;
        return (ReferencedEnvelope)this.execOnConnection(connection -> {
            try (IHMStatement stmt = connection.createStatement();){
                ReferencedEnvelope referencedEnvelope;
                block16: {
                    IHMResultSet rs;
                    block14: {
                        ReferencedEnvelope referencedEnvelope2;
                        block15: {
                            rs = stmt.executeQuery(sql);
                            try {
                                ReferencedEnvelope env;
                                if (!rs.next()) break block14;
                                double minX = rs.getDouble(1);
                                double minY = rs.getDouble(2);
                                double maxX = rs.getDouble(3);
                                double maxY = rs.getDouble(4);
                                referencedEnvelope2 = env = new ReferencedEnvelope(minX, maxX, minY, maxY, crs);
                                if (rs == null) break block15;
                            }
                            catch (Throwable throwable) {
                                if (rs != null) {
                                    try {
                                        rs.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                }
                                throw throwable;
                            }
                            rs.close();
                        }
                        return referencedEnvelope2;
                    }
                    referencedEnvelope = null;
                    if (rs == null) break block16;
                    rs.close();
                }
                return referencedEnvelope;
            }
        });
    }

    public void executeSqlFile(File file, int chunks, boolean eachLineAnSql) throws Exception {
        this.execOnConnection(mConn -> {
            boolean autoCommit = mConn.getAutoCommit();
            mConn.setAutoCommit(false);
            Predicate<String> validSqlLine = s -> s.length() != 0 && !s.startsWith("BEGIN") && !s.startsWith("COMMIT");
            Predicate<String> commentPredicate = s -> !s.startsWith("--");
            try (IHMStatement pStmt = mConn.createStatement();){
                int[] counter = new int[]{1};
                Stream<String> linesStream = null;
                linesStream = eachLineAnSql ? Files.lines(Paths.get(file.getAbsolutePath(), new String[0])).map(s -> s.trim()).filter(commentPredicate).filter(validSqlLine) : Arrays.stream(Files.lines(Paths.get(file.getAbsolutePath(), new String[0])).filter(commentPredicate).collect(Collectors.joining()).split(";")).filter(validSqlLine);
                Consumer<String> executeAction = s -> {
                    try {
                        pStmt.executeUpdate(s);
                        counter[0] = counter[0] + 1;
                        if (counter[0] % chunks == 0) {
                            mConn.commit();
                        }
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                };
                linesStream.forEach(executeAction);
                mConn.commit();
            }
            mConn.setAutoCommit(autoCommit);
            return null;
        });
    }
}

