/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gears.spatialite;

import java.io.File;
import java.lang.invoke.CallSite;
import java.sql.Clob;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.geotools.data.FileDataStore;
import org.geotools.data.FileDataStoreFinder;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.data.store.ReprojectingFeatureCollection;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.hortonmachine.dbs.compat.ADatabaseSyntaxHelper;
import org.hortonmachine.dbs.compat.ASpatialDb;
import org.hortonmachine.dbs.compat.GeometryColumn;
import org.hortonmachine.dbs.compat.IGeometryParser;
import org.hortonmachine.dbs.compat.IHMPreparedStatement;
import org.hortonmachine.dbs.compat.objects.QueryResult;
import org.hortonmachine.dbs.datatypes.EDataType;
import org.hortonmachine.dbs.geopackage.GeopackageCommonDb;
import org.hortonmachine.dbs.geopackage.hm.GeopackageDb;
import org.hortonmachine.dbs.h2gis.H2GisDb;
import org.hortonmachine.dbs.log.Logger;
import org.hortonmachine.dbs.postgis.PostgisDb;
import org.hortonmachine.dbs.spatialite.hm.SpatialiteDb;
import org.hortonmachine.dbs.utils.DbsUtilities;
import org.hortonmachine.gears.libs.monitor.IHMProgressMonitor;
import org.hortonmachine.gears.utils.CrsUtilities;
import org.hortonmachine.gears.utils.features.FeatureUtilities;
import org.hortonmachine.gears.utils.files.FileUtilities;
import org.hortonmachine.gears.utils.geometry.GeometryUtilities;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.feature.type.GeometryType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class SpatialDbsImportUtils {
    private static final String FID = "fid";
    private static final String PK_UID = "PK_UID";
    private static final Logger logger = Logger.INSTANCE;
    public static final String GEOMFIELD_FOR_SHAPEFILE = "the_geom";

    public static String createTableFromShp(ASpatialDb db, File shapeFile, String newTableName, String forceSrid, boolean avoidSpatialIndex) throws Exception {
        FileDataStore store = FileDataStoreFinder.getDataStore((File)shapeFile);
        SimpleFeatureSource featureSource = store.getFeatureSource();
        SimpleFeatureType schema = (SimpleFeatureType)featureSource.getSchema();
        if (newTableName == null) {
            newTableName = FileUtilities.getNameWithoutExtention(shapeFile);
        }
        return SpatialDbsImportUtils.createTableFromSchema(db, schema, newTableName, forceSrid, avoidSpatialIndex);
    }

    public static String createTableFromSchema(ASpatialDb db, SimpleFeatureType schema, String newTableName, String forceSrid, boolean avoidSpatialIndex) throws Exception {
        GeometryDescriptor geometryDescriptor = schema.getGeometryDescriptor();
        ADatabaseSyntaxHelper dsh = db.getType().getDatabaseSyntaxHelper();
        ArrayList<CallSite> attrSql = new ArrayList<CallSite>();
        attrSql.add((CallSite)((Object)("fid " + dsh.LONG_PRIMARYKEY_AUTOINCREMENT())));
        String fidField = FeatureUtilities.findAttributeName(schema, FID);
        List attributeDescriptors = schema.getAttributeDescriptors();
        for (AttributeDescriptor attributeDescriptor : attributeDescriptors) {
            Class binding;
            String attrName = attributeDescriptor.getLocalName();
            if (fidField != null && fidField.equals(attrName) || attributeDescriptor instanceof GeometryDescriptor || attrName.equalsIgnoreCase(PK_UID)) continue;
            if (DbsUtilities.isReservedName((String)attrName)) {
                attrName = DbsUtilities.fixReservedNameForQuery((String)attrName);
            }
            if ((binding = attributeDescriptor.getType().getBinding()).isAssignableFrom(Double.class) || binding.isAssignableFrom(Float.class)) {
                attrSql.add((CallSite)((Object)(attrName + " " + dsh.REAL())));
                continue;
            }
            if (binding.isAssignableFrom(Long.class) || binding.isAssignableFrom(Integer.class)) {
                attrSql.add((CallSite)((Object)(attrName + " " + dsh.INTEGER())));
                continue;
            }
            if (binding.isAssignableFrom(String.class)) {
                attrSql.add((CallSite)((Object)(attrName + " " + dsh.TEXT())));
                continue;
            }
            attrSql.add((CallSite)((Object)(attrName + " " + dsh.TEXT())));
        }
        String typeString = null;
        GeometryType type = geometryDescriptor.getType();
        Class binding = type.getBinding();
        if (binding.isAssignableFrom(MultiPolygon.class)) {
            typeString = "MULTIPOLYGON";
        } else if (binding.isAssignableFrom(Polygon.class)) {
            typeString = "POLYGON";
        } else if (binding.isAssignableFrom(MultiLineString.class)) {
            typeString = "MULTILINESTRING";
        } else if (binding.isAssignableFrom(LineString.class)) {
            typeString = "LINESTRING";
        } else if (binding.isAssignableFrom(MultiPoint.class)) {
            typeString = "MULTIPOINT";
        } else if (binding.isAssignableFrom(Point.class)) {
            typeString = "POINT";
        }
        if (typeString != null) {
            String sridString = forceSrid;
            if (sridString == null) {
                String codeFromCrs = CrsUtilities.getCodeFromCrs(schema.getCoordinateReferenceSystem());
                if (codeFromCrs == null || codeFromCrs.toLowerCase().contains("null")) {
                    codeFromCrs = "4326";
                }
                sridString = codeFromCrs.replaceFirst("EPSG:", "");
            }
            if (db instanceof SpatialiteDb) {
                SpatialiteDb spatialiteDb = (SpatialiteDb)db;
                spatialiteDb.createTable(newTableName, attrSql.toArray(new String[0]));
                spatialiteDb.addGeometryXYColumnAndIndex(newTableName, GEOMFIELD_FOR_SHAPEFILE, typeString, sridString, avoidSpatialIndex);
            } else if (db instanceof PostgisDb) {
                PostgisDb postgisDb = (PostgisDb)db;
                postgisDb.createTable(newTableName, attrSql.toArray(new String[0]));
                postgisDb.addGeometryXYColumnAndIndex(newTableName, GEOMFIELD_FOR_SHAPEFILE, typeString, sridString, avoidSpatialIndex);
            } else if (db instanceof H2GisDb) {
                H2GisDb h2gisDb = (H2GisDb)db;
                String typeStringExtra = typeString;
                attrSql.add((CallSite)((Object)("the_geom " + typeStringExtra)));
                String[] array = attrSql.toArray(new String[0]);
                h2gisDb.createTable(newTableName, array);
                h2gisDb.addSrid(newTableName, sridString, GEOMFIELD_FOR_SHAPEFILE);
                if (!avoidSpatialIndex) {
                    h2gisDb.createSpatialIndex(newTableName, GEOMFIELD_FOR_SHAPEFILE);
                }
            } else if (db instanceof GeopackageDb) {
                GeopackageCommonDb gpkgDb = (GeopackageCommonDb)db;
                int srid = Integer.parseInt(sridString);
                CoordinateReferenceSystem crs = CrsUtilities.getCrsFromSrid(srid);
                gpkgDb.addCRS("EPSG", srid, crs.toWKT());
                String[] array = attrSql.toArray(new String[0]);
                gpkgDb.createSpatialTable(newTableName, Integer.parseInt(sridString), "the_geom " + typeString, array, null, avoidSpatialIndex);
            }
        } else {
            db.createTable(newTableName, attrSql.toArray(new String[0]));
        }
        return newTableName;
    }

    public static boolean importShapefile(ASpatialDb db, File shapeFile, String tableName, int limit, boolean useFromTextForGeom, IHMProgressMonitor pm) throws Exception {
        FileDataStore store = FileDataStoreFinder.getDataStore((File)shapeFile);
        SimpleFeatureSource featureSource = store.getFeatureSource();
        SimpleFeatureCollection features = featureSource.getFeatures();
        return SpatialDbsImportUtils.importFeatureCollection(db, features, tableName, limit, useFromTextForGeom, pm);
    }

    public static boolean importFeatureCollection(ASpatialDb db, SimpleFeatureCollection featureCollection, String tableName, int limit, boolean useFromTextForGeom, IHMProgressMonitor pm) throws Exception {
        SimpleFeatureIterator featureIterator;
        SimpleFeatureType schema = (SimpleFeatureType)featureCollection.getSchema();
        List attributeDescriptors = schema.getAttributeDescriptors();
        int featureCount = featureCollection.size();
        List tableInfo = db.getTableColumns(tableName);
        ArrayList<String> tableColumns = new ArrayList<String>();
        boolean hasFid = false;
        for (String[] item : tableInfo) {
            String colName = item[0].toUpperCase();
            tableColumns.add(colName);
            if (!colName.equalsIgnoreCase(FID)) continue;
            hasFid = true;
        }
        GeometryColumn geometryColumns = db.getGeometryColumnsForTable(tableName);
        String gCol = geometryColumns.geometryColumnName;
        int epsg = geometryColumns.srid;
        CoordinateReferenceSystem crs = null;
        try {
            crs = CrsUtilities.getCrsFromEpsg("EPSG:" + epsg);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (crs != null) {
            ReprojectingFeatureCollection repFeatures = new ReprojectingFeatureCollection(featureCollection, crs);
            featureIterator = repFeatures.features();
        } else {
            featureIterator = featureCollection.features();
        }
        ArrayList<String> attrNames = new ArrayList<String>();
        Object valueNames = hasFid ? FID : "";
        Object qMarks = hasFid ? "?" : "";
        for (AttributeDescriptor attributeDescriptor : attributeDescriptors) {
            String attrName = attributeDescriptor.getLocalName();
            String fidField = FeatureUtilities.findAttributeName(schema, FID);
            if (fidField != null && fidField.equals(attrName) || attrName.equalsIgnoreCase(PK_UID)) continue;
            attrNames.add(attrName);
            if (attributeDescriptor instanceof GeometryDescriptor) {
                valueNames = (String)valueNames + "," + gCol;
                if (useFromTextForGeom) {
                    qMarks = (String)qMarks + ",ST_GeomFromText(?, " + epsg + ")";
                    continue;
                }
                qMarks = (String)qMarks + ",?";
                continue;
            }
            if (!tableColumns.contains(attrName.toUpperCase())) {
                pm.errorMessage("The imported shapefile doesn't seem to match the table's schema. Doesn't exist: " + attrName);
                return false;
            }
            if (DbsUtilities.isReservedName((String)attrName)) {
                attrName = DbsUtilities.fixReservedNameForQuery((String)attrName);
            }
            valueNames = (String)valueNames + "," + attrName;
            qMarks = (String)qMarks + ",?";
        }
        if (((String)valueNames).startsWith(",")) {
            valueNames = ((String)valueNames).substring(1);
            qMarks = ((String)qMarks).substring(1);
        }
        String sql = "INSERT INTO " + tableName + " (" + (String)valueNames + ") VALUES (" + (String)qMarks + ")";
        IGeometryParser gp = db.getType().getGeometryParser();
        boolean _hasFid = hasFid;
        return (Boolean)db.execOnConnection(conn -> {
            boolean noErrors = true;
            boolean autoCommit = conn.getAutoCommit();
            conn.setAutoCommit(false);
            try (IHMPreparedStatement pStmt = conn.prepareStatement(sql);){
                int count = 0;
                int batchCount = 0;
                try {
                    while (featureIterator.hasNext()) {
                        SimpleFeature f = (SimpleFeature)featureIterator.next();
                        int shift = 1;
                        if (_hasFid) {
                            long featureId = FeatureUtilities.getFeatureId(f);
                            pStmt.setLong(1, featureId);
                            shift = 2;
                        }
                        for (int i = 0; i < attrNames.size(); ++i) {
                            Object object = f.getAttribute((String)attrNames.get(i));
                            int iPlus = i + shift;
                            if (object == null) {
                                pStmt.setObject(iPlus, null);
                                continue;
                            }
                            if (object instanceof Double) {
                                pStmt.setDouble(iPlus, ((Double)object).doubleValue());
                                continue;
                            }
                            if (object instanceof Float) {
                                pStmt.setFloat(iPlus, ((Float)object).floatValue());
                                continue;
                            }
                            if (object instanceof Integer) {
                                pStmt.setInt(iPlus, ((Integer)object).intValue());
                                continue;
                            }
                            if (object instanceof Long) {
                                pStmt.setLong(iPlus, ((Long)object).longValue());
                                continue;
                            }
                            if (object instanceof String) {
                                pStmt.setString(iPlus, (String)object);
                                continue;
                            }
                            if (object instanceof Geometry) {
                                Geometry geom = (Geometry)object;
                                if (useFromTextForGeom) {
                                    pStmt.setString(iPlus, geom.toText());
                                    continue;
                                }
                                geom.setSRID(epsg);
                                pStmt.setObject(iPlus, gp.toSqlObject(geom));
                                continue;
                            }
                            if (object instanceof Clob) {
                                String string = ((Clob)object).toString();
                                pStmt.setString(iPlus, string);
                                continue;
                            }
                            pStmt.setString(iPlus, object.toString());
                        }
                        pStmt.addBatch();
                        ++count;
                        if (++batchCount % 10000 == 0) {
                            pm.beginTask("Batch import " + batchCount + " features. ( " + count + " of " + featureCount + " )", -1);
                            pStmt.executeBatch();
                            pm.done();
                            batchCount = 0;
                        }
                        if (limit <= 0 || count < limit) continue;
                        break;
                    }
                    if (batchCount > 0) {
                        pm.beginTask("Batch import " + batchCount + " features. ( " + count + " of " + featureCount + " )", -1);
                        pStmt.executeBatch();
                        pm.done();
                    }
                }
                catch (Exception e) {
                    logger.insertError("SpatialDbsImportUtils", "error", (Throwable)e);
                    noErrors = false;
                }
                finally {
                    featureIterator.close();
                }
            }
            conn.setAutoCommit(autoCommit);
            pStmt = conn.createStatement();
            try {
                try {
                    pStmt.executeQuery("Select updateLayerStatistics();");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            finally {
                if (pStmt != null) {
                    pStmt.close();
                }
            }
            return noErrors;
        });
    }

    public static DefaultFeatureCollection tableToFeatureFCollection(ASpatialDb db, String tableName, int featureLimit, int forceSrid, String whereStr) throws SQLException, Exception {
        CoordinateReferenceSystem crs;
        DefaultFeatureCollection fc = new DefaultFeatureCollection();
        GeometryColumn geometryColumn = db.getGeometryColumnsForTable(tableName);
        CoordinateReferenceSystem forceCrs = null;
        if (geometryColumn != null) {
            if (forceSrid == -1) {
                forceSrid = geometryColumn.srid;
            } else {
                forceCrs = CrsUtilities.getCrsFromEpsg("EPSG:" + forceSrid);
            }
            crs = CrsUtilities.getCrsFromEpsg("EPSG:" + geometryColumn.srid);
        } else {
            crs = CrsUtilities.getCrsFromEpsg("EPSG:" + forceSrid);
        }
        QueryResult tableRecords = db.getTableRecordsMapIn(tableName, null, featureLimit, forceSrid, whereStr);
        if (tableRecords.data.size() == 0) {
            return fc;
        }
        int geometryIndex = tableRecords.geometryIndex;
        int latIndex = -1;
        int lonIndex = -1;
        Geometry sampleGeom = null;
        if (geometryIndex == -1) {
            for (String fieldName : tableRecords.names) {
                if (fieldName.toLowerCase().startsWith("lat")) {
                    latIndex = tableRecords.names.indexOf(fieldName);
                    continue;
                }
                if (!fieldName.toLowerCase().startsWith("lon")) continue;
                lonIndex = tableRecords.names.indexOf(fieldName);
            }
            if (latIndex == -1 || lonIndex == -1) {
                throw new IllegalArgumentException("Not a geometric layer.");
            }
        } else {
            sampleGeom = (Geometry)((Object[])tableRecords.data.get(0))[geometryIndex];
        }
        List names = tableRecords.names;
        List types = tableRecords.types;
        SimpleFeatureTypeBuilder b = new SimpleFeatureTypeBuilder();
        b.setName(tableName);
        if (forceCrs != null) {
            b.setCRS(forceCrs);
        } else {
            b.setCRS(crs);
        }
        if (latIndex != -1 && lonIndex != -1) {
            b.add(GEOMFIELD_FOR_SHAPEFILE, Point.class);
        }
        for (int i = 0; i < names.size(); ++i) {
            if (geometryIndex != -1 && i == geometryIndex) {
                Class<?> geometryClass = sampleGeom.getClass();
                b.add(geometryColumn.geometryColumnName, geometryClass);
                continue;
            }
            Class fieldClass = null;
            String typeStr = (String)types.get(i);
            EDataType type = EDataType.getType4Name((String)typeStr);
            switch (type) {
                case DOUBLE: {
                    fieldClass = Double.class;
                    break;
                }
                case FLOAT: {
                    fieldClass = Float.class;
                    break;
                }
                case INTEGER: {
                    fieldClass = Integer.class;
                    break;
                }
                case LONG: {
                    fieldClass = Long.class;
                    break;
                }
                case BOOLEAN: {
                    fieldClass = Integer.class;
                    break;
                }
                case DATE: 
                case DATETIME: {
                    fieldClass = String.class;
                    break;
                }
                case TEXT: {
                    fieldClass = String.class;
                    break;
                }
                default: {
                    fieldClass = String.class;
                }
            }
            b.add((String)names.get(i), fieldClass);
        }
        SimpleFeatureType type = b.buildFeatureType();
        SimpleFeatureBuilder builder = new SimpleFeatureBuilder(type);
        int count = tableRecords.data.size();
        for (int i = 0; i < count; ++i) {
            Object[] objects = (Object[])tableRecords.data.get(i);
            if (latIndex != -1 && lonIndex != -1) {
                double lat = ((Number)objects[latIndex]).doubleValue();
                double lon = ((Number)objects[lonIndex]).doubleValue();
                Point point = GeometryUtilities.gf().createPoint(new Coordinate(lon, lat));
                Object[] newObjects = new Object[objects.length + 1];
                System.arraycopy(objects, 0, newObjects, 1, objects.length);
                newObjects[0] = point;
                builder.addAll(newObjects);
            } else {
                builder.addAll(objects);
            }
            SimpleFeature feature = builder.buildFeature(null);
            fc.add(feature);
        }
        return fc;
    }

    public static DefaultFeatureCollection tableGeomsToFeatureFCollection(ASpatialDb db, String tableName, int forceSrid, String geomPrefix, String geomPostfix, String whereStr) throws SQLException, Exception {
        CoordinateReferenceSystem crs;
        GeometryColumn geometryColumn = db.getGeometryColumnsForTable(tableName);
        if (geometryColumn != null) {
            if (forceSrid == -1) {
                forceSrid = geometryColumn.srid;
            }
            crs = CrsUtilities.getCrsFromEpsg("EPSG:" + geometryColumn.srid);
        } else {
            crs = CrsUtilities.getCrsFromEpsg("EPSG:" + forceSrid);
        }
        List tableRecords = db.getGeometriesIn(tableName, (Envelope)null, new String[]{geomPrefix, geomPostfix, whereStr});
        Object fc = tableRecords.size() > 0 ? FeatureUtilities.featureCollectionFromGeometry(crs, tableRecords.toArray(new Geometry[tableRecords.size()])) : new DefaultFeatureCollection();
        return fc;
    }
}

