/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gears.ui;

import java.awt.Color;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.RenderedImage;
import java.io.File;
import javax.media.jai.InterpolationBilinear;
import javax.media.jai.iterator.RectIter;
import javax.media.jai.iterator.RectIterFactory;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Documentation;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.coverage.grid.io.GridCoverage2DReader;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.FeatureCollection;
import org.geotools.gce.imagemosaic.ImageMosaicFormat;
import org.geotools.gce.imagemosaic.ImageMosaicReader;
import org.geotools.map.FeatureLayer;
import org.geotools.map.GridCoverageLayer;
import org.geotools.map.GridReaderLayer;
import org.geotools.map.Layer;
import org.geotools.map.MapContent;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.styling.ColorMapEntry;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.Graphic;
import org.geotools.styling.LineSymbolizer;
import org.geotools.styling.Mark;
import org.geotools.styling.PointSymbolizer;
import org.geotools.styling.PolygonSymbolizer;
import org.geotools.styling.RasterSymbolizer;
import org.geotools.styling.Rule;
import org.geotools.styling.SLD;
import org.geotools.styling.Stroke;
import org.geotools.styling.Style;
import org.geotools.styling.StyleBuilder;
import org.geotools.styling.StyleFactory;
import org.geotools.styling.Symbolizer;
import org.geotools.swing.JMapFrame;
import org.geotools.util.factory.GeoTools;
import org.geotools.util.factory.Hints;
import org.hortonmachine.gears.io.rasterreader.OmsRasterReader;
import org.hortonmachine.gears.io.vectorreader.OmsVectorReader;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.gears.utils.SldUtilities;
import org.hortonmachine.gears.utils.geometry.EGeometryType;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Literal;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterValue;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.style.ColorMap;
import org.opengis.style.Fill;

@Description(value="A simple geodata viewer.")
@Documentation(value="OmsMapsViewer.html")
@Author(name="Andrea Antonello", contact="http://www.hydrologis.com")
@Keywords(value="Coverage, Raster, Viewer, UI")
@Label(value="Others")
@Name(value="mapsviewer")
@Status(value=40)
@License(value="General Public License Version 3 (GPLv3)")
@UI(value="hide")
public class OmsMapsViewer
extends HMModel {
    @Description(value="The rasters to visualize.")
    @In
    public String[] inRasters = null;
    public String[] inImageMosaics = null;
    @Description(value="The feature collections to visualize.")
    @In
    public String[] inVectors = null;
    public static final String OMSMAPSVIEWER_DESCRIPTION = "A simple geodata viewer.";
    public static final String OMSMAPSVIEWER_DOCUMENTATION = "OmsMapsViewer.html";
    public static final String OMSMAPSVIEWER_KEYWORDS = "Coverage, Raster, Viewer, UI";
    public static final String OMSMAPSVIEWER_LABEL = "Others";
    public static final String OMSMAPSVIEWER_NAME = "mapsviewer";
    public static final int OMSMAPSVIEWER_STATUS = 40;
    public static final String OMSMAPSVIEWER_LICENSE = "General Public License Version 3 (GPLv3)";
    public static final String OMSMAPSVIEWER_AUTHORNAMES = "Andrea Antonello";
    public static final String OMSMAPSVIEWER_AUTHORCONTACTS = "http://www.hydrologis.com";
    public static final String OMSMAPSVIEWER_UI = "hide";
    public static final String OMSMAPSVIEWER_IN_RASTERS_DESCRIPTION = "The rasters to visualize.";
    public static final String OMSMAPSVIEWER_IN_RASTER_DESCRIPTION = "The raster to visualize.";
    public static final String OMSMAPSVIEWER_IN_VECTORS_DESCRIPTION = "The feature collections to visualize.";
    public static final String OMSMAPSVIEWER_IN_VECTOR_DESCRIPTION = "The feature collection to visualize.";
    public static final String OMSMAPSVIEWER_IN_S_L_D_DESCRIPTION = "The feature collections style layer.";
    private StyleFactory sf = null;
    private FilterFactory ff = null;
    private StyleBuilder sb = null;

    @Execute
    public void displayMaps() throws Exception {
        this.sf = CommonFactoryFinder.getStyleFactory((Hints)GeoTools.getDefaultHints());
        this.ff = CommonFactoryFinder.getFilterFactory((Hints)GeoTools.getDefaultHints());
        this.sb = new StyleBuilder(this.sf, this.ff);
        MapContent map = new MapContent();
        map.setTitle("Maps Viewer");
        this.addImageMosaic(map);
        this.addCoverages(map);
        this.addFeatureCollections(map);
        map.getViewport().setCoordinateReferenceSystem((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        final JMapFrame frame = new JMapFrame(map);
        frame.setSize(1800, 1200);
        frame.enableStatusBar(true);
        frame.enableTool(new JMapFrame.Tool[]{JMapFrame.Tool.ZOOM, JMapFrame.Tool.PAN, JMapFrame.Tool.RESET});
        frame.enableToolBar(true);
        frame.setVisible(true);
        frame.addWindowListener((WindowListener)new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                frame.setVisible(false);
            }
        });
        while (frame.isVisible()) {
            Thread.sleep(300L);
        }
    }

    private void addImageMosaic(MapContent map) throws Exception {
        if (this.inImageMosaics != null) {
            RasterSymbolizer sym = this.sf.getDefaultRasterSymbolizer();
            Style style = SLD.wrapSymbolizers((Symbolizer[])new Symbolizer[]{sym});
            ParameterValue inTransp = AbstractGridFormat.INPUT_TRANSPARENT_COLOR.createValue();
            inTransp.setValue((Object)Color.white);
            ParameterValue outTransp = ImageMosaicFormat.OUTPUT_TRANSPARENT_COLOR.createValue();
            outTransp.setValue((Object)Color.white);
            ParameterValue backColor = ImageMosaicFormat.BACKGROUND_COLOR.createValue();
            backColor.setValue((Object)Color.RED);
            ParameterValue fading = ImageMosaicFormat.FADING.createValue();
            fading.setValue(true);
            ParameterValue interpol = ImageMosaicFormat.INTERPOLATION.createValue();
            interpol.setValue((Object)new InterpolationBilinear());
            ParameterValue resol = ImageMosaicFormat.ACCURATE_RESOLUTION.createValue();
            resol.setValue(true);
            ParameterValue multiThread = ImageMosaicFormat.ALLOW_MULTITHREADING.createValue();
            multiThread.setValue(true);
            ParameterValue usejai = ImageMosaicFormat.USE_JAI_IMAGEREAD.createValue();
            usejai.setValue(false);
            ParameterValue bkg = ImageMosaicFormat.BACKGROUND_VALUES.createValue();
            bkg.setValue((Object)new double[]{0.0});
            GeneralParameterValue[] gp = new GeneralParameterValue[]{inTransp, multiThread};
            for (String imageMosaicPath : this.inImageMosaics) {
                ImageMosaicReader imr = new ImageMosaicReader((Object)new File(imageMosaicPath));
                GridReaderLayer layer = new GridReaderLayer((GridCoverage2DReader)imr, style, gp);
                map.addLayer((Layer)layer);
            }
        }
    }

    private void addFeatureCollections(MapContent map) throws Exception {
        if (this.inVectors == null) {
            return;
        }
        for (String path : this.inVectors) {
            SimpleFeatureCollection fc = OmsVectorReader.readVector(path);
            GeometryDescriptor geometryDescriptor = ((SimpleFeatureType)fc.getSchema()).getGeometryDescriptor();
            EGeometryType type = EGeometryType.forGeometryDescriptor(geometryDescriptor);
            File file = new File(path);
            Style style = SldUtilities.getStyleFromFile(file);
            switch (type) {
                case MULTIPOLYGON: 
                case POLYGON: {
                    if (style != null) break;
                    Stroke polygonStroke = this.sf.createStroke((Expression)this.ff.literal((Object)Color.BLUE), (Expression)this.ff.literal(2));
                    org.geotools.styling.Fill polygonFill = this.sf.createFill((Expression)this.ff.literal((Object)Color.BLUE), (Expression)this.ff.literal(0.0));
                    Rule polygonRule = this.sf.createRule();
                    PolygonSymbolizer polygonSymbolizer = this.sf.createPolygonSymbolizer(polygonStroke, polygonFill, null);
                    polygonRule.symbolizers().add(polygonSymbolizer);
                    FeatureTypeStyle polygonFeatureTypeStyle = this.sf.createFeatureTypeStyle();
                    polygonFeatureTypeStyle.rules().add(polygonRule);
                    style = this.sf.createStyle();
                    style.featureTypeStyles().add(polygonFeatureTypeStyle);
                    style.setName("polygons");
                    break;
                }
                case MULTIPOINT: 
                case POINT: {
                    if (style != null) break;
                    Mark circleMark = this.sf.getCircleMark();
                    org.geotools.styling.Fill fill = this.sf.createFill((Expression)this.ff.literal((Object)Color.RED));
                    circleMark.setFill((Fill)fill);
                    Graphic gr = this.sf.createDefaultGraphic();
                    gr.graphicalSymbols().clear();
                    gr.graphicalSymbols().add(circleMark);
                    Literal size = this.ff.literal(6);
                    gr.setSize((Expression)size);
                    Rule pointRule = this.sf.createRule();
                    PointSymbolizer pointSymbolizer = this.sf.createPointSymbolizer(gr, null);
                    pointRule.symbolizers().add(pointSymbolizer);
                    FeatureTypeStyle pointsFeatureTypeStyle = this.sf.createFeatureTypeStyle();
                    pointsFeatureTypeStyle.rules().add(pointRule);
                    style = this.sf.createStyle();
                    style.featureTypeStyles().add(pointsFeatureTypeStyle);
                    style.setName("points");
                    break;
                }
                case MULTILINESTRING: 
                case LINESTRING: {
                    if (style != null) break;
                    Stroke lineStroke = this.sf.createStroke((Expression)this.ff.literal((Object)Color.RED), (Expression)this.ff.literal(2));
                    Rule lineRule = this.sf.createRule();
                    LineSymbolizer lineSymbolizer = this.sf.createLineSymbolizer(lineStroke, null);
                    lineRule.symbolizers().add(lineSymbolizer);
                    FeatureTypeStyle lineFeatureTypeStyle = this.sf.createFeatureTypeStyle();
                    lineFeatureTypeStyle.rules().add(lineRule);
                    style = this.sf.createStyle();
                    style.featureTypeStyles().add(lineFeatureTypeStyle);
                    style.setName("lines");
                    break;
                }
            }
            FeatureLayer layer = new FeatureLayer((FeatureCollection)fc, style);
            map.addLayer((Layer)layer);
        }
    }

    private void addCoverages(MapContent map) throws Exception {
        if (this.inRasters == null) {
            return;
        }
        RasterSymbolizer rasterSym = this.sf.createRasterSymbolizer();
        org.geotools.styling.ColorMap colorMap = this.sf.createColorMap();
        for (String rasterPath : this.inRasters) {
            GridCoverage2D readRaster = OmsRasterReader.readRaster(rasterPath);
            RenderedImage renderedImage = readRaster.getRenderedImage();
            double max = Double.NEGATIVE_INFINITY;
            double min = Double.POSITIVE_INFINITY;
            RectIter iter = RectIterFactory.create((RenderedImage)renderedImage, null);
            while (true) {
                double value;
                if ((value = iter.getSampleDouble()) > max) {
                    max = value;
                }
                if (value < min) {
                    min = value;
                }
                if (!iter.nextPixelDone()) continue;
                iter.startPixels();
                if (iter.nextLineDone()) break;
            }
            Color fromColor = Color.blue;
            Color midColor = Color.green;
            Color toColor = Color.red;
            Expression fromColorExpr = this.sb.colorExpression(new Color(fromColor.getRed(), fromColor.getGreen(), fromColor.getBlue(), 255));
            Expression midColorExpr = this.sb.colorExpression(new Color(midColor.getRed(), midColor.getGreen(), midColor.getBlue(), 255));
            Expression toColorExpr = this.sb.colorExpression(new Color(toColor.getRed(), toColor.getGreen(), toColor.getBlue(), 255));
            Expression fromExpr = this.sb.literalExpression(min);
            Expression midExpr = this.sb.literalExpression(min + (max - min) / 2.0);
            Expression toExpr = this.sb.literalExpression(max);
            ColorMapEntry entry = this.sf.createColorMapEntry();
            entry.setQuantity(fromExpr);
            entry.setColor(fromColorExpr);
            colorMap.addColorMapEntry(entry);
            entry = this.sf.createColorMapEntry();
            entry.setQuantity(midExpr);
            entry.setColor(midColorExpr);
            colorMap.addColorMapEntry(entry);
            entry = this.sf.createColorMapEntry();
            entry.setQuantity(toExpr);
            entry.setColor(toColorExpr);
            colorMap.addColorMapEntry(entry);
            rasterSym.setColorMap((ColorMap)colorMap);
            Style rasterStyle = SLD.wrapSymbolizers((Symbolizer[])new Symbolizer[]{rasterSym});
            GridCoverageLayer layer = new GridCoverageLayer(readRaster, rasterStyle);
            map.addLayer((Layer)layer);
        }
    }

    public static void main(String[] args) throws Exception {
        OmsMapsViewer mv = new OmsMapsViewer();
        mv.inVectors = new String[]{"/media/hydrologis/Samsung_T3/IMAGEMOSAICTEST/ctr10k.shp"};
        mv.inImageMosaics = new String[]{"/media/hydrologis/Samsung_T3/IMAGEMOSAICTEST/ctr10k/ctr10k.shp"};
        mv.displayMaps();
    }
}

