/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gears.utils;

import java.util.BitSet;

public class BitMatrix {
    private BitSet bitSet;
    private int cols;
    private int rows;

    public BitMatrix(int cols, int rows) {
        this.cols = cols;
        this.rows = rows;
        this.bitSet = new BitSet(cols * rows);
    }

    public boolean isMarked(int col, int row) {
        return this.bitSet.get(row * this.cols + col);
    }

    public void mark(int col, int row) {
        this.bitSet.set(row * this.cols + col);
    }

    public void unMark(int col, int row) {
        this.bitSet.set(row * this.cols + col, false);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int r = 0; r < this.rows; ++r) {
            for (int c = 0; c < this.cols; ++c) {
                if (this.isMarked(c, r)) {
                    sb.append("1 ");
                    continue;
                }
                sb.append("0 ");
            }
            sb.append("\n");
        }
        return sb.toString();
    }
}

