/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gears.utils;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.BitSet;

public class ByteUtilities {
    public static byte[] shortToByteArrayBE(short data) {
        return new byte[]{(byte)(data >> 8 & 0xFF), (byte)(data >> 0 & 0xFF)};
    }

    public static byte[] charToByteArrayBE(char data) {
        return new byte[]{(byte)(data >> 8 & 0xFF), (byte)(data >> 0 & 0xFF)};
    }

    public static byte[] intToByteArrayBE(int data) {
        return new byte[]{(byte)(data >> 24 & 0xFF), (byte)(data >> 16 & 0xFF), (byte)(data >> 8 & 0xFF), (byte)(data >> 0 & 0xFF)};
    }

    public static byte[] longToByteArrayBE(long data) {
        return new byte[]{(byte)(data >> 56 & 0xFFL), (byte)(data >> 48 & 0xFFL), (byte)(data >> 40 & 0xFFL), (byte)(data >> 32 & 0xFFL), (byte)(data >> 24 & 0xFFL), (byte)(data >> 16 & 0xFFL), (byte)(data >> 8 & 0xFFL), (byte)(data >> 0 & 0xFFL)};
    }

    public static byte[] floatToByteArrayBE(float data) {
        return ByteUtilities.intToByteArrayBE(Float.floatToRawIntBits(data));
    }

    public static byte[] doubleToByteArrayBE(double data) {
        return ByteUtilities.longToByteArrayBE(Double.doubleToRawLongBits(data));
    }

    public static byte[] booleanToByteArrayBE(boolean data) {
        return new byte[]{(byte)(data ? 1 : 0)};
    }

    public static short byteArrayToShortBE(byte[] data) {
        if (data == null || data.length != 2) {
            return 0;
        }
        return (short)((0xFF & data[0]) << 8 | (0xFF & data[1]) << 0);
    }

    public static short byteArrayToShortLE(byte[] data) {
        ByteBuffer buffer = ByteBuffer.wrap(data);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        return buffer.getShort();
    }

    public static char byteArrayToCharBE(byte[] data) {
        if (data == null || data.length != 2) {
            return '\u0000';
        }
        return (char)((0xFF & data[0]) << 8 | (0xFF & data[1]) << 0);
    }

    public static int byteArrayToIntBE(byte[] data) {
        if (data == null || data.length != 4) {
            return 0;
        }
        return (0xFF & data[0]) << 24 | (0xFF & data[1]) << 16 | (0xFF & data[2]) << 8 | (0xFF & data[3]) << 0;
    }

    public static int byteArrayToIntLE(byte[] data) {
        ByteBuffer buffer = ByteBuffer.wrap(data);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        return buffer.getInt();
    }

    public static long byteArrayToLongBE(byte[] data) {
        if (data == null) {
            return 0L;
        }
        long accum = 0L;
        int shiftBy = 8 * data.length - 8;
        for (byte b : data) {
            accum |= (long)(0xFF & b) << shiftBy;
            shiftBy -= 8;
        }
        return accum;
    }

    public static long byteArrayToLongLE(byte[] data) {
        if (data == null) {
            return 0L;
        }
        long accum = 0L;
        int shiftBy = 0;
        for (byte b : data) {
            accum |= (long)(b & 0xFF) << shiftBy;
            shiftBy += 8;
        }
        return accum;
    }

    public static float byteArrayToFloatBE(byte[] data) {
        if (data == null || data.length != 4) {
            return 0.0f;
        }
        return Float.intBitsToFloat(ByteUtilities.byteArrayToIntBE(data));
    }

    public static float byteArrayToFloatLE(byte[] data) {
        ByteBuffer buffer = ByteBuffer.wrap(data);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        return buffer.getFloat();
    }

    public static double byteArrayToDoubleBE(byte[] data) {
        if (data == null || data.length != 8) {
            return 0.0;
        }
        return Double.longBitsToDouble(ByteUtilities.byteArrayToLongBE(data));
    }

    public static double byteArrayToDoubleLE(byte[] data) {
        ByteBuffer buffer = ByteBuffer.wrap(data);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        return buffer.getDouble();
    }

    public static boolean byteArrayToBoolean(byte[] data) {
        return data == null || data.length == 0 ? false : data[0] != 0;
    }

    public static String byteArrayToString(byte[] data) {
        return data == null ? null : new String(data);
    }

    public static BitSet bitsetFromByteArray(byte[] bytes) {
        BitSet bits = new BitSet();
        for (int i = 0; i < bytes.length * 8; ++i) {
            if ((bytes[bytes.length - i / 8 - 1] & 1 << i % 8) <= 0) continue;
            bits.set(i);
        }
        return bits;
    }

    public static BitSet bitsetFromByte(byte thebyte) {
        BitSet bits = new BitSet();
        for (int i = 0; i < 8; ++i) {
            if ((thebyte & 1 << i % 8) <= 0) continue;
            bits.set(i);
        }
        return bits;
    }

    public static byte[] bitSetToByteArray(BitSet bs) {
        byte[] bytes = new byte[bs.size() / 8 + 1];
        for (int i = 0; i < bs.size(); ++i) {
            if (!bs.get(i)) continue;
            int n = i / 8;
            bytes[n] = (byte)(bytes[n] | 1 << i % 8);
        }
        return bytes;
    }

    public static byte[] double2bytearray(double doubleValue) {
        long l = Double.doubleToLongBits(doubleValue);
        byte[] b = new byte[8];
        int shift = 56;
        int k = 0;
        while (k < 8) {
            b[k] = (byte)(l >>> shift);
            ++k;
            shift -= 8;
        }
        return b;
    }

    public static float arr2float(byte[] arr, int start) {
        int i = 0;
        int len = 4;
        int cnt = 0;
        byte[] tmp = new byte[len];
        for (i = start; i < start + len; ++i) {
            tmp[cnt] = arr[i];
            ++cnt;
        }
        int accum = 0;
        i = 0;
        for (int shiftBy = 0; shiftBy < 32; shiftBy += 8) {
            accum = (int)((long)accum | (long)(tmp[i] & 0xFF) << shiftBy);
            ++i;
        }
        return Float.intBitsToFloat(accum);
    }

    public static long arr2long(byte[] arr, int start) {
        int i = 0;
        int len = 4;
        int cnt = 0;
        byte[] tmp = new byte[len];
        for (i = start; i < start + len; ++i) {
            tmp[cnt] = arr[i];
            ++cnt;
        }
        long accum = 0L;
        i = 0;
        for (int shiftBy = 0; shiftBy < 32; shiftBy += 8) {
            accum |= (long)(tmp[i] & 0xFF) << shiftBy;
            ++i;
        }
        return accum;
    }

    public static int arr2int(byte[] arr, int start) {
        int low = arr[start] & 0xFF;
        int high = arr[start + 1] & 0xFF;
        return high << 8 | low;
    }

    public static double arr2double(byte[] arr, int start) {
        int i = 0;
        int len = 8;
        int cnt = 0;
        byte[] tmp = new byte[len];
        for (i = start; i < start + len; ++i) {
            tmp[cnt] = arr[i];
            ++cnt;
        }
        long accum = 0L;
        i = 0;
        for (int shiftBy = 0; shiftBy < 64; shiftBy += 8) {
            accum |= (long)(tmp[i] & 0xFF) << shiftBy;
            ++i;
        }
        return Double.longBitsToDouble(accum);
    }

    public static short arr2short(byte[] arr) {
        int i = 0;
        i |= arr[0] & 0xFF;
        i <<= 8;
        return (short)(i |= arr[1] & 0xFF);
    }
}

