/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gears.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.hortonmachine.gears.libs.modules.HMConstants;
import org.joda.time.DateTime;

public class CompressionUtilities {
    public static void zipFolder(String srcFolder, String destZipFile, boolean addBaseFolder) throws IOException {
        block11: {
            if (new File(srcFolder).isDirectory()) {
                try (FileOutputStream fileWriter = new FileOutputStream(destZipFile);
                     ZipOutputStream zip = new ZipOutputStream(fileWriter);){
                    CompressionUtilities.addFolderToZip("", srcFolder, zip, addBaseFolder);
                    break block11;
                }
            }
            throw new IOException(srcFolder + " is not a folder.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zipFiles(File[] srcFiles, String destZipFile) throws IOException {
        DeflaterOutputStream zip = null;
        FileOutputStream fileWriter = null;
        try {
            fileWriter = new FileOutputStream(destZipFile);
            zip = new ZipOutputStream(fileWriter);
            for (File file : srcFiles) {
                if (file.isDirectory()) {
                    CompressionUtilities.addFolderToZip("", file.getAbsolutePath(), (ZipOutputStream)zip, true);
                    continue;
                }
                CompressionUtilities.addToZip("", file.getAbsolutePath(), (ZipOutputStream)zip);
            }
        }
        finally {
            if (zip != null) {
                zip.flush();
                ((ZipOutputStream)zip).close();
            }
            if (fileWriter != null) {
                fileWriter.close();
            }
        }
    }

    public static String unzipFolder(String zipFile, String destFolder, boolean addTimeStamp) throws IOException {
        Object newFirstName = null;
        try (ZipFile zf = new ZipFile(zipFile);){
            Enumeration<? extends ZipEntry> zipEnum = zf.entries();
            String firstName = null;
            while (zipEnum.hasMoreElements()) {
                ZipEntry item = zipEnum.nextElement();
                String itemName = item.getName();
                if (firstName == null) {
                    int firstSlash = itemName.indexOf(47);
                    if (firstSlash == -1) {
                        firstSlash = itemName.length();
                    }
                    firstName = itemName.substring(0, firstSlash);
                    newFirstName = firstName;
                    File baseFile = new File(destFolder + File.separator + firstName);
                    if (baseFile.exists()) {
                        if (addTimeStamp) {
                            newFirstName = firstName + "_" + new DateTime().toString(HMConstants.dateTimeFormatterYYYYMMDDHHMMSScompact);
                        } else {
                            throw new IOException("Not overwriting existing: " + baseFile);
                        }
                    }
                }
                if (firstName == null) {
                    throw new IOException();
                }
                itemName = itemName.replaceFirst(firstName, (String)newFirstName);
                if (item.isDirectory()) {
                    File newdir = new File(destFolder + File.separator + itemName);
                    if (newdir.mkdir()) continue;
                    throw new IOException();
                }
                String newfilePath = destFolder + File.separator + itemName;
                File newFile = new File(newfilePath);
                File parentFile = newFile.getParentFile();
                if (!parentFile.exists() && !parentFile.mkdirs()) {
                    throw new IOException();
                }
                InputStream is = zf.getInputStream(item);
                FileOutputStream fos = new FileOutputStream(newfilePath);
                byte[] buffer = new byte[512];
                int readchars = 0;
                while ((readchars = is.read(buffer)) != -1) {
                    fos.write(buffer, 0, readchars);
                }
                is.close();
                fos.close();
            }
        }
        return newFirstName;
    }

    public static File unzipSingleFile(String zipFile, String destFolder, boolean addTimeStamp) throws IOException {
        File newFile = null;
        try (ZipFile zf = new ZipFile(zipFile);){
            Enumeration<? extends ZipEntry> zipEnum = zf.entries();
            while (zipEnum.hasMoreElements()) {
                ZipEntry item = zipEnum.nextElement();
                String itemName = item.getName();
                String newfilePath = destFolder + File.separator + itemName;
                newFile = new File(newfilePath);
                File parentFile = newFile.getParentFile();
                if (!parentFile.exists() && !parentFile.mkdirs()) {
                    throw new IOException();
                }
                InputStream is = zf.getInputStream(item);
                FileOutputStream fos = new FileOutputStream(newfilePath);
                byte[] buffer = new byte[512];
                int readchars = 0;
                while ((readchars = is.read(buffer)) != -1) {
                    fos.write(buffer, 0, readchars);
                }
                is.close();
                fos.close();
            }
        }
        return newFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addToZip(String path, String srcFile, ZipOutputStream zip) throws IOException {
        File folder = new File(srcFile);
        if (folder.isDirectory()) {
            CompressionUtilities.addFolderToZip(path, srcFile, zip, true);
        } else {
            byte[] buf = new byte[1024];
            FileInputStream in = null;
            try {
                int len;
                in = new FileInputStream(srcFile);
                Object relPath = path + File.separator;
                if (path.length() == 0) {
                    relPath = "";
                }
                zip.putNextEntry(new ZipEntry((String)relPath + folder.getName()));
                while ((len = in.read(buf)) > 0) {
                    zip.write(buf, 0, len);
                }
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    private static void addFolderToZip(String path, String srcFolder, ZipOutputStream zip, boolean addFolder) throws IOException {
        File folder = new File(srcFolder);
        String[] listOfFiles = folder.list();
        for (int i = 0; i < listOfFiles.length; ++i) {
            Object folderPath = null;
            folderPath = path.length() < 1 ? (addFolder ? folder.getName() : "") : path + File.separator + folder.getName();
            String srcFile = srcFolder + File.separator + listOfFiles[i];
            CompressionUtilities.addToZip((String)folderPath, srcFile, zip);
        }
    }
}

