/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gears.utils;

import java.awt.geom.Point2D;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.referencing.GeodeticCalculator;
import org.geotools.referencing.crs.AbstractSingleCRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.hortonmachine.gears.libs.exceptions.ModelsIOException;
import org.hortonmachine.gears.utils.files.FileUtilities;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.datum.Datum;
import org.opengis.referencing.operation.MathTransform;

public class CrsUtilities {
    public static final CoordinateReferenceSystem WGS84 = DefaultGeographicCRS.WGS84;
    public static final int WGS84_SRID = 4326;
    public static final ReferencedEnvelope WORLD = new ReferencedEnvelope(-180.0, 180.0, -90.0, 90.0, WGS84);

    public static boolean isCrsValid(CoordinateReferenceSystem crs) {
        AbstractSingleCRS aCrs;
        Datum datum;
        ReferenceIdentifier name;
        String code;
        return !(crs instanceof AbstractSingleCRS) || !(code = (name = (datum = (aCrs = (AbstractSingleCRS)crs).getDatum()).getName()).getCode()).equalsIgnoreCase("Unknown");
    }

    public static void writeProjectionFile(String filePath, String extention, CoordinateReferenceSystem crs) throws IOException {
        Object prjPath = null;
        if (extention != null && filePath.toLowerCase().endsWith("." + extention)) {
            int dotLoc = filePath.lastIndexOf(".");
            prjPath = filePath.substring(0, dotLoc);
            prjPath = (String)prjPath + ".prj";
        } else {
            prjPath = !filePath.endsWith(".prj") ? filePath + ".prj" : filePath;
        }
        try (BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter((String)prjPath));){
            bufferedWriter.write(crs.toWKT());
        }
    }

    public static CoordinateReferenceSystem readProjectionFile(String filePath, String extension) throws Exception {
        CoordinateReferenceSystem crs = null;
        Object prjPath = null;
        String filePathLower = filePath.trim().toLowerCase();
        if (filePathLower.endsWith(".prj")) {
            prjPath = filePath;
        } else if (extension != null && filePathLower.endsWith("." + extension)) {
            int dotLoc = filePath.lastIndexOf(".");
            prjPath = filePath.substring(0, dotLoc);
            prjPath = (String)prjPath + ".prj";
        } else {
            prjPath = filePath + ".prj";
        }
        File prjFile = new File((String)prjPath);
        if (!prjFile.exists()) {
            throw new ModelsIOException("The prj file doesn't exist: " + (String)prjPath, "CRSUTILITIES");
        }
        String wkt = FileUtilities.readFile(prjFile);
        crs = CRS.parseWKT((String)wkt);
        return crs;
    }

    public static void reproject(CoordinateReferenceSystem from, CoordinateReferenceSystem to, Object[] geometries) throws Exception {
        MathTransform mathTransform = CRS.findMathTransform((CoordinateReferenceSystem)from, (CoordinateReferenceSystem)to);
        for (int i = 0; i < geometries.length; ++i) {
            geometries[i] = JTS.transform((Geometry)((Geometry)geometries[i]), (MathTransform)mathTransform);
        }
    }

    public static void reproject(CoordinateReferenceSystem from, CoordinateReferenceSystem to, Coordinate[] coordinates) throws Exception {
        MathTransform mathTransform = CRS.findMathTransform((CoordinateReferenceSystem)from, (CoordinateReferenceSystem)to);
        for (int i = 0; i < coordinates.length; ++i) {
            coordinates[i] = JTS.transform((Coordinate)coordinates[i], (Coordinate)coordinates[i], (MathTransform)mathTransform);
        }
    }

    public static String getCodeFromCrs(CoordinateReferenceSystem crs) throws Exception {
        Object code = null;
        try {
            Integer epsg = CrsUtilities.getSrid(crs);
            code = "EPSG:" + epsg;
        }
        catch (Exception e) {
            code = CRS.lookupIdentifier((IdentifiedObject)crs, (boolean)true);
        }
        return code;
    }

    public static int getSrid(CoordinateReferenceSystem crs) throws FactoryException {
        Integer epsg = CRS.lookupEpsgCode((CoordinateReferenceSystem)crs, (boolean)true);
        return epsg;
    }

    public static CoordinateReferenceSystem getCrsFromSrid(int srid) {
        return CrsUtilities.getCrsFromSrid(srid, null);
    }

    public static CoordinateReferenceSystem getCrsFromSrid(int srid, Boolean doLatitudeFirst) {
        if (srid == 4326 && doLatitudeFirst == null) {
            return WGS84;
        }
        try {
            if (doLatitudeFirst == null) {
                return CRS.decode((String)("EPSG:" + srid));
            }
            return CRS.decode((String)("EPSG:" + srid), (boolean)doLatitudeFirst);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static CoordinateReferenceSystem getCrsFromEpsg(String epsgPlusCode, Boolean doLatitudeFirst) {
        String sridString = epsgPlusCode.replaceFirst("EPSG:", "").replaceFirst("epsg:", "");
        int srid = Integer.parseInt(sridString);
        return CrsUtilities.getCrsFromSrid(srid, doLatitudeFirst);
    }

    public static CoordinateReferenceSystem getCrsFromEpsg(String epsgPlusCode) {
        return CrsUtilities.getCrsFromEpsg(epsgPlusCode, null);
    }

    public static double getMetersAsWGS84(double meters, Coordinate c) {
        GeodeticCalculator gc = new GeodeticCalculator((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        gc.setStartingGeographicPoint(c.x, c.y);
        gc.setDirection(90.0, meters);
        Point2D destinationGeographicPoint = gc.getDestinationGeographicPoint();
        double degrees = Math.abs(destinationGeographicPoint.getX() - c.x);
        return degrees;
    }
}

