/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gears.utils;

import org.apache.commons.math3.linear.LUDecomposition;
import org.apache.commons.math3.linear.MatrixUtils;
import org.apache.commons.math3.linear.RealMatrix;
import org.hortonmachine.gears.utils.geometry.GeometryUtilities;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Polygon;

public class ENU {
    private static double semiMajorAxis = 6378137.0;
    private static double smeiMinorAxis = 6356752.3142;
    private static double flatness = (semiMajorAxis - smeiMinorAxis) / semiMajorAxis;
    private static double eccentricityP2 = flatness * (2.0 - flatness);
    private Coordinate _baseCoordinateLL;
    private double _lambda;
    private double _phi;
    private double _sinLambda;
    private double _cosLambda;
    private double _cosPhi;
    private double _sinPhi;
    private double _N;
    private RealMatrix _rotationMatrix;
    private double _ecefROriginX;
    private double _ecefROriginY;
    private double _ecefROriginZ;
    private RealMatrix _inverseRotationMatrix;

    public ENU(Coordinate baseCoordinateLL) {
        this.checkZ(baseCoordinateLL);
        this._baseCoordinateLL = baseCoordinateLL;
        this._lambda = Math.toRadians(baseCoordinateLL.y);
        this._phi = Math.toRadians(baseCoordinateLL.x);
        this._sinLambda = Math.sin(this._lambda);
        this._cosLambda = Math.cos(this._lambda);
        this._cosPhi = Math.cos(this._phi);
        this._sinPhi = Math.sin(this._phi);
        this._N = semiMajorAxis / Math.sqrt(1.0 - eccentricityP2 * Math.pow(this._sinLambda, 2.0));
        double[][] rot = new double[][]{{-this._sinPhi, this._cosPhi, 0.0}, {-this._cosPhi * this._sinLambda, -this._sinLambda * this._sinPhi, this._cosLambda}, {this._cosLambda * this._cosPhi, this._cosLambda * this._sinPhi, this._sinLambda}};
        this._rotationMatrix = MatrixUtils.createRealMatrix((double[][])rot);
        this._inverseRotationMatrix = new LUDecomposition(this._rotationMatrix).getSolver().getInverse();
        double h = this._baseCoordinateLL.z;
        this._ecefROriginX = (h + this._N) * this._cosLambda * this._cosPhi;
        this._ecefROriginY = (h + this._N) * this._cosLambda * this._sinPhi;
        this._ecefROriginZ = (h + (1.0 - eccentricityP2) * this._N) * this._sinLambda;
    }

    public Coordinate wgs84ToEnu(Coordinate cLL) {
        this.checkZ(cLL);
        Coordinate cEcef = this.wgs84ToEcef(cLL);
        Coordinate enu = this.ecefToEnu(cEcef);
        return enu;
    }

    public Coordinate enuToWgs84(Coordinate enu) {
        this.checkZ(enu);
        Coordinate cEcef = this.enuToEcef(enu);
        Coordinate wgs84 = this.ecefToWgs84(cEcef);
        return wgs84;
    }

    public Coordinate wgs84ToEcef(Coordinate cLL) {
        double lambda = Math.toRadians(cLL.y);
        double phi = Math.toRadians(cLL.x);
        double sinLambda = Math.sin(lambda);
        double cosLambda = Math.cos(lambda);
        double cosPhi = Math.cos(phi);
        double sinPhi = Math.sin(phi);
        double N = semiMajorAxis / Math.sqrt(1.0 - eccentricityP2 * Math.pow(sinLambda, 2.0));
        double h = cLL.z;
        double x = (h + N) * cosLambda * cosPhi;
        double y = (h + N) * cosLambda * sinPhi;
        double z = (h + (1.0 - eccentricityP2) * N) * sinLambda;
        return new Coordinate(x, y, z);
    }

    public Coordinate ecefToEnu(Coordinate cEcef) {
        double deltaX = cEcef.x - this._ecefROriginX;
        double deltaY = cEcef.y - this._ecefROriginY;
        double deltaZ = cEcef.z - this._ecefROriginZ;
        double[][] deltas = new double[][]{{deltaX}, {deltaY}, {deltaZ}};
        RealMatrix deltaMatrix = MatrixUtils.createRealMatrix((double[][])deltas);
        RealMatrix enuMatrix = this._rotationMatrix.multiply(deltaMatrix);
        double[] column = enuMatrix.getColumn(0);
        return new Coordinate(column[0], column[1], column[2]);
    }

    public Coordinate enuToEcef(Coordinate cEnu) {
        double[][] enu = new double[][]{{cEnu.x}, {cEnu.y}, {cEnu.z}};
        RealMatrix enuMatrix = MatrixUtils.createRealMatrix((double[][])enu);
        RealMatrix deltasMatrix = this._inverseRotationMatrix.multiply(enuMatrix);
        double[] column = deltasMatrix.getColumn(0);
        double cecfX = column[0] + this._ecefROriginX;
        double cecfY = column[1] + this._ecefROriginY;
        double cecfZ = column[2] + this._ecefROriginZ;
        return new Coordinate(cecfX, cecfY, cecfZ);
    }

    public Coordinate ecefToWgs84(Coordinate ecef) {
        double r = Math.sqrt(Math.pow(ecef.x, 2.0) + Math.pow(ecef.y, 2.0) + Math.pow(ecef.z, 2.0));
        double lamGeoc = Math.atan2(ecef.y, ecef.x);
        double phiGeoc = Math.atan(ecef.z / Math.sqrt(Math.pow(ecef.x, 2.0) + Math.pow(ecef.y, 2.0)));
        double psi = Math.atan(Math.tan(phiGeoc) / Math.sqrt(1.0 - eccentricityP2));
        double phiGeod = Math.atan((r * Math.sin(phiGeoc) + eccentricityP2 * semiMajorAxis / Math.sqrt(1.0 - eccentricityP2) * Math.pow(Math.sin(psi), 3.0)) / (r * Math.cos(phiGeoc) - eccentricityP2 * semiMajorAxis * Math.pow(Math.cos(psi), 3.0)));
        double lamGeod = lamGeoc;
        double N = semiMajorAxis / Math.sqrt(1.0 - eccentricityP2 * Math.pow(Math.sin(phiGeod), 2.0));
        double h = r * Math.cos(phiGeoc) / Math.cos(phiGeod) - N;
        double lon = Math.toDegrees(lamGeod);
        double lat = Math.toDegrees(phiGeod);
        return new Coordinate(lon, lat, h);
    }

    public void convertGeometryFromEnuToWgs84(Geometry geometryEnu) {
        Coordinate[] coordinates = geometryEnu.getCoordinates();
        for (int i = 0; i < coordinates.length; ++i) {
            Coordinate wgs84 = this.enuToWgs84(coordinates[i]);
            coordinates[i].x = wgs84.x;
            coordinates[i].y = wgs84.y;
            coordinates[i].z = wgs84.z;
        }
    }

    public void convertGeometryFromWgsToEnu(Geometry geometryWgs) {
        Coordinate[] coordinates = geometryWgs.getCoordinates();
        for (int i = 0; i < coordinates.length; ++i) {
            Coordinate enu = this.wgs84ToEnu(coordinates[i]);
            coordinates[i].x = enu.x;
            coordinates[i].y = enu.y;
            coordinates[i].z = enu.z;
        }
    }

    public Envelope convertEnvelopeFromWgsToEnu(Envelope envelopeWgs) {
        Polygon polygonEnu = GeometryUtilities.createPolygonFromEnvelope(envelopeWgs);
        this.convertGeometryFromWgsToEnu((Geometry)polygonEnu);
        Envelope envelopeEnu = polygonEnu.getEnvelopeInternal();
        return envelopeEnu;
    }

    private void checkZ(Coordinate coordinate) {
        if (Double.isNaN(coordinate.z)) {
            coordinate.z = 0.0;
        }
    }
}

