/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gears.utils;

import java.awt.ComponentOrientation;
import java.io.File;
import java.util.prefs.Preferences;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hortonmachine.dbs.log.PreferencesDb;

public class PreferencesHandler {
    public static final String HM_PREF_PROXYPWD = "hm_pref_proxypwd";
    public static final String HM_PREF_PROXYUSER = "hm_pref_proxyuser";
    public static final String HM_PREF_PROXYPORT = "hm_pref_proxyport";
    public static final String HM_PREF_PROXYHOST = "hm_pref_proxyhost";
    public static final String HM_PREF_PROXYCHECK = "hm_pref_proxycheck";
    public static final String HM_PREF_SHP_CHARSET = "hm_pref_shp_charset";
    public static final String PREFS_NODE_NAME = "/org/hortonmachine/gui";
    public static final String LAST_PATH = "KEY_LAST_PATH";
    public static final String PREF_STRING_SEPARATORS = "@@@@";
    public static final String PREF_ORIENTATION = "PREF_ORIENTATION";
    public static final String LEFT_TO_RIGHT = "LEFT_TO_RIGHT";
    public static final String RIGHT_TO_LEFT = "RIGHT_TO_LEFT";
    private static PreferencesDb preferencesDb = PreferencesDb.INSTANCE;

    public static File getLastFile() {
        String userHome;
        Preferences preferences = Preferences.userRoot().node(PREFS_NODE_NAME);
        String lastPath = preferences.get(LAST_PATH, userHome = System.getProperty("user.home"));
        File file = new File(lastPath);
        if (!file.exists()) {
            return new File(userHome);
        }
        return file;
    }

    public static void setLastPath(String lastPath) {
        File file = new File(lastPath);
        if (!file.isDirectory()) {
            lastPath = file.getParentFile().getAbsolutePath();
        }
        Preferences preferences = Preferences.userRoot().node(PREFS_NODE_NAME);
        preferences.put(LAST_PATH, lastPath);
    }

    public static String getPreference(String preferenceKey, String defaultValue) {
        if (preferencesDb != null) {
            return preferencesDb.getPreference(preferenceKey, defaultValue);
        }
        Preferences preferences = Preferences.userRoot().node(PREFS_NODE_NAME);
        String preference = preferences.get(preferenceKey, defaultValue);
        return preference;
    }

    public static String[] getPreference(String preferenceKey, String[] defaultValue) {
        if (preferencesDb != null) {
            return preferencesDb.getPreference(preferenceKey, defaultValue);
        }
        Preferences preferences = Preferences.userRoot().node(PREFS_NODE_NAME);
        String preference = preferences.get(preferenceKey, "");
        String[] split = preference.split(PREF_STRING_SEPARATORS);
        return split;
    }

    public static byte[] getPreference(String preferenceKey, byte[] defaultValue) {
        if (preferencesDb != null) {
            return preferencesDb.getPreference(preferenceKey, defaultValue);
        }
        Preferences preferences = Preferences.userRoot().node(PREFS_NODE_NAME);
        byte[] preference = preferences.getByteArray(preferenceKey, defaultValue);
        return preference;
    }

    public static void setPreference(String preferenceKey, String value) {
        if (preferencesDb != null) {
            preferencesDb.setPreference(preferenceKey, (Object)value);
            return;
        }
        Preferences preferences = Preferences.userRoot().node(PREFS_NODE_NAME);
        if (value != null) {
            preferences.put(preferenceKey, value);
        } else {
            preferences.remove(preferenceKey);
        }
    }

    public static void setPreference(String preferenceKey, byte[] value) {
        if (preferencesDb != null) {
            preferencesDb.setPreference(preferenceKey, (Object)value);
            return;
        }
        Preferences preferences = Preferences.userRoot().node(PREFS_NODE_NAME);
        if (value != null) {
            preferences.putByteArray(preferenceKey, value);
        } else {
            preferences.remove(preferenceKey);
        }
    }

    public static void setPreference(String preferenceKey, String[] valuesArray) {
        if (preferencesDb != null) {
            preferencesDb.setPreference(preferenceKey, (Object)valuesArray);
            return;
        }
        Preferences preferences = Preferences.userRoot().node(PREFS_NODE_NAME);
        if (valuesArray != null) {
            int maxLength = 8192;
            String arrayToString = Stream.of(valuesArray).collect(Collectors.joining(PREF_STRING_SEPARATORS));
            int remIndex = valuesArray.length - 1;
            while (arrayToString.length() > maxLength) {
                valuesArray[remIndex--] = "";
                arrayToString = Stream.of(valuesArray).collect(Collectors.joining(PREF_STRING_SEPARATORS));
            }
            preferences.put(preferenceKey, arrayToString);
        } else {
            preferences.remove(preferenceKey);
        }
    }

    public static String getShpCharset() {
        String charset = PreferencesHandler.getPreference(HM_PREF_SHP_CHARSET, "");
        return charset.trim().length() == 0 ? null : charset;
    }

    public static ComponentOrientation getComponentOrientation() {
        String orientationString = PreferencesHandler.getPreference(PREF_ORIENTATION, LEFT_TO_RIGHT);
        if (orientationString.equals(RIGHT_TO_LEFT)) {
            return ComponentOrientation.RIGHT_TO_LEFT;
        }
        return ComponentOrientation.LEFT_TO_RIGHT;
    }

    public static void saveComponentOrientation(ComponentOrientation orientation) {
        PreferencesHandler.setPreference(PREF_ORIENTATION, orientation.isLeftToRight() ? LEFT_TO_RIGHT : RIGHT_TO_LEFT);
    }

    public static void saveComponentOrientation(String orientationString) {
        PreferencesHandler.setPreference(PREF_ORIENTATION, orientationString);
    }

    public static String getShpDoIndex() {
        return null;
    }

    static {
        if (!preferencesDb.isValid()) {
            preferencesDb = null;
        }
    }
}

