/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gears.utils;

import java.util.HashMap;
import org.hortonmachine.gears.utils.coverage.CoverageUtilities;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;

public class RegionMap
extends HashMap<String, Double> {
    private static final long serialVersionUID = 1L;

    public int getCols() {
        Double cols = (Double)this.get("COLS");
        if (cols != null) {
            return cols.intValue();
        }
        return -1;
    }

    public int getRows() {
        Double rows = (Double)this.get("ROWS");
        if (rows != null) {
            return rows.intValue();
        }
        return -1;
    }

    public double getNorth() {
        Double n = (Double)this.get("NORTH");
        if (n != null) {
            return n;
        }
        return -9999.0;
    }

    public double getSouth() {
        Double s = (Double)this.get("SOUTH");
        if (s != null) {
            return s;
        }
        return -9999.0;
    }

    public double getEast() {
        Double e = (Double)this.get("EAST");
        if (e != null) {
            return e;
        }
        return -9999.0;
    }

    public double getWest() {
        Double w = (Double)this.get("WEST");
        if (w != null) {
            return w;
        }
        return -9999.0;
    }

    public double getXres() {
        Double xres = (Double)this.get("XRES");
        if (xres != null) {
            return xres;
        }
        return -9999.0;
    }

    public double getYres() {
        Double yres = (Double)this.get("YRES");
        if (yres != null) {
            return yres;
        }
        return -9999.0;
    }

    public double getWidth() {
        return this.getEast() - this.getWest();
    }

    public double getHeight() {
        return this.getNorth() - this.getSouth();
    }

    public Coordinate snapToNextHigherInRegionResolution(double x, double y) {
        double minx = this.getWest();
        double ewres = this.getXres();
        double xsnap = minx + Math.ceil((x - minx) / ewres) * ewres;
        double miny = this.getSouth();
        double nsres = this.getYres();
        double ysnap = miny + Math.ceil((y - miny) / nsres) * nsres;
        return new Coordinate(xsnap, ysnap);
    }

    public Envelope toEnvelope() {
        Envelope env = new Envelope(this.getWest(), this.getEast(), this.getSouth(), this.getNorth());
        return env;
    }

    public RegionMap toSubRegion(double n, double s, double w, double e) {
        double newHeight;
        double deltaH;
        double originalXres = this.getXres();
        double originalYres = this.getYres();
        double originalWest = this.getWest();
        double originalSouth = this.getSouth();
        double envWest = w;
        double deltaX = (envWest - originalWest) % originalXres;
        double newWest = envWest - deltaX;
        double envSouth = s;
        double deltaY = (envSouth - originalSouth) % originalYres;
        double newSouth = envSouth - deltaY;
        double newWidth = e - w;
        double deltaW = newWidth % originalXres;
        if (deltaW > 0.0) {
            newWidth = newWidth - deltaW + originalXres;
        }
        if ((deltaH = (newHeight = n - s) % originalYres) > 0.0) {
            newHeight = newHeight - deltaH + originalYres;
        }
        double newNorth = newSouth + newHeight;
        double newEast = newWest + newWidth;
        int rows = (int)(newHeight / originalYres);
        int cols = (int)(newWidth / originalXres);
        double newXres = newWidth / (double)cols;
        double newYres = newHeight / (double)rows;
        RegionMap regionMap = CoverageUtilities.makeRegionParamsMap(newNorth, newSouth, newWest, newEast, newXres, newYres, cols, rows);
        return regionMap;
    }

    public RegionMap toSubRegion(Envelope envelope) {
        double w = envelope.getMinX();
        double s = envelope.getMinY();
        double e = envelope.getMaxX();
        double n = envelope.getMaxY();
        return this.toSubRegion(n, s, w, e);
    }

    public String toStringJGT() {
        StringBuilder sb = new StringBuilder();
        sb.append("North = ").append(this.getNorth()).append("\n");
        sb.append("South = ").append(this.getSouth()).append("\n");
        sb.append("East = ").append(this.getEast()).append("\n");
        sb.append("West = ").append(this.getWest()).append("\n");
        sb.append("Rows = ").append(this.getRows()).append("\n");
        sb.append("Cols = ").append(this.getCols()).append("\n");
        sb.append("Xres = ").append(this.getXres()).append("\n");
        sb.append("Yres = ").append(this.getYres());
        return sb.toString();
    }
}

