/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gears.utils;

import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.NameImpl;
import org.geotools.styling.ColorMapEntry;
import org.geotools.styling.FeatureTypeConstraint;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.RasterSymbolizer;
import org.geotools.styling.SLD;
import org.geotools.styling.Style;
import org.geotools.styling.StyleBuilder;
import org.geotools.styling.StyleFactory;
import org.geotools.styling.StyledLayer;
import org.geotools.styling.StyledLayerDescriptor;
import org.geotools.styling.Symbolizer;
import org.geotools.styling.UserLayer;
import org.geotools.util.factory.GeoTools;
import org.geotools.util.factory.Hints;
import org.geotools.xml.styling.SLDTransformer;
import org.hortonmachine.gears.io.grasslegacy.map.color.ColorRule;
import org.hortonmachine.gears.io.grasslegacy.map.color.GrassColorTable;
import org.hortonmachine.gears.utils.coverage.CoverageUtilities;
import org.hortonmachine.gears.utils.files.FileUtilities;
import org.hortonmachine.gears.utils.style.sld.SLDHandler;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.expression.Expression;
import org.opengis.style.ColorMap;

public class SldUtilities {
    public static final String SLD_EXTENSION = "sld";
    public static StyleFactory sf = CommonFactoryFinder.getStyleFactory((Hints)GeoTools.getDefaultHints());
    public static FilterFactory ff = CommonFactoryFinder.getFilterFactory((Hints)GeoTools.getDefaultHints());
    public static StyleBuilder sb = new StyleBuilder(sf, ff);
    public static final String GENERIC_FEATURE_TYPENAME = "Feature";

    public static Style getStyleFromFile(File file) {
        try {
            File styleFile = SldUtilities.getStyleFile(file);
            if (styleFile == null) {
                return null;
            }
            String sldString = FileUtilities.readFile(styleFile);
            return SldUtilities.getStyleFromSldString(sldString);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static File getStyleFile(File dataFile) {
        String name = dataFile.getName();
        if (!name.toLowerCase().endsWith(SLD_EXTENSION)) {
            String nameWithoutExtention = FileUtilities.getNameWithoutExtention(dataFile);
            File sldFile = new File(dataFile.getParentFile(), nameWithoutExtention + ".sld");
            if (sldFile.exists()) {
                return sldFile;
            }
            return null;
        }
        return dataFile;
    }

    public static Style getStyleFromSldString(String sldString) throws IOException {
        if (sldString == null) {
            return null;
        }
        SLDHandler h = new SLDHandler();
        StyledLayerDescriptor sld = h.parse(sldString, null, null, null);
        Style style = SldUtilities.getDefaultStyle(sld);
        return style;
    }

    public static Style getStyleFromRasterFile(File file) throws Exception {
        String coveragePath = file.getAbsolutePath();
        if (CoverageUtilities.isGrass(coveragePath)) {
            return SldUtilities.getGrassStyle(coveragePath);
        }
        RasterSymbolizer sym = sf.getDefaultRasterSymbolizer();
        return SLD.wrapSymbolizers((Symbolizer[])new Symbolizer[]{sym});
    }

    public static Style getGrassStyle(String path) throws Exception {
        ArrayList<String> valuesList = new ArrayList<String>();
        ArrayList<Color> colorsList = new ArrayList<Color>();
        StyleBuilder sB = new StyleBuilder(sf);
        RasterSymbolizer rasterSym = sf.createRasterSymbolizer();
        File grassFile = new File(path);
        String mapName = grassFile.getName();
        String mapsetPath = grassFile.getParentFile().getParent();
        GrassColorTable ctable = new GrassColorTable(mapsetPath, mapName, null);
        Enumeration<ColorRule> rules = ctable.getColorRules();
        while (rules.hasMoreElements()) {
            String to;
            ColorRule element = rules.nextElement();
            float fromValue = element.getLowCategoryValue();
            float toValue = element.getLowCategoryValue() + element.getCategoryRange();
            byte[] lowcatcol = element.getColor(fromValue);
            byte[] highcatcol = element.getColor(toValue);
            Color fromColor = new Color(lowcatcol[0] & 0xFF, lowcatcol[1] & 0xFF, lowcatcol[2] & 0xFF);
            Color toColor = new Color(highcatcol[0] & 0xFF, highcatcol[1] & 0xFF, highcatcol[2] & 0xFF);
            String from = String.valueOf(fromValue);
            if (!valuesList.contains(from)) {
                valuesList.add(from);
                colorsList.add(fromColor);
            }
            if (valuesList.contains(to = String.valueOf(toValue))) continue;
            valuesList.add(to);
            colorsList.add(toColor);
        }
        org.geotools.styling.ColorMap colorMap = sf.createColorMap();
        if (valuesList.size() > 1) {
            for (int i = 0; i < valuesList.size(); ++i) {
                String fromValueStr = (String)valuesList.get(i);
                Color fromColor = (Color)colorsList.get(i);
                Expression fromColorExpr = sB.colorExpression(new Color(fromColor.getRed(), fromColor.getGreen(), fromColor.getBlue(), 255));
                Expression fromExpr = sB.literalExpression(Double.parseDouble(fromValueStr));
                ColorMapEntry entry = sf.createColorMapEntry();
                entry.setQuantity(fromExpr);
                entry.setColor(fromColorExpr);
                colorMap.addColorMapEntry(entry);
            }
        } else if (valuesList.size() == 1) {
            String fromValueStr = (String)valuesList.get(0);
            Color fromColor = (Color)colorsList.get(0);
            Expression fromColorExpr = sB.colorExpression(new Color(fromColor.getRed(), fromColor.getGreen(), fromColor.getBlue(), 255));
            Expression fromExpr = sB.literalExpression(Double.parseDouble(fromValueStr));
            ColorMapEntry entry = sf.createColorMapEntry();
            entry.setQuantity(fromExpr);
            entry.setColor(fromColorExpr);
            colorMap.addColorMapEntry(entry);
            colorMap.addColorMapEntry(entry);
        } else {
            throw new IllegalArgumentException();
        }
        rasterSym.setColorMap((ColorMap)colorMap);
        int alpha = ctable.getAlpha();
        rasterSym.setOpacity(sB.literalExpression((double)alpha / 255.0));
        Style newStyle = SLD.wrapSymbolizers((Symbolizer[])new Symbolizer[]{rasterSym});
        return newStyle;
    }

    public static String styleToString(Style style) throws Exception {
        StyledLayerDescriptor sld = sf.createStyledLayerDescriptor();
        UserLayer layer = sf.createUserLayer();
        layer.setLayerFeatureConstraints(new FeatureTypeConstraint[]{null});
        sld.addStyledLayer((StyledLayer)layer);
        layer.addUserStyle(style);
        SLDTransformer aTransformer = new SLDTransformer();
        aTransformer.setIndentation(4);
        String xml = aTransformer.transform((Object)sld);
        return xml;
    }

    public static Style getDefaultStyle(StyledLayerDescriptor sld) {
        Style[] styles = SLD.styles((StyledLayerDescriptor)sld);
        for (int i = 0; i < styles.length; ++i) {
            Style style = styles[i];
            List ftStyles = style.featureTypeStyles();
            SldUtilities.genericizeftStyles(ftStyles);
            if (!style.isDefault()) continue;
            return style;
        }
        return styles[0];
    }

    private static void genericizeftStyles(List<FeatureTypeStyle> ftStyles) {
        for (FeatureTypeStyle featureTypeStyle : ftStyles) {
            featureTypeStyle.featureTypeNames().clear();
            featureTypeStyle.featureTypeNames().add(new NameImpl(GENERIC_FEATURE_TYPENAME));
        }
    }

    public static Color colorWithoutAlpha(Color color) {
        return new Color(color.getRed(), color.getGreen(), color.getBlue());
    }

    public static Color colorWithAlpha(Color color, int alpha) {
        return new Color(color.getRed(), color.getGreen(), color.getBlue(), alpha);
    }
}

